/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.diseasemodels.experimental.impl;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.stem.core.graph.DynamicLabel;
import org.eclipse.stem.core.graph.Exchange;
import org.eclipse.stem.core.graph.ExchangePool;
import org.eclipse.stem.core.graph.ExchangeType;
import org.eclipse.stem.core.graph.IntegrationLabel;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.diseasemodels.experimental.ExperimentalPackage;
import org.eclipse.stem.diseasemodels.experimental.PercolationDiseaseModel;
import org.eclipse.stem.diseasemodels.experimental.impl.LogDiseaseState;
import org.eclipse.stem.diseasemodels.standard.SEIRLabelValue;
import org.eclipse.stem.diseasemodels.standard.StandardDiseaseModelLabel;
import org.eclipse.stem.diseasemodels.standard.StandardDiseaseModelLabelValue;
import org.eclipse.stem.diseasemodels.standard.StandardPackage;
import org.eclipse.stem.diseasemodels.standard.impl.SEIRImpl;
import org.eclipse.stem.diseasemodels.standard.impl.SEIRLabelValueImpl;

public class PercolationDiseaseModelImpl
extends SEIRImpl
implements PercolationDiseaseModel {
    LogDiseaseState lds = null;
    int icount = 0;
    static boolean logComplete = false;

    public void calculateDeltas(STEMTime time, double t, long timeDelta, EList<DynamicLabel> labels) {
        int _i = 0;
        while (_i < labels.size()) {
            DynamicLabel label = (DynamicLabel)labels.get(_i);
            IntegrationLabel ilabel = (IntegrationLabel)label;
            StandardDiseaseModelLabel diseaseLabel = (StandardDiseaseModelLabel)ilabel;
            StandardDiseaseModelLabelValue currentState = (StandardDiseaseModelLabelValue)ilabel.getProbeValue();
            StandardDiseaseModelLabelValue deltaValue = (StandardDiseaseModelLabelValue)ilabel.getDeltaValue();
            deltaValue.reset();
            SEIRLabelValue currentSEIR = (SEIRLabelValue)currentState;
            double transmisionRate = this.getAdjustedTransmissionRate(timeDelta) * this.getTransmissionRateScaleFactor(diseaseLabel);
            double den = currentSEIR.getPopulationCount();
            double se = (currentSEIR.getS() + currentSEIR.getE() + currentSEIR.getI()) / den;
            double percFact = 1.0;
            double localTransmisionCoefficient = 0.0;
            if (se >= 0.25) {
                double percNum = se - 0.25;
                if (percNum <= 0.0) {
                    percNum = 0.0;
                }
                double percNorm = 0.75;
                percFact = Math.pow(percNum / percNorm, this.getNonLinearityCoefficient());
                localTransmisionCoefficient = transmisionRate * percFact;
            } else {
                localTransmisionCoefficient = 0.0;
            }
            if (this.lds == null) {
                int inc = (int)(this.getIncubationRate() * 100.0);
                int beta = (int)(this.getTransmissionRate() * 100.0);
                int rec = (int)(this.getRecoveryRate() * 100.0);
                int imloss = (int)(this.getImmunityLossRate() * 1000.0);
                this.lds = new LogDiseaseState("./timelogI" + inc + "B" + beta + "il" + imloss + "r" + rec + ".txt");
            }
            double pd = 1.0 / currentSEIR.getPopulationCount();
            String str = String.valueOf(this.icount) + ", " + currentSEIR.getS() * pd + ", " + currentSEIR.getE() * pd + ", " + currentSEIR.getI() * pd + ", " + currentSEIR.getR() * pd + "\n";
            if (this.icount <= 500) {
                this.lds.write(str);
                ++this.icount;
            }
            if (this.icount == 501 && !logComplete && this.lds != null) {
                LogDiseaseState.close();
                logComplete = true;
            }
            double effectiveInfectious = this.getNormalizedEffectiveInfectious(diseaseLabel.getNode(), diseaseLabel, currentSEIR.getI(), StandardPackage.Literals.SI_LABEL_VALUE__I, StandardPackage.Literals.STANDARD_DISEASE_MODEL__CHARACTERISTIC_MIXING_DISTANCE, StandardPackage.Literals.STANDARD_DISEASE_MODEL__ROAD_NETWORK_INFECTIOUS_PROPORTION);
            double numberOfInfectedToRecovered = this.getAdjustedRecoveryRate(timeDelta) * currentSEIR.getI();
            double numberOfRecoveredToSusceptible = this.getAdjustedImmunityLossRate(timeDelta) * currentSEIR.getR();
            double numberOfSusceptibleToExposed = localTransmisionCoefficient * currentSEIR.getS() * effectiveInfectious;
            double numberOfExposedToInfectious = this.getAdjustedIncubationRate(timeDelta) * currentSEIR.getE();
            double deltaS = numberOfRecoveredToSusceptible - numberOfSusceptibleToExposed;
            double deltaE = numberOfSusceptibleToExposed - numberOfExposedToInfectious;
            double deltaI = numberOfExposedToInfectious - numberOfInfectedToRecovered;
            double deltaR = numberOfInfectedToRecovered - numberOfRecoveredToSusceptible;
            Exchange seExchange = (Exchange)ExchangePool.POOL.get();
            seExchange.setSource(StandardPackage.eINSTANCE.getStandardDiseaseModelLabelValue_S());
            seExchange.setTarget(StandardPackage.eINSTANCE.getSEIRLabelValue_E());
            seExchange.setCount(numberOfSusceptibleToExposed);
            seExchange.getForIncidence().add((Object)StandardPackage.eINSTANCE.getStandardDiseaseModelLabelValue_Incidence());
            seExchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
            deltaValue.getDepartures().add((Object)seExchange);
            Exchange eiExchange = (Exchange)ExchangePool.POOL.get();
            eiExchange.setSource(StandardPackage.eINSTANCE.getSEIRLabelValue_E());
            eiExchange.setTarget(StandardPackage.eINSTANCE.getSILabelValue_I());
            eiExchange.setCount(numberOfExposedToInfectious);
            eiExchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
            deltaValue.getDepartures().add((Object)eiExchange);
            Exchange irExchange = (Exchange)ExchangePool.POOL.get();
            irExchange.setSource(StandardPackage.eINSTANCE.getSILabelValue_I());
            irExchange.setTarget(StandardPackage.eINSTANCE.getSIRLabelValue_R());
            irExchange.setCount(numberOfInfectedToRecovered);
            irExchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
            deltaValue.getDepartures().add((Object)irExchange);
            Exchange rsExchange = (Exchange)ExchangePool.POOL.get();
            rsExchange.setSource(StandardPackage.eINSTANCE.getSIRLabelValue_R());
            rsExchange.setTarget(StandardPackage.eINSTANCE.getStandardDiseaseModelLabelValue_S());
            rsExchange.setCount(numberOfRecoveredToSusceptible);
            rsExchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
            deltaValue.getDepartures().add((Object)rsExchange);
            SEIRLabelValueImpl ret = (SEIRLabelValueImpl)deltaValue;
            ret.setS(deltaS);
            ret.setE(deltaE);
            ret.setI(deltaI);
            ret.setIncidence(numberOfSusceptibleToExposed);
            ret.setR(deltaR);
            ret.setDiseaseDeaths(0.0);
            this.computeAdditionalDeltasAndExchanges(ilabel, time, t, timeDelta);
            ++_i;
        }
    }

    protected EClass eStaticClass() {
        return ExperimentalPackage.Literals.PERCOLATION_DISEASE_MODEL;
    }
}

