/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.formatting;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtend.core.formatting.Chunk;
import org.eclipse.xtend.core.formatting.Line;
import org.eclipse.xtend.core.formatting.LineModel;
import org.eclipse.xtend.core.formatting.RichStringToLineModel;
import org.eclipse.xtend.core.formatting.SemanticWhitespace;
import org.eclipse.xtend.core.formatting.TemplateWhitespace;
import org.eclipse.xtend.core.richstring.DefaultIndentationHandler;
import org.eclipse.xtend.core.richstring.RichStringProcessor;
import org.eclipse.xtend.core.xtend.RichString;
import org.eclipse.xtend.core.xtend.RichStringElseIf;
import org.eclipse.xtend.core.xtend.RichStringForLoop;
import org.eclipse.xtend.core.xtend.RichStringIf;
import org.eclipse.xtend.core.xtend.RichStringLiteral;
import org.eclipse.xtend.core.xtend.XtendPackage;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.nodemodel.BidiTreeIterable;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.SyntaxErrorMessage;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.formatting.FormattableDocument;
import org.eclipse.xtext.xbase.formatting.FormattingData;
import org.eclipse.xtext.xbase.formatting.FormattingDataFactory;
import org.eclipse.xtext.xbase.formatting.FormattingDataInit;
import org.eclipse.xtext.xbase.formatting.NewLineData;
import org.eclipse.xtext.xbase.formatting.NodeModelAccess;
import org.eclipse.xtext.xbase.formatting.WhitespaceData;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.StringExtensions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RichStringFormatter {
    @Inject
    private RichStringProcessor richStringProcessor;
    @Inject
    @Extension
    private NodeModelAccess _nodeModelAccess;
    @Inject
    @Extension
    private FormattingDataFactory _formattingDataFactory;

    public void format(Procedures.Procedure2<? super EObject, ? super FormattableDocument> formatter, final FormattableDocument doc, RichString richString) {
        boolean _not;
        boolean _notEquals;
        EObject _eContainer = richString.eContainer();
        RichString _containerOfType = (RichString)EcoreUtil2.getContainerOfType((EObject)_eContainer, RichString.class);
        boolean bl = _notEquals = !Objects.equal((Object)_containerOfType, null);
        if (_notEquals) {
            return;
        }
        boolean _hasSyntaxError = this.hasSyntaxError((EObject)richString);
        if (_hasSyntaxError) {
            return;
        }
        RichStringToLineModel impl = new RichStringToLineModel(this._nodeModelAccess, richString);
        DefaultIndentationHandler _defaultIndentationHandler = new DefaultIndentationHandler();
        this.richStringProcessor.process(richString, impl, _defaultIndentationHandler);
        impl.finish();
        this.fmt(formatter, doc, (EObject)richString);
        LineModel _model = impl.getModel();
        List<Line> lines = _model.getLines();
        boolean _and = false;
        boolean _isEmpty = lines.isEmpty();
        boolean bl2 = _not = !_isEmpty;
        if (!_not) {
            _and = false;
        } else {
            boolean _isNullOrEmpty;
            Line _last = (Line)IterableExtensions.last(lines);
            String _content = _last.getContent();
            _and = _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)_content);
        }
        boolean canIndent = _and;
        for (Line line : lines) {
            boolean _not_1;
            boolean _greaterThan;
            LineModel _model_1 = impl.getModel();
            int _rootIndentLenght = _model_1.getRootIndentLenght();
            boolean bl3 = _greaterThan = _rootIndentLenght > 0;
            if (!_greaterThan) continue;
            int _xifexpression = 0;
            boolean _and_1 = false;
            if (!canIndent) {
                _and_1 = false;
            } else {
                boolean _equals;
                Line _head = (Line)IterableExtensions.head(lines);
                _and_1 = _equals = Objects.equal((Object)line, (Object)_head);
            }
            _xifexpression = _and_1 ? 1 : 0;
            int increaseIndentationChange = _xifexpression;
            int _xifexpression_1 = 0;
            boolean _and_2 = false;
            if (!canIndent) {
                _and_2 = false;
            } else {
                boolean _equals_1;
                Line _last_1 = (Line)IterableExtensions.last(lines);
                _and_2 = _equals_1 = Objects.equal((Object)line, (Object)_last_1);
            }
            _xifexpression_1 = _and_2 ? -1 : 0;
            int decraseIndentationChange = _xifexpression_1;
            int _xifexpression_2 = 0;
            boolean _isLeadingSemanticNewLine = line.isLeadingSemanticNewLine();
            if (_isLeadingSemanticNewLine) {
                int _offset = line.getOffset();
                int _newLineCharCount = line.getNewLineCharCount();
                _xifexpression_2 = _offset + _newLineCharCount;
            } else {
                _xifexpression_2 = line.getOffset();
            }
            int nloffset = _xifexpression_2;
            int _indentLength = line.getIndentLength();
            LineModel _model_2 = impl.getModel();
            int _rootIndentLenght_1 = _model_2.getRootIndentLenght();
            int i = Math.min(_indentLength, _rootIndentLenght_1);
            int _xifexpression_3 = 0;
            boolean _isLeadingSemanticNewLine_1 = line.isLeadingSemanticNewLine();
            if (_isLeadingSemanticNewLine_1) {
                _xifexpression_3 = i;
            } else {
                int _newLineCharCount_1 = line.getNewLineCharCount();
                _xifexpression_3 = _newLineCharCount_1 + i;
            }
            int nllength = _xifexpression_3;
            boolean _isLeadingSemanticNewLine_2 = line.isLeadingSemanticNewLine();
            if (_isLeadingSemanticNewLine_2) {
                RuntimeException _xifexpression_4 = null;
                boolean _isDebugConflicts = doc.isDebugConflicts();
                if (_isDebugConflicts) {
                    _xifexpression_4 = new RuntimeException();
                }
                NewLineData _newLineData = new NewLineData(nloffset, nllength, increaseIndentationChange, decraseIndentationChange, (Throwable)_xifexpression_4, Integer.valueOf(0));
                doc.operator_add((FormattingData)_newLineData);
            } else {
                RuntimeException _xifexpression_5 = null;
                boolean _isDebugConflicts_1 = doc.isDebugConflicts();
                if (_isDebugConflicts_1) {
                    _xifexpression_5 = new RuntimeException();
                }
                NewLineData _newLineData_1 = new NewLineData(nloffset, nllength, increaseIndentationChange, decraseIndentationChange, (Throwable)_xifexpression_5, Integer.valueOf(1));
                doc.operator_add((FormattingData)_newLineData_1);
            }
            List<Chunk> _chunks = line.getChunks();
            boolean _isEmpty_1 = _chunks.isEmpty();
            boolean bl4 = _not_1 = !_isEmpty_1;
            if (!_not_1) continue;
            int offset = nloffset + nllength;
            int _indentLength_1 = line.getIndentLength();
            LineModel _model_3 = impl.getModel();
            int _rootIndentLenght_2 = _model_3.getRootIndentLenght();
            int length = _indentLength_1 - _rootIndentLenght_2;
            List<Chunk> _chunks_1 = line.getChunks();
            Functions.Function1<Chunk, CharSequence> _function = new Functions.Function1<Chunk, CharSequence>(){

                public CharSequence apply(Chunk chunk) {
                    CharSequence _switchResult = null;
                    boolean _matched = false;
                    if (!_matched && chunk instanceof SemanticWhitespace) {
                        _matched = true;
                        _switchResult = ((SemanticWhitespace)chunk).getText();
                    }
                    if (!_matched && chunk instanceof TemplateWhitespace) {
                        _matched = true;
                        _switchResult = doc.getIndentation(1);
                    }
                    return _switchResult;
                }
            };
            List _map = ListExtensions.map(_chunks_1, (Functions.Function1)_function);
            String text = IterableExtensions.join((Iterable)_map);
            RuntimeException _xifexpression_6 = null;
            boolean _isDebugConflicts_2 = doc.isDebugConflicts();
            if (_isDebugConflicts_2) {
                _xifexpression_6 = new RuntimeException();
            }
            WhitespaceData _whitespaceData = new WhitespaceData(offset, length, 0, 0, (Throwable)_xifexpression_6, text);
            doc.operator_add((FormattingData)_whitespaceData);
        }
    }

    protected boolean hasSyntaxError(EObject obj) {
        SyntaxErrorMessage _syntaxErrorMessage;
        boolean _notEquals;
        boolean _xblockexpression = false;
        INode node = this._nodeModelAccess.nodeForEObject(obj);
        boolean _or = false;
        boolean _equals = Objects.equal((Object)node, null);
        _or = _equals ? true : (_notEquals = !Objects.equal((Object)(_syntaxErrorMessage = node.getSyntaxErrorMessage()), null));
        if (_or) {
            return true;
        }
        BidiTreeIterable _asTreeIterable = node.getAsTreeIterable();
        Functions.Function1<INode, Boolean> _function = new Functions.Function1<INode, Boolean>(){

            public Boolean apply(INode it) {
                SyntaxErrorMessage _syntaxErrorMessage = it.getSyntaxErrorMessage();
                return !Objects.equal((Object)_syntaxErrorMessage, null);
            }
        };
        _xblockexpression = IterableExtensions.exists((Iterable)_asTreeIterable, (Functions.Function1)_function);
        return _xblockexpression;
    }

    protected void _fmt(Procedures.Procedure2<? super EObject, ? super FormattableDocument> formatter, FormattableDocument doc, RichString expr) {
        EList _expressions = expr.getExpressions();
        for (XExpression e : _expressions) {
            this.fmt(formatter, doc, (EObject)e);
        }
    }

    protected void _fmt(Procedures.Procedure2<? super EObject, ? super FormattableDocument> formatter, FormattableDocument doc, RichStringLiteral expr) {
    }

    protected void _fmt(Procedures.Procedure2<? super EObject, ? super FormattableDocument> formatter, FormattableDocument doc, Void expr) {
    }

    protected void _fmt(Procedures.Procedure2<? super EObject, ? super FormattableDocument> formatter, FormattableDocument doc, XExpression expr) {
        INode _nodeForEObject = this._nodeModelAccess.nodeForEObject((EObject)expr);
        Procedures.Procedure1<FormattingDataInit> _function = new Procedures.Procedure1<FormattingDataInit>(){

            public void apply(FormattingDataInit it) {
                it.noSpace();
            }
        };
        Functions.Function1 _surround = this._formattingDataFactory.surround(_nodeForEObject, (Procedures.Procedure1)_function);
        doc.operator_add(_surround);
        formatter.apply((Object)expr, (Object)doc);
    }

    protected void _fmt(Procedures.Procedure2<? super EObject, ? super FormattableDocument> formatter, FormattableDocument doc, RichStringIf expr) {
        ILeafNode _nodeForKeyword = this._nodeModelAccess.nodeForKeyword((EObject)expr, "IF");
        Procedures.Procedure1<FormattingDataInit> _function = new Procedures.Procedure1<FormattingDataInit>(){

            public void apply(FormattingDataInit it) {
                it.noSpace();
            }
        };
        Procedures.Procedure1<FormattingDataInit> _function_1 = new Procedures.Procedure1<FormattingDataInit>(){

            public void apply(FormattingDataInit it) {
                it.oneSpace();
            }
        };
        Functions.Function1 _surround = this._formattingDataFactory.surround((INode)_nodeForKeyword, (Procedures.Procedure1)_function, (Procedures.Procedure1)_function_1);
        doc.operator_add(_surround);
        INode _nodeForFeature = this._nodeModelAccess.nodeForFeature((EObject)expr, (EStructuralFeature)XtendPackage.Literals.RICH_STRING_ELSE_IF__IF);
        Procedures.Procedure1<FormattingDataInit> _function_2 = new Procedures.Procedure1<FormattingDataInit>(){

            public void apply(FormattingDataInit it) {
                it.noSpace();
            }
        };
        Functions.Function1 _append = this._formattingDataFactory.append(_nodeForFeature, (Procedures.Procedure1)_function_2);
        doc.operator_add(_append);
        XExpression _if = expr.getIf();
        formatter.apply((Object)_if, (Object)doc);
        XExpression _then = expr.getThen();
        this.fmt(formatter, doc, (EObject)_then);
        EList<RichStringElseIf> _elseIfs = expr.getElseIfs();
        for (RichStringElseIf elseif : _elseIfs) {
            this.fmt(formatter, doc, elseif);
        }
        ILeafNode _nodeForKeyword_1 = this._nodeModelAccess.nodeForKeyword((EObject)expr, "ELSE");
        Procedures.Procedure1<FormattingDataInit> _function_3 = new Procedures.Procedure1<FormattingDataInit>(){

            public void apply(FormattingDataInit it) {
                it.noSpace();
            }
        };
        Functions.Function1 _surround_1 = this._formattingDataFactory.surround((INode)_nodeForKeyword_1, (Procedures.Procedure1)_function_3);
        doc.operator_add(_surround_1);
        XExpression _else = expr.getElse();
        this.fmt(formatter, doc, (EObject)_else);
        ILeafNode _nodeForKeyword_2 = this._nodeModelAccess.nodeForKeyword((EObject)expr, "ENDIF");
        Procedures.Procedure1<FormattingDataInit> _function_4 = new Procedures.Procedure1<FormattingDataInit>(){

            public void apply(FormattingDataInit it) {
                it.noSpace();
            }
        };
        Functions.Function1 _surround_2 = this._formattingDataFactory.surround((INode)_nodeForKeyword_2, (Procedures.Procedure1)_function_4);
        doc.operator_add(_surround_2);
    }

    protected void _fmt(Procedures.Procedure2<? super EObject, ? super FormattableDocument> formatter, FormattableDocument doc, RichStringElseIf expr) {
        ILeafNode _nodeForKeyword = this._nodeModelAccess.nodeForKeyword((EObject)expr, "ELSEIF");
        Procedures.Procedure1<FormattingDataInit> _function = new Procedures.Procedure1<FormattingDataInit>(){

            public void apply(FormattingDataInit it) {
                it.noSpace();
            }
        };
        Procedures.Procedure1<FormattingDataInit> _function_1 = new Procedures.Procedure1<FormattingDataInit>(){

            public void apply(FormattingDataInit it) {
                it.oneSpace();
            }
        };
        Functions.Function1 _surround = this._formattingDataFactory.surround((INode)_nodeForKeyword, (Procedures.Procedure1)_function, (Procedures.Procedure1)_function_1);
        doc.operator_add(_surround);
        INode _nodeForFeature = this._nodeModelAccess.nodeForFeature((EObject)expr, (EStructuralFeature)XtendPackage.Literals.RICH_STRING_ELSE_IF__IF);
        Procedures.Procedure1<FormattingDataInit> _function_2 = new Procedures.Procedure1<FormattingDataInit>(){

            public void apply(FormattingDataInit it) {
                it.noSpace();
            }
        };
        Functions.Function1 _append = this._formattingDataFactory.append(_nodeForFeature, (Procedures.Procedure1)_function_2);
        doc.operator_add(_append);
        XExpression _if = expr.getIf();
        formatter.apply((Object)_if, (Object)doc);
    }

    protected void _fmt(Procedures.Procedure2<? super EObject, ? super FormattableDocument> formatter, FormattableDocument doc, RichStringForLoop expr) {
        ILeafNode _nodeForKeyword = this._nodeModelAccess.nodeForKeyword((EObject)expr, "FOR");
        Procedures.Procedure1<FormattingDataInit> _function = new Procedures.Procedure1<FormattingDataInit>(){

            public void apply(FormattingDataInit it) {
                it.noSpace();
            }
        };
        Procedures.Procedure1<FormattingDataInit> _function_1 = new Procedures.Procedure1<FormattingDataInit>(){

            public void apply(FormattingDataInit it) {
                it.oneSpace();
            }
        };
        Functions.Function1 _surround = this._formattingDataFactory.surround((INode)_nodeForKeyword, (Procedures.Procedure1)_function, (Procedures.Procedure1)_function_1);
        doc.operator_add(_surround);
        ILeafNode _nodeForKeyword_1 = this._nodeModelAccess.nodeForKeyword((EObject)expr, ":");
        Procedures.Procedure1<FormattingDataInit> _function_2 = new Procedures.Procedure1<FormattingDataInit>(){

            public void apply(FormattingDataInit it) {
                it.oneSpace();
            }
        };
        Procedures.Procedure1<FormattingDataInit> _function_3 = new Procedures.Procedure1<FormattingDataInit>(){

            public void apply(FormattingDataInit it) {
                it.oneSpace();
            }
        };
        Functions.Function1 _surround_1 = this._formattingDataFactory.surround((INode)_nodeForKeyword_1, (Procedures.Procedure1)_function_2, (Procedures.Procedure1)_function_3);
        doc.operator_add(_surround_1);
        JvmFormalParameter _declaredParam = expr.getDeclaredParam();
        formatter.apply((Object)_declaredParam, (Object)doc);
        XExpression _forExpression = expr.getForExpression();
        formatter.apply((Object)_forExpression, (Object)doc);
        XExpression _eachExpression = expr.getEachExpression();
        this.fmt(formatter, doc, (EObject)_eachExpression);
        ILeafNode _nodeForKeyword_2 = this._nodeModelAccess.nodeForKeyword((EObject)expr, "BEFORE");
        Procedures.Procedure1<FormattingDataInit> _function_4 = new Procedures.Procedure1<FormattingDataInit>(){

            public void apply(FormattingDataInit it) {
                it.oneSpace();
            }
        };
        Functions.Function1 _surround_2 = this._formattingDataFactory.surround((INode)_nodeForKeyword_2, (Procedures.Procedure1)_function_4);
        doc.operator_add(_surround_2);
        XExpression _before = expr.getBefore();
        formatter.apply((Object)_before, (Object)doc);
        ILeafNode _nodeForKeyword_3 = this._nodeModelAccess.nodeForKeyword((EObject)expr, "SEPARATOR");
        Procedures.Procedure1<FormattingDataInit> _function_5 = new Procedures.Procedure1<FormattingDataInit>(){

            public void apply(FormattingDataInit it) {
                it.oneSpace();
            }
        };
        Functions.Function1 _surround_3 = this._formattingDataFactory.surround((INode)_nodeForKeyword_3, (Procedures.Procedure1)_function_5);
        doc.operator_add(_surround_3);
        XExpression _separator = expr.getSeparator();
        formatter.apply((Object)_separator, (Object)doc);
        ILeafNode _nodeForKeyword_4 = this._nodeModelAccess.nodeForKeyword((EObject)expr, "AFTER");
        Procedures.Procedure1<FormattingDataInit> _function_6 = new Procedures.Procedure1<FormattingDataInit>(){

            public void apply(FormattingDataInit it) {
                it.oneSpace();
            }
        };
        Functions.Function1 _surround_4 = this._formattingDataFactory.surround((INode)_nodeForKeyword_4, (Procedures.Procedure1)_function_6);
        doc.operator_add(_surround_4);
        XExpression _after = expr.getAfter();
        formatter.apply((Object)_after, (Object)doc);
        INode _nodeForFeature = this._nodeModelAccess.nodeForFeature((EObject)expr, (EStructuralFeature)XbasePackage.Literals.XFOR_LOOP_EXPRESSION__EACH_EXPRESSION);
        Procedures.Procedure1<FormattingDataInit> _function_7 = new Procedures.Procedure1<FormattingDataInit>(){

            public void apply(FormattingDataInit it) {
                it.noSpace();
            }
        };
        Functions.Function1 _prepend = this._formattingDataFactory.prepend(_nodeForFeature, (Procedures.Procedure1)_function_7);
        doc.operator_add(_prepend);
        ILeafNode _nodeForKeyword_5 = this._nodeModelAccess.nodeForKeyword((EObject)expr, "ENDFOR");
        Procedures.Procedure1<FormattingDataInit> _function_8 = new Procedures.Procedure1<FormattingDataInit>(){

            public void apply(FormattingDataInit it) {
                it.noSpace();
            }
        };
        Functions.Function1 _surround_5 = this._formattingDataFactory.surround((INode)_nodeForKeyword_5, (Procedures.Procedure1)_function_8);
        doc.operator_add(_surround_5);
    }

    protected void fmt(Procedures.Procedure2<? super EObject, ? super FormattableDocument> formatter, FormattableDocument doc, EObject expr) {
        if (formatter != null && expr instanceof RichString) {
            this._fmt(formatter, doc, (RichString)expr);
            return;
        }
        if (formatter != null && expr instanceof RichStringForLoop) {
            this._fmt(formatter, doc, (RichStringForLoop)expr);
            return;
        }
        if (formatter != null && expr instanceof RichStringLiteral) {
            this._fmt(formatter, doc, (RichStringLiteral)expr);
            return;
        }
        if (formatter != null && expr instanceof RichStringIf) {
            this._fmt(formatter, doc, (RichStringIf)expr);
            return;
        }
        if (formatter != null && expr instanceof RichStringElseIf) {
            this._fmt(formatter, doc, (RichStringElseIf)expr);
            return;
        }
        if (formatter != null && expr instanceof XExpression) {
            this._fmt(formatter, doc, (XExpression)expr);
            return;
        }
        if (formatter != null && expr == null) {
            this._fmt(formatter, doc, (Void)null);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(formatter, doc, expr).toString());
    }
}

