/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.jvmmodel;

import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend.core.xtend.XtendFunction;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.util.Primitives;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.jvmmodel.IJvmModelAssociations;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.StandardTypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.util.CommonTypeComputationServices;
import org.eclipse.xtext.xbase.typesystem.util.ContextualVisibilityHelper;
import org.eclipse.xtext.xbase.typesystem.util.IVisibilityHelper;
import org.eclipse.xtext.xbase.typesystem.util.Multimaps2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DispatchHelper {
    @Inject
    private IJvmModelAssociations associations;
    @Inject
    private Primitives primitives;
    @Inject
    private TypeReferences typeRefs;
    @Inject
    private IVisibilityHelper visibilityHelper;
    @Inject
    private CommonTypeComputationServices services;

    public boolean isDispatcherFunction(JvmOperation inferredOperation) {
        Iterator filter = Iterables.filter((Iterable)this.associations.getSourceElements((EObject)inferredOperation), XtendFunction.class).iterator();
        if (!filter.hasNext()) {
            return false;
        }
        XtendFunction xtendFunction = (XtendFunction)filter.next();
        return xtendFunction.isDispatch() && inferredOperation.getSimpleName().equals(xtendFunction.getName());
    }

    public boolean isDispatchFunction(JvmOperation inferredOperation) {
        EObject sourceElement;
        if (inferredOperation.getSimpleName() != null && inferredOperation.getSimpleName().startsWith("_") && (sourceElement = this.associations.getPrimarySourceElement((EObject)inferredOperation)) instanceof XtendFunction) {
            XtendFunction function = (XtendFunction)sourceElement;
            return function.isDispatch() && inferredOperation.getSimpleName().equals("_" + function.getName());
        }
        return false;
    }

    public JvmOperation getDispatcherOperation(JvmOperation dispatchCase) {
        EObject sourceElement = this.associations.getPrimarySourceElement((EObject)dispatchCase);
        if (sourceElement instanceof XtendFunction) {
            XtendFunction function = (XtendFunction)sourceElement;
            if (function.isDispatch()) {
                Iterable operations = Iterables.filter((Iterable)this.associations.getJvmElements(sourceElement), JvmOperation.class);
                for (JvmOperation operation : operations) {
                    if (!Strings.equal((String)operation.getSimpleName(), (String)function.getName())) continue;
                    return operation;
                }
            }
        } else {
            DispatchSignature signature = new DispatchSignature(dispatchCase.getSimpleName().substring(1), dispatchCase.getParameters().size());
            JvmOperation result = this.getDispatcherOperation(dispatchCase.getDeclaringType(), signature);
            return result;
        }
        return null;
    }

    public JvmOperation getDispatcherOperation(JvmDeclaredType type, DispatchSignature signature) {
        Iterable allByName = type.findAllFeaturesByName(signature.getSimpleName());
        for (JvmFeature feature : allByName) {
            if (!(feature instanceof JvmOperation) || signature.getArity() != ((JvmOperation)feature).getParameters().size()) continue;
            return (JvmOperation)feature;
        }
        return null;
    }

    public List<JvmOperation> getLocalDispatchCases(JvmDeclaredType type, DispatchSignature signature) {
        ArrayList result = Lists.newArrayListWithExpectedSize((int)5);
        for (JvmMember feature : type.getMembers()) {
            if (!(feature instanceof JvmOperation) || !signature.isDispatchCase((JvmOperation)feature)) continue;
            result.add((JvmOperation)feature);
        }
        return result;
    }

    public List<JvmOperation> getLocalDispatchCases(JvmOperation dispatcherOperation) {
        DispatchSignature dispatchSignature = new DispatchSignature(dispatcherOperation.getSimpleName(), dispatcherOperation.getParameters().size());
        JvmDeclaredType type = dispatcherOperation.getDeclaringType();
        return this.getLocalDispatchCases(type, dispatchSignature);
    }

    public List<JvmOperation> getAllDispatchCases(JvmOperation dispatcherOperation) {
        DispatchSignature dispatchSignature = new DispatchSignature(dispatcherOperation.getSimpleName(), dispatcherOperation.getParameters().size());
        JvmDeclaredType type = dispatcherOperation.getDeclaringType();
        StandardTypeReferenceOwner owner = new StandardTypeReferenceOwner(this.services, (EObject)type);
        ContextualVisibilityHelper contextualVisibilityHelper = new ContextualVisibilityHelper(this.visibilityHelper, (LightweightTypeReference)owner.newParameterizedTypeReference((JvmType)type));
        return this.getAllDispatchMethods(dispatchSignature, type, contextualVisibilityHelper);
    }

    public ListMultimap<DispatchSignature, JvmOperation> getDeclaredOrEnhancedDispatchMethods(JvmDeclaredType type) {
        ListMultimap result = Multimaps2.newLinkedHashListMultimap((int)2, (int)4);
        Iterable operations = type.getDeclaredOperations();
        StandardTypeReferenceOwner owner = new StandardTypeReferenceOwner(this.services, (EObject)type);
        ContextualVisibilityHelper contextualVisibilityHelper = new ContextualVisibilityHelper(this.visibilityHelper, (LightweightTypeReference)owner.newParameterizedTypeReference((JvmType)type));
        for (JvmOperation operation : operations) {
            DispatchSignature signature;
            if (!this.isDispatchFunction(operation) || result.containsKey((Object)(signature = new DispatchSignature(operation.getSimpleName().substring(1), operation.getParameters().size())))) continue;
            List<JvmOperation> allOperations = this.getAllDispatchMethods(signature, type, contextualVisibilityHelper);
            result.putAll((Object)signature, allOperations);
        }
        return result;
    }

    protected List<JvmOperation> getAllDispatchMethods(DispatchSignature signature, JvmDeclaredType type, ContextualVisibilityHelper contextualVisibilityHelper) {
        ArrayList allOperations = Lists.newArrayListWithExpectedSize((int)5);
        Iterable allFeatures = type.findAllFeaturesByName(signature.getDispatchCaseName());
        for (JvmFeature feature : allFeatures) {
            JvmOperation operationByName;
            if (!(feature instanceof JvmOperation) || !signature.isDispatchCase(operationByName = (JvmOperation)feature) || !contextualVisibilityHelper.isVisible((JvmMember)operationByName)) continue;
            allOperations.add(operationByName);
        }
        this.sort(allOperations);
        return allOperations;
    }

    protected void sort(List<JvmOperation> operations) {
        Collections.sort(operations, new Comparator<JvmOperation>(){

            @Override
            public int compare(JvmOperation o1, JvmOperation o2) {
                return DispatchHelper.this.compare(o1, o2);
            }
        });
    }

    protected int compare(JvmOperation o1, JvmOperation o2) {
        int params = o1.getParameters().size();
        int i = 0;
        while (i < params) {
            int distance2;
            JvmTypeReference p1 = ((JvmFormalParameter)o1.getParameters().get(i)).getParameterType();
            JvmTypeReference p2 = ((JvmFormalParameter)o2.getParameters().get(i)).getParameterType();
            int distance1 = p1 == null ? Integer.MAX_VALUE : this.getMaxDistanceToObject(p1);
            int n = distance2 = p2 == null ? Integer.MAX_VALUE : this.getMaxDistanceToObject(p2);
            if (distance1 != distance2) {
                return distance2 - distance1;
            }
            ++i;
        }
        String identifier1 = o1.getIdentifier();
        String parameterTypes1 = identifier1.substring(identifier1.indexOf(40));
        String identifier2 = o2.getIdentifier();
        String parameterTypes2 = identifier2.substring(identifier2.indexOf(40));
        return parameterTypes1.compareTo(parameterTypes2);
    }

    protected int getMaxDistanceToObject(JvmTypeReference type) {
        if (this.typeRefs.is(type = this.primitives.asWrapperTypeIfPrimitive(type), Object.class)) {
            return 0;
        }
        JvmType jvmType = type.getType();
        int maxDistance = 1;
        if (jvmType instanceof JvmDeclaredType) {
            EList list = ((JvmDeclaredType)jvmType).getSuperTypes();
            for (JvmTypeReference jvmTypeReference : list) {
                int result = 1 + this.getMaxDistanceToObject(jvmTypeReference);
                if (result <= maxDistance) continue;
                maxDistance = result;
            }
        }
        return maxDistance;
    }

    public static class DispatchSignature {
        private final String simpleName;
        private final int arity;

        public DispatchSignature(String simpleName, int arity) {
            if (arity < 0) {
                throw new IllegalArgumentException("The number of parameters may not be smaller than zero, was: " + arity);
            }
            this.simpleName = "_" + simpleName;
            this.arity = arity;
        }

        public int getArity() {
            return this.arity;
        }

        public String getSimpleName() {
            return this.simpleName.substring(1);
        }

        public String getDispatchCaseName() {
            return this.simpleName;
        }

        public boolean isDispatchCase(JvmOperation operation) {
            return this.arity == operation.getParameters().size() && this.simpleName.equals(operation.getSimpleName());
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.arity;
            result = 31 * result + (this.simpleName == null ? 0 : this.simpleName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DispatchSignature other = (DispatchSignature)obj;
            if (this.arity != other.arity) {
                return false;
            }
            return !(this.simpleName == null ? other.simpleName != null : !this.simpleName.equals(other.simpleName));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("DispatchSignature [simpleName=");
            builder.append(this.simpleName);
            builder.append(", arity=");
            builder.append(this.arity);
            builder.append("]");
            return builder.toString();
        }
    }
}

