/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.macro;

import com.google.common.base.Objects;
import com.google.inject.Singleton;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.xbase.lib.Exceptions;

@Singleton
public class ProcessorInstanceForJvmTypeProvider {
    private static final Logger logger = Logger.getLogger(ProcessorInstanceForJvmTypeProvider.class);
    private ClassLoader classLoader;

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public Object getProcessorInstance(JvmType type) {
        try {
            ClassLoader _classLoader = this.getClassLoader((EObject)type);
            Class<?> _loadClass = null;
            if (_classLoader != null) {
                String _identifier = type.getIdentifier();
                _loadClass = _classLoader.loadClass(_identifier);
            }
            Class<?> loadClass = _loadClass;
            Object _newInstance = null;
            if (loadClass != null) {
                _newInstance = loadClass.newInstance();
            }
            return _newInstance;
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                Exception e = (Exception)_t;
                String _identifier_1 = type.getIdentifier();
                String _plus = "Problem during instantiation of " + _identifier_1;
                String _plus_1 = String.valueOf(_plus) + " : ";
                String _message = e.getMessage();
                String _plus_2 = String.valueOf(_plus_1) + _message;
                throw new IllegalStateException(_plus_2, e);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    protected ClassLoader getClassLoader(EObject ctx) {
        boolean _notEquals;
        boolean bl = _notEquals = !Objects.equal((Object)this.classLoader, null);
        if (_notEquals) {
            return this.classLoader;
        }
        Resource _eResource = ctx.eResource();
        ResourceSet resourceSet = _eResource.getResourceSet();
        boolean _matched = false;
        if (!_matched && resourceSet instanceof XtextResourceSet) {
            _matched = true;
            Object classLoaderCtx = ((XtextResourceSet)resourceSet).getClasspathURIContext();
            boolean _matched_1 = false;
            if (!_matched_1 && classLoaderCtx instanceof ClassLoader) {
                _matched_1 = true;
                return (ClassLoader)classLoaderCtx;
            }
            if (!_matched_1 && classLoaderCtx instanceof Class) {
                _matched_1 = true;
                return ((Class)classLoaderCtx).getClassLoader();
            }
        }
        logger.info((Object)"No class loader configured. Trying with this class' classloader.");
        Class<?> _class = this.getClass();
        return _class.getClassLoader();
    }
}

