/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.diseasemodels.vector.presentation;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.ui.provider.PropertySource;
import org.eclipse.stem.core.graph.IntegrationLabel;
import org.eclipse.stem.core.graph.IntegrationLabelValue;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProvider;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProviderAdapterFactory;
import org.eclipse.stem.diseasemodels.standard.DiseaseModelLabelValue;
import org.eclipse.stem.diseasemodels.standard.provider.StandardRelativeValueProviderAdapterFactory;
import org.eclipse.stem.diseasemodels.vector.provider.VectorItemProviderAdapterFactory;
import org.eclipse.stem.diseasemodels.vector.util.VectorAdapterFactory;
import org.eclipse.ui.IStartup;

public class VectorRelativeValueProviderAdapterFactory
extends VectorAdapterFactory
implements IStartup,
RelativeValueProviderAdapterFactory {
    protected ComposedAdapterFactory parentAdapterFactory;
    protected IChangeNotifier changeNotifier = new ChangeNotifier();
    private static VectorItemProviderAdapterFactory itemProviderFactory;

    public VectorRelativeValueProviderAdapterFactory() {
        RelativeValueProviderAdapterFactory.INSTANCE.addAdapterFactory((AdapterFactory)this);
    }

    public void earlyStartup() {
        new VectorRelativeValueProviderAdapterFactory();
    }

    public void addListener(INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.addListener(notifyChangedListener);
    }

    public void fireNotifyChanged(Notification notification) {
        this.changeNotifier.fireNotifyChanged(notification);
        if (this.parentAdapterFactory != null) {
            this.parentAdapterFactory.fireNotifyChanged(notification);
        }
    }

    public void removeListener(INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.removeListener(notifyChangedListener);
    }

    public ComposeableAdapterFactory getRootAdapterFactory() {
        return this.parentAdapterFactory == null ? this : this.parentAdapterFactory.getRootAdapterFactory();
    }

    public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
        this.parentAdapterFactory = parentAdapterFactory;
    }

    public void dispose() {
    }

    public boolean isFactoryForType(Object type) {
        return super.isFactoryForType(type) || type == RelativeValueProvider.class;
    }

    private static RelativeValueProviderAdapterFactory getRelativeValueProviderAdapterFactory() {
        return RelativeValueProviderAdapterFactory.INSTANCE;
    }

    private static VectorItemProviderAdapterFactory getItemProviderFactory() {
        if (itemProviderFactory == null) {
            itemProviderFactory = new VectorItemProviderAdapterFactory();
        }
        return itemProviderFactory;
    }

    public Adapter createDengueModelHostLabelAdapter() {
        return new DengueModelHostLabelRelativeValueProviderAdapter();
    }

    public Adapter createDengueModelVectorLabelAdapter() {
        return new DengueModelVectorLabelRelativeValueProviderAdapter();
    }

    public Adapter createSimpleDengueModelHostLabelAdapter() {
        return new SimpleDengueModelHostLabelRelativeValueProviderAdapter();
    }

    public Adapter createDengueModelHostLabelValueAdapter() {
        return new DengueModelHostLabelValueRelativeValueProviderAdapter();
    }

    public Adapter createDengueModelVectorLabelValueAdapter() {
        return new DengueModelVectorLabelValueRelativeValueProviderAdapter();
    }

    public Adapter createSimpleDengueModelHostLabelValueAdapter() {
        return new SimpleDengueModelHostLabelValueRelativeValueProviderAdapter();
    }

    public static class DengueModelHostLabelRelativeValueProviderAdapter
    extends StandardRelativeValueProviderAdapterFactory.DiseaseModelLabelRelativeValueProvider {
        private IntegrationLabelValue getCurrentLabelValue() {
            return (IntegrationLabelValue)((IntegrationLabel)this.getTarget()).getCurrentValue();
        }

        private RelativeValueProvider getCurrentLabelValueRelativeValueProvider() {
            return (RelativeValueProvider)VectorRelativeValueProviderAdapterFactory.getRelativeValueProviderAdapterFactory().adapt((Notifier)this.getCurrentLabelValue(), RelativeValueProvider.class);
        }

        public List<IItemPropertyDescriptor> getProperties() {
            return this.getCurrentLabelValueRelativeValueProvider().getProperties();
        }

        public double getRelativeValue(EStructuralFeature feature) {
            return this.getCurrentLabelValueRelativeValueProvider().getRelativeValue(feature);
        }

        public double getDenominator(EStructuralFeature feature) {
            return ((DiseaseModelLabelValue)this.getCurrentLabelValue()).getPopulationCount();
        }
    }

    public static class DengueModelHostLabelValueRelativeValueProviderAdapter
    extends StandardRelativeValueProviderAdapterFactory.DiseaseModelLabelValueRelativeValueProvider {
        public List<IItemPropertyDescriptor> getProperties() {
            IItemPropertySource propertySource = (IItemPropertySource)VectorRelativeValueProviderAdapterFactory.getItemProviderFactory().adapt(this.getTarget(), PropertySource.class);
            ArrayList<IItemPropertyDescriptor> properties = new ArrayList<IItemPropertyDescriptor>();
            for (IItemPropertyDescriptor descriptor : propertySource.getPropertyDescriptors(null)) {
                EStructuralFeature feature = (EStructuralFeature)descriptor.getFeature(null);
                if (feature instanceof EReference) continue;
                properties.add(descriptor);
            }
            return properties;
        }

        public double getRelativeValue(EStructuralFeature feature) {
            IntegrationLabelValue labelValue = (IntegrationLabelValue)this.getTarget();
            double stateCount = labelValue.eGetDouble(feature.getFeatureID());
            double denominator = this.getDenominator(feature);
            if (denominator <= 0.0) {
                return 0.0;
            }
            return stateCount / denominator;
        }

        public double getDenominator(EStructuralFeature feature) {
            return ((DiseaseModelLabelValue)this.getTarget()).getPopulationCount();
        }
    }

    public static class DengueModelVectorLabelRelativeValueProviderAdapter
    extends StandardRelativeValueProviderAdapterFactory.DiseaseModelLabelRelativeValueProvider {
        private IntegrationLabelValue getCurrentLabelValue() {
            return (IntegrationLabelValue)((IntegrationLabel)this.getTarget()).getCurrentValue();
        }

        private RelativeValueProvider getCurrentLabelValueRelativeValueProvider() {
            return (RelativeValueProvider)VectorRelativeValueProviderAdapterFactory.getRelativeValueProviderAdapterFactory().adapt((Notifier)this.getCurrentLabelValue(), RelativeValueProvider.class);
        }

        public List<IItemPropertyDescriptor> getProperties() {
            return this.getCurrentLabelValueRelativeValueProvider().getProperties();
        }

        public double getRelativeValue(EStructuralFeature feature) {
            return this.getCurrentLabelValueRelativeValueProvider().getRelativeValue(feature);
        }

        public double getDenominator(EStructuralFeature feature) {
            return ((DiseaseModelLabelValue)this.getCurrentLabelValue()).getPopulationCount();
        }
    }

    public static class DengueModelVectorLabelValueRelativeValueProviderAdapter
    extends StandardRelativeValueProviderAdapterFactory.DiseaseModelLabelValueRelativeValueProvider {
        public List<IItemPropertyDescriptor> getProperties() {
            IItemPropertySource propertySource = (IItemPropertySource)VectorRelativeValueProviderAdapterFactory.getItemProviderFactory().adapt(this.getTarget(), PropertySource.class);
            ArrayList<IItemPropertyDescriptor> properties = new ArrayList<IItemPropertyDescriptor>();
            for (IItemPropertyDescriptor descriptor : propertySource.getPropertyDescriptors(null)) {
                EStructuralFeature feature = (EStructuralFeature)descriptor.getFeature(null);
                if (feature instanceof EReference) continue;
                properties.add(descriptor);
            }
            return properties;
        }

        public double getRelativeValue(EStructuralFeature feature) {
            IntegrationLabelValue labelValue = (IntegrationLabelValue)this.getTarget();
            double stateCount = labelValue.eGetDouble(feature.getFeatureID());
            double denominator = this.getDenominator(feature);
            if (denominator <= 0.0) {
                return 0.0;
            }
            return stateCount / denominator;
        }

        public double getDenominator(EStructuralFeature feature) {
            return ((DiseaseModelLabelValue)this.getTarget()).getPopulationCount();
        }
    }

    public static class SimpleDengueModelHostLabelRelativeValueProviderAdapter
    extends StandardRelativeValueProviderAdapterFactory.DiseaseModelLabelRelativeValueProvider {
        private IntegrationLabelValue getCurrentLabelValue() {
            return (IntegrationLabelValue)((IntegrationLabel)this.getTarget()).getCurrentValue();
        }

        private RelativeValueProvider getCurrentLabelValueRelativeValueProvider() {
            return (RelativeValueProvider)VectorRelativeValueProviderAdapterFactory.getRelativeValueProviderAdapterFactory().adapt((Notifier)this.getCurrentLabelValue(), RelativeValueProvider.class);
        }

        public List<IItemPropertyDescriptor> getProperties() {
            return this.getCurrentLabelValueRelativeValueProvider().getProperties();
        }

        public double getRelativeValue(EStructuralFeature feature) {
            return this.getCurrentLabelValueRelativeValueProvider().getRelativeValue(feature);
        }

        public double getDenominator(EStructuralFeature feature) {
            return ((DiseaseModelLabelValue)this.getCurrentLabelValue()).getPopulationCount();
        }
    }

    public static class SimpleDengueModelHostLabelValueRelativeValueProviderAdapter
    extends StandardRelativeValueProviderAdapterFactory.DiseaseModelLabelValueRelativeValueProvider {
        public List<IItemPropertyDescriptor> getProperties() {
            IItemPropertySource propertySource = (IItemPropertySource)VectorRelativeValueProviderAdapterFactory.getItemProviderFactory().adapt(this.getTarget(), PropertySource.class);
            ArrayList<IItemPropertyDescriptor> properties = new ArrayList<IItemPropertyDescriptor>();
            for (IItemPropertyDescriptor descriptor : propertySource.getPropertyDescriptors(null)) {
                EStructuralFeature feature = (EStructuralFeature)descriptor.getFeature(null);
                if (feature instanceof EReference) continue;
                properties.add(descriptor);
            }
            return properties;
        }

        public double getRelativeValue(EStructuralFeature feature) {
            IntegrationLabelValue labelValue = (IntegrationLabelValue)this.getTarget();
            double stateCount = labelValue.eGetDouble(feature.getFeatureID());
            double denominator = this.getDenominator(feature);
            if (denominator <= 0.0) {
                return 0.0;
            }
            return stateCount / denominator;
        }

        public double getDenominator(EStructuralFeature feature) {
            return ((DiseaseModelLabelValue)this.getTarget()).getPopulationCount();
        }
    }
}

