/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.diseasemodels.standard.presentation;

import java.io.File;
import java.util.Arrays;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.ui.action.WorkbenchWindowActionDelegate;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.edit.ui.action.LoadResourceAction;
import org.eclipse.emf.edit.ui.util.EditUIUtil;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.stem.diseasemodels.standard.presentation.DiseasemodelsEditorPlugin;
import org.eclipse.stem.diseasemodels.standard.presentation.StandardEditor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveFactory;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ContributionItemFactory;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.application.IWorkbenchConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;

public final class DiseasemodelsEditorAdvisor
extends WorkbenchAdvisor {
    private static final String[] FILE_EXTENSION_FILTERS = DiseasemodelsEditorAdvisor.getFileExtensionFilters();

    private static String[] getFileExtensionFilters() {
        UniqueEList result = new UniqueEList();
        result.addAll(StandardEditor.FILE_EXTENSION_FILTERS);
        return result.toArray(new String[0]);
    }

    private static String getString(String key) {
        return DiseasemodelsEditorPlugin.INSTANCE.getString(key);
    }

    private static String getString(String key, Object s1) {
        return DiseasemodelsEditorPlugin.INSTANCE.getString(key, new Object[]{s1});
    }

    public static String[] openFilePathDialog(Shell shell, int style, String[] fileExtensionFilters) {
        return DiseasemodelsEditorAdvisor.openFilePathDialog(shell, style, fileExtensionFilters, (style & 0x1000) != 0, (style & 0x1000) != 0, (style & 0x2000) != 0);
    }

    public static String[] openFilePathDialog(Shell shell, int style, String[] fileExtensionFilters, boolean includeGroupFilter, boolean includeAllFilter, boolean addExtension) {
        String filter;
        int dot;
        int i;
        int offset;
        FileDialog fileDialog = new FileDialog(shell, style);
        if (fileExtensionFilters == null) {
            fileExtensionFilters = FILE_EXTENSION_FILTERS;
        }
        int n = offset = (includeGroupFilter &= fileExtensionFilters.length > 1) ? 1 : 0;
        if (includeGroupFilter || includeAllFilter) {
            int size = fileExtensionFilters.length + offset + (includeAllFilter ? 1 : 0);
            String[] allFilters = new String[size];
            StringBuilder group = includeGroupFilter ? new StringBuilder() : null;
            int i2 = 0;
            while (i2 < fileExtensionFilters.length) {
                if (includeGroupFilter) {
                    if (i2 != 0) {
                        group.append(';');
                    }
                    group.append(fileExtensionFilters[i2]);
                }
                allFilters[i2 + offset] = fileExtensionFilters[i2];
                ++i2;
            }
            if (includeGroupFilter) {
                allFilters[0] = group.toString();
            }
            if (includeAllFilter) {
                allFilters[allFilters.length - 1] = "*.*";
            }
            fileDialog.setFilterExtensions(allFilters);
        } else {
            fileDialog.setFilterExtensions(fileExtensionFilters);
        }
        fileDialog.open();
        String[] filenames = fileDialog.getFileNames();
        String[] result = new String[filenames.length];
        String path = String.valueOf(fileDialog.getFilterPath()) + File.separator;
        String extension = null;
        if (addExtension && (i = fileDialog.getFilterIndex()) != -1 && (!includeAllFilter || i != fileExtensionFilters.length) && (dot = (filter = fileExtensionFilters[i = includeGroupFilter && i == 0 ? 0 : i - offset]).lastIndexOf(46)) == 1 && filter.charAt(0) == '*') {
            extension = filter.substring(dot);
        }
        i = 0;
        while (i < filenames.length) {
            String filename = String.valueOf(path) + filenames[i];
            if (!(extension == null || (dot = filename.lastIndexOf(46)) != -1 && Arrays.asList(fileExtensionFilters).contains("*" + filename.substring(dot)))) {
                filename = String.valueOf(filename) + extension;
            }
            result[i] = filename;
            ++i;
        }
        return result;
    }

    public static boolean openEditor(IWorkbench workbench, URI uri) {
        IWorkbenchWindow workbenchWindow = workbench.getActiveWorkbenchWindow();
        IWorkbenchPage page = workbenchWindow.getActivePage();
        IEditorDescriptor editorDescriptor = EditUIUtil.getDefaultEditor((URI)uri, null);
        if (editorDescriptor == null) {
            MessageDialog.openError((Shell)workbenchWindow.getShell(), (String)DiseasemodelsEditorAdvisor.getString("_UI_Error_title"), (String)DiseasemodelsEditorAdvisor.getString("_WARN_No_Editor", uri.lastSegment()));
            return false;
        }
        try {
            page.openEditor((IEditorInput)new URIEditorInput(uri), editorDescriptor.getId());
        }
        catch (PartInitException exception) {
            MessageDialog.openError((Shell)workbenchWindow.getShell(), (String)DiseasemodelsEditorAdvisor.getString("_UI_OpenEditorError_label"), (String)exception.getMessage());
            return false;
        }
        return true;
    }

    public String getInitialWindowPerspectiveId() {
        return "org.eclipse.stem.diseasemodels.standard.presentation.DiseasemodelsEditorAdvisorPerspective";
    }

    public void initialize(IWorkbenchConfigurer configurer) {
        super.initialize(configurer);
        configurer.setSaveAndRestore(true);
    }

    public WorkbenchWindowAdvisor createWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
        return new WindowAdvisor(configurer);
    }

    public static class AboutAction
    extends WorkbenchWindowActionDelegate {
        public void run(IAction action) {
            MessageDialog.openInformation((Shell)this.getWindow().getShell(), (String)DiseasemodelsEditorAdvisor.getString("_UI_About_title"), (String)DiseasemodelsEditorAdvisor.getString("_UI_About_text"));
        }
    }

    public static class Application
    implements IApplication {
        public Object start(IApplicationContext context) throws Exception {
            DiseasemodelsEditorAdvisor workbenchAdvisor = new DiseasemodelsEditorAdvisor();
            Display display = PlatformUI.createDisplay();
            try {
                int returnCode = PlatformUI.createAndRunWorkbench((Display)display, (WorkbenchAdvisor)workbenchAdvisor);
                if (returnCode == 1) {
                    Integer n = IApplication.EXIT_RESTART;
                    return n;
                }
                Integer n = IApplication.EXIT_OK;
                return n;
            }
            finally {
                display.dispose();
            }
        }

        public void stop() {
        }
    }

    public static class OpenAction
    extends WorkbenchWindowActionDelegate {
        public void run(IAction action) {
            String[] filePaths = DiseasemodelsEditorAdvisor.openFilePathDialog(this.getWindow().getShell(), 4096, null);
            if (filePaths.length > 0) {
                DiseasemodelsEditorAdvisor.openEditor(this.getWindow().getWorkbench(), URI.createFileURI((String)filePaths[0]));
            }
        }
    }

    public static class OpenURIAction
    extends WorkbenchWindowActionDelegate {
        public void run(IAction action) {
            LoadResourceAction.LoadResourceDialog loadResourceDialog = new LoadResourceAction.LoadResourceDialog(this.getWindow().getShell());
            if (loadResourceDialog.open() == 0) {
                for (URI uri : loadResourceDialog.getURIs()) {
                    DiseasemodelsEditorAdvisor.openEditor(this.getWindow().getWorkbench(), uri);
                }
            }
        }
    }

    public static class Perspective
    implements IPerspectiveFactory {
        public static final String ID_PERSPECTIVE = "org.eclipse.stem.diseasemodels.standard.presentation.DiseasemodelsEditorAdvisorPerspective";

        public void createInitialLayout(IPageLayout layout) {
            layout.setEditorAreaVisible(true);
            layout.addPerspectiveShortcut(ID_PERSPECTIVE);
            IFolderLayout right = layout.createFolder("right", 2, 0.66f, layout.getEditorArea());
            right.addView("org.eclipse.ui.views.ContentOutline");
            IFolderLayout bottonRight = layout.createFolder("bottonRight", 4, 0.6f, "right");
            bottonRight.addView("org.eclipse.ui.views.PropertySheet");
        }
    }

    public static class WindowActionBarAdvisor
    extends ActionBarAdvisor {
        public WindowActionBarAdvisor(IActionBarConfigurer configurer) {
            super(configurer);
        }

        protected void fillMenuBar(IMenuManager menuBar) {
            IWorkbenchWindow window = this.getActionBarConfigurer().getWindowConfigurer().getWindow();
            menuBar.add((IContributionItem)this.createFileMenu(window));
            menuBar.add((IContributionItem)this.createEditMenu(window));
            menuBar.add((IContributionItem)new GroupMarker("additions"));
            menuBar.add((IContributionItem)this.createWindowMenu(window));
            menuBar.add((IContributionItem)this.createHelpMenu(window));
        }

        protected IMenuManager createFileMenu(IWorkbenchWindow window) {
            MenuManager menu = new MenuManager(DiseasemodelsEditorAdvisor.getString("_UI_Menu_File_label"), "file");
            menu.add((IContributionItem)new GroupMarker("fileStart"));
            MenuManager newMenu = new MenuManager(DiseasemodelsEditorAdvisor.getString("_UI_Menu_New_label"), "new");
            newMenu.add((IContributionItem)new GroupMarker("additions"));
            menu.add((IContributionItem)newMenu);
            menu.add((IContributionItem)new Separator());
            menu.add((IContributionItem)new GroupMarker("additions"));
            menu.add((IContributionItem)new Separator());
            this.addToMenuAndRegister((IMenuManager)menu, (IAction)ActionFactory.CLOSE.create(window));
            this.addToMenuAndRegister((IMenuManager)menu, (IAction)ActionFactory.CLOSE_ALL.create(window));
            menu.add((IContributionItem)new Separator());
            this.addToMenuAndRegister((IMenuManager)menu, (IAction)ActionFactory.SAVE.create(window));
            this.addToMenuAndRegister((IMenuManager)menu, (IAction)ActionFactory.SAVE_AS.create(window));
            this.addToMenuAndRegister((IMenuManager)menu, (IAction)ActionFactory.SAVE_ALL.create(window));
            menu.add((IContributionItem)new Separator());
            this.addToMenuAndRegister((IMenuManager)menu, (IAction)ActionFactory.QUIT.create(window));
            menu.add((IContributionItem)new GroupMarker("fileEnd"));
            return menu;
        }

        protected IMenuManager createEditMenu(IWorkbenchWindow window) {
            MenuManager menu = new MenuManager(DiseasemodelsEditorAdvisor.getString("_UI_Menu_Edit_label"), "edit");
            menu.add((IContributionItem)new GroupMarker("editStart"));
            this.addToMenuAndRegister((IMenuManager)menu, (IAction)ActionFactory.UNDO.create(window));
            this.addToMenuAndRegister((IMenuManager)menu, (IAction)ActionFactory.REDO.create(window));
            menu.add((IContributionItem)new GroupMarker("undo.ext"));
            menu.add((IContributionItem)new Separator());
            this.addToMenuAndRegister((IMenuManager)menu, (IAction)ActionFactory.CUT.create(window));
            this.addToMenuAndRegister((IMenuManager)menu, (IAction)ActionFactory.COPY.create(window));
            this.addToMenuAndRegister((IMenuManager)menu, (IAction)ActionFactory.PASTE.create(window));
            menu.add((IContributionItem)new GroupMarker("cut.ext"));
            menu.add((IContributionItem)new Separator());
            this.addToMenuAndRegister((IMenuManager)menu, (IAction)ActionFactory.DELETE.create(window));
            this.addToMenuAndRegister((IMenuManager)menu, (IAction)ActionFactory.SELECT_ALL.create(window));
            menu.add((IContributionItem)new Separator());
            menu.add((IContributionItem)new GroupMarker("add.ext"));
            menu.add((IContributionItem)new GroupMarker("editEnd"));
            menu.add((IContributionItem)new Separator("additions"));
            return menu;
        }

        protected IMenuManager createWindowMenu(IWorkbenchWindow window) {
            MenuManager menu = new MenuManager(DiseasemodelsEditorAdvisor.getString("_UI_Menu_Window_label"), "window");
            this.addToMenuAndRegister((IMenuManager)menu, (IAction)ActionFactory.OPEN_NEW_WINDOW.create(window));
            menu.add((IContributionItem)new GroupMarker("additions"));
            menu.add(ContributionItemFactory.OPEN_WINDOWS.create(window));
            return menu;
        }

        protected IMenuManager createHelpMenu(IWorkbenchWindow window) {
            MenuManager menu = new MenuManager(DiseasemodelsEditorAdvisor.getString("_UI_Menu_Help_label"), "help");
            menu.add((IContributionItem)new GroupMarker("helpStart"));
            menu.add((IContributionItem)new GroupMarker("helpEnd"));
            menu.add((IContributionItem)new GroupMarker("additions"));
            return menu;
        }

        protected void addToMenuAndRegister(IMenuManager menuManager, IAction action) {
            menuManager.add(action);
            this.getActionBarConfigurer().registerGlobalAction(action);
        }
    }

    public static class WindowAdvisor
    extends WorkbenchWindowAdvisor {
        public WindowAdvisor(IWorkbenchWindowConfigurer configurer) {
            super(configurer);
        }

        public void preWindowOpen() {
            IWorkbenchWindowConfigurer configurer = this.getWindowConfigurer();
            configurer.setInitialSize(new Point(600, 450));
            configurer.setShowCoolBar(false);
            configurer.setShowStatusLine(true);
            configurer.setTitle(DiseasemodelsEditorAdvisor.getString("_UI_Application_title"));
        }

        public ActionBarAdvisor createActionBarAdvisor(IActionBarConfigurer configurer) {
            return new WindowActionBarAdvisor(configurer);
        }
    }
}

