/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.loggers.csv.logger;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.stem.core.graph.Graph;
import org.eclipse.stem.core.model.Decorator;
import org.eclipse.stem.core.model.IntegrationDecorator;
import org.eclipse.stem.core.scenario.Scenario;
import org.eclipse.stem.jobs.simulation.ISimulation;
import org.eclipse.stem.jobs.simulation.SimulationEvent;
import org.eclipse.stem.jobs.simulation.SimulationState;
import org.eclipse.stem.loggers.csv.Activator;
import org.eclipse.stem.loggers.csv.CSVLogger;
import org.eclipse.stem.loggers.csv.logger.Constants;
import org.eclipse.stem.loggers.csv.logger.DelimetedFileDecoratorLogger;
import org.eclipse.stem.loggers.csv.logger.FileUtils;
import org.eclipse.stem.loggers.csv.logger.Messages;
import org.eclipse.stem.loggers.csv.logger.html.HtmlScenarioPage;

public class DelimetedFileSimulationLogger {
    private CSVLogger logger;
    private ISimulation simulation;
    private File logDirectory;
    private final List<String> excludedDecorators = new ArrayList<String>(Arrays.asList(Constants.EXCLUDED_DECORATOR_DEFAULTS));
    private final List<DelimetedFileDecoratorLogger> decoratorLoggers = new ArrayList<DelimetedFileDecoratorLogger>();

    public DelimetedFileSimulationLogger(CSVLogger logger, ISimulation simulation) {
        this.logger = logger;
        this.simulation = simulation;
        this.createLoggersForDecorators();
        if (logger.isLogHtmlSummary()) {
            this.generateHtmlSummary(simulation.getScenario());
        }
    }

    public CSVLogger getLogger() {
        return this.logger;
    }

    public ISimulation getSimulation() {
        return this.simulation;
    }

    public File getLogDirectory() {
        if (this.logDirectory == null) {
            StringBuilder directory = new StringBuilder();
            if (this.logger.isUseDefaultLogDirectory() || "".equals(this.logger.getDataPath())) {
                directory.append(FileUtils.getRootLoggingFolderForScenario(this.simulation.getScenario().getURI().toString()));
            } else {
                directory.append(this.logger.getDataPath());
            }
            directory.append(Constants.SYSTEM_PATH_SEPARATOR);
            directory.append(this.simulation.getUniqueIDString());
            directory.append(Constants.SYSTEM_PATH_SEPARATOR);
            this.logDirectory = new File(directory.toString());
        }
        return this.logDirectory;
    }

    private void generateHtmlSummary(Scenario s) {
        try {
            new HtmlScenarioPage(s, this.getLogDirectory()).generate();
        }
        catch (IOException ioe) {
            Activator.logInformation(Messages.DFSL_WriteScenarioSummaryError, ioe);
        }
    }

    public void start() {
        for (DelimetedFileDecoratorLogger logger : this.decoratorLoggers) {
            logger.start();
            if (logger.getLogger().isLogRunParameters()) {
                logger.writeRunParameters();
            }
            if (!logger.getLogger().isLogInitialState()) continue;
            logger.log();
        }
    }

    public void stop() {
        for (DelimetedFileDecoratorLogger logger : this.decoratorLoggers) {
            logger.stop();
        }
    }

    public void log(SimulationEvent event) {
        for (DelimetedFileDecoratorLogger logger : this.decoratorLoggers) {
            if (event.getSimulationState().equals((Object)SimulationState.PAUSED)) {
                logger.flush();
                continue;
            }
            if (!event.getSimulationState().equals((Object)SimulationState.COMPLETED_CYCLE)) continue;
            logger.log();
        }
    }

    private void createLoggersForDecorators() {
        List<IntegrationDecorator> decorators = this.getDecoratorsToLog();
        for (IntegrationDecorator decorator : decorators) {
            this.decoratorLoggers.add(new DelimetedFileDecoratorLogger(this, decorator));
        }
    }

    protected void addChildDecoratorLogger(IntegrationDecorator decorator) {
        DelimetedFileDecoratorLogger childLogger = new DelimetedFileDecoratorLogger(this, decorator, true);
        this.decoratorLoggers.add(childLogger);
    }

    private boolean isExcludedDecorator(Decorator d) {
        return this.excludedDecorators.contains(d.eClass().getInstanceClass().getName());
    }

    private List<IntegrationDecorator> getDecoratorsToLog() {
        ArrayList<IntegrationDecorator> decorators = new ArrayList<IntegrationDecorator>();
        this.simulation.getScenario().getCanonicalGraph().eAdapters().add((Object)new AdapterImpl(){

            public void notifyChanged(Notification msg) {
                super.notifyChanged(msg);
                int featureId = msg.getFeatureID(Graph.class);
                if (featureId == 14 && msg.getNewValue() instanceof IntegrationDecorator) {
                    DelimetedFileSimulationLogger.this.addChildDecoratorLogger((IntegrationDecorator)msg.getNewValue());
                }
            }
        });
        for (Decorator decorator : this.simulation.getScenario().getCanonicalGraph().getDecorators()) {
            if (!(decorator instanceof IntegrationDecorator) || this.isExcludedDecorator(decorator) || this.logger.getDecoratorProperties(decorator.getURI()) == null) continue;
            decorators.add((IntegrationDecorator)decorator);
        }
        return decorators;
    }
}

