/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.views.graphmap;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.definitions.adapters.spatial.geo.LatLong;
import org.eclipse.stem.definitions.adapters.spatial.geo.LatLongProvider;
import org.eclipse.stem.definitions.adapters.spatial.geo.LatLongProviderAdapter;
import org.eclipse.stem.definitions.adapters.spatial.geo.LatLongProviderAdapterFactory;

public class DecoratorDisplayData {
    private Map<Node, LatLong> nodeData = new HashMap<Node, LatLong>();
    private boolean hasAllLatLong = true;

    public boolean hasAllLatLong() {
        return this.hasAllLatLong;
    }

    public Map<Node, LatLong> getNodeData() {
        return this.nodeData;
    }

    public void updateLatLong(IProgressMonitor monitor) {
        boolean latLongMissing = false;
        for (Map.Entry<Node, LatLong> entry : this.nodeData.entrySet()) {
            LatLongProviderAdapter latLongProvider = (LatLongProviderAdapter)LatLongProviderAdapterFactory.INSTANCE.adapt((Notifier)entry.getKey(), LatLongProvider.class);
            LatLong data = latLongProvider.getLatLong();
            if (data != null && data.size() != 0) {
                entry.setValue(data);
                continue;
            }
            latLongMissing = true;
        }
        this.hasAllLatLong = !latLongMissing;
    }

    public void addNode(Node node) {
        this.hasAllLatLong = false;
        this.nodeData.put(node, null);
    }
}

