/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.wizards;

import java.util.ArrayList;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.stem.core.STEMURI;
import org.eclipse.stem.core.Utility;
import org.eclipse.stem.core.common.DublinCore;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.core.solver.Solver;
import org.eclipse.stem.core.solver.SolverPropertyComposite;
import org.eclipse.stem.ui.Activator;
import org.eclipse.stem.ui.wizards.DublinCorePage;
import org.eclipse.stem.ui.wizards.Messages;
import org.eclipse.stem.ui.wizards.NewIdentifiablePage;
import org.eclipse.stem.ui.wizards.NewIdentifiableWizard;
import org.eclipse.stem.ui.wizards.STEMWizardDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class NewSolverWizard
extends NewIdentifiableWizard {
    @Override
    protected String getWizardTitle() {
        return Messages.getString("NSolverWiz.wizard_title");
    }

    @Override
    protected NewIdentifiablePage createNewIdentifiablePage() {
        this.setHelpContextId("org.eclipse.stem.doc.newsolver_contextid");
        return new NewSolverPage();
    }

    @Override
    protected DublinCorePage createDublinCorePage() {
        return new DublinCorePage(){

            @Override
            protected void initializeDCAttributes() {
                super.initializeDCAttributes();
                this.format.setText("http:///org/eclipse/stem/core/scenario.ecore");
                this.format.setEnabled(false);
                this.type.setText(STEMURI.SCENARIO_TYPE_URI.toString());
                this.type.setEnabled(false);
                this.titleTextField.setText(Messages.getString("dc_title_solver"));
                this.source.setText(Messages.getString("dc_source_solver"));
                this.descriptionTextField.setText(Messages.getString("dc_desc_solver"));
            }
        };
    }

    @Override
    protected Identifiable createIdentifiable() {
        SolverPropertyComposite spc = ((NewSolverPage)this.newIdentifiablePage).solverPC;
        Solver solver = spc.createSolver();
        solver.setDublinCore(this.newDublinCorePage.createDublinCore());
        return solver;
    }

    @Override
    protected String getSerializationFolderName() {
        return "solvers";
    }

    @Override
    protected String getSerializationFileNameExtension() {
        SolverPropertyComposite spc = ((NewSolverPage)this.newIdentifiablePage).solverPC;
        Solver s = spc.getSelectedSolver();
        return s.eClass().getEPackage().getName();
    }

    protected static class NewSolverPage
    extends NewIdentifiablePage {
        private Solver[] solvers = null;
        SolverPropertyComposite solverPC;
        private Combo combo;

        protected NewSolverPage() {
            super(Messages.getString("NSolverWiz.page_title"));
            this.setTitle(Messages.getString("NSolverWiz.page_title"));
            this.setDescription(Messages.getString("NSolverWiz.page_description"));
        }

        @Override
        protected Composite createSpecificComposite(Composite parent) {
            Solver[] solvers = this.getSolvers();
            Composite composite = new Composite(parent, 0);
            GridLayout gridLayout = new GridLayout();
            gridLayout.marginWidth = 0;
            gridLayout.numColumns = 1;
            composite.setLayout((Layout)gridLayout);
            Label solverLabel = new Label(composite, 0);
            GridData gd_solverLabel = new GridData(4, 0x1000000, true, false);
            gd_solverLabel.widthHint = 100;
            solverLabel.setLayoutData((Object)gd_solverLabel);
            solverLabel.setText(Messages.getString("NSolverWiz.solver"));
            this.combo = new Combo(composite, 8);
            this.combo.setTextLimit(30);
            GridData gd_combo = new GridData(4, 0x1000000, true, false);
            gd_combo.widthHint = 303;
            this.combo.setLayoutData((Object)gd_combo);
            this.combo.setToolTipText(Messages.getString("NSolverWiz.solver"));
            this.combo.setItems(this.getSolverNames(solvers));
            final NewSolverPage self = this;
            this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    self.displaySolver(NewSolverPage.this.getSolvers()[NewSolverPage.this.combo.getSelectionIndex()]);
                    NewSolverPage.this.setPageComplete(NewSolverPage.this.validatePage());
                }
            });
            this.combo.select(0);
            this.combo.addModifyListener(this.projectValidator);
            this.solverPC = new SolverPropertyComposite(composite, 1, solvers, this.projectValidator);
            this.displaySolver(solvers[0]);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.stem.doc.newsolver_contextid");
            return composite;
        }

        private Solver[] getSolvers() {
            IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
            String prefSolver = preferenceStore.getString("defaultSolver");
            if (this.solvers == null) {
                IExtensionRegistry registry = Platform.getExtensionRegistry();
                IConfigurationElement[] solverConfigElements = registry.getConfigurationElementsFor("org.eclipse.stem.core.solver");
                ArrayList<Object> temp = new ArrayList<Object>();
                ArrayList<DublinCore> dctemp = new ArrayList<DublinCore>();
                this.solvers = new Solver[solverConfigElements.length];
                boolean insertedTop = false;
                int i = 0;
                while (i < solverConfigElements.length) {
                    block11: {
                        DublinCore tmp;
                        IConfigurationElement element = solverConfigElements[i];
                        if (element.getName().equals("classdef")) {
                            try {
                                Solver s = (Solver)element.createExecutableExtension("class");
                                if (s.getClass().getName().equals(prefSolver) && i > 0) {
                                    tmp = (Solver)temp.get(0);
                                    temp.set(0, s);
                                    temp.add(tmp);
                                    insertedTop = true;
                                    break block11;
                                }
                                insertedTop = false;
                                temp.add(s);
                            }
                            catch (CoreException e) {
                                Activator.logError("Can't create solver", e);
                            }
                        } else if (element.getName().equals("dublin_core")) {
                            if (insertedTop) {
                                DublinCore dc = Utility.getPluginDublinCore((IConfigurationElement)element);
                                tmp = (DublinCore)dctemp.get(0);
                                dctemp.set(0, dc);
                                dctemp.add(tmp);
                            } else {
                                dctemp.add(Utility.getPluginDublinCore((IConfigurationElement)element));
                            }
                        }
                    }
                    ++i;
                }
                this.solvers = temp.toArray(new Solver[0]);
                int n = 0;
                n = 0;
                while (n < this.solvers.length) {
                    this.solvers[n].setDublinCore((DublinCore)dctemp.get(n));
                    ++n;
                }
            }
            return this.solvers;
        }

        private String[] getSolverNames(Solver[] solvers) {
            IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
            String prefSolver = preferenceStore.getString("defaultSolver");
            String[] retValue = new String[solvers.length];
            int i = 0;
            while (i < solvers.length) {
                String name = solvers[i].getDublinCore().getTitle();
                if (name == null || name.equals("")) {
                    name = solvers[i].getClass().getSimpleName();
                }
                if (solvers[i].getClass().getName().equals(prefSolver) && i > 0) {
                    String tmp = retValue[0];
                    retValue[0] = name;
                    retValue[i] = tmp;
                } else {
                    retValue[i] = name;
                }
                ++i;
            }
            return retValue;
        }

        void displaySolver(Solver solver) {
            this.solverPC.displaySolver(solver);
        }

        @Override
        protected boolean validatePage() {
            boolean retValue = super.validatePage();
            if (retValue) {
                this.setErrorMessage(null);
                retValue = this.solverPC.validate();
                if (!retValue) {
                    this.setErrorMessage(this.solverPC.getErrorMessage());
                }
            }
            return retValue;
        }
    }

    public static class NewSolverWizardCommandHandler
    extends AbstractHandler
    implements IHandler {
        public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
            IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)executionEvent);
            NewSolverWizard wizard = new NewSolverWizard();
            wizard.init(window.getWorkbench(), (IStructuredSelection)StructuredSelection.EMPTY);
            STEMWizardDialog wizardDialog = new STEMWizardDialog(window.getShell(), (IWizard)wizard);
            wizardDialog.open();
            return null;
        }
    }
}

