/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.diseasemodels.standard.impl;

import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.stem.core.STEMURI;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.core.graph.Exchange;
import org.eclipse.stem.core.graph.ExchangePool;
import org.eclipse.stem.core.graph.ExchangeType;
import org.eclipse.stem.core.graph.Graph;
import org.eclipse.stem.core.graph.IntegrationLabel;
import org.eclipse.stem.core.graph.IntegrationLabelValue;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.core.graph.NodeLabel;
import org.eclipse.stem.core.model.Model;
import org.eclipse.stem.core.model.NodeDecorator;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.core.model.impl.IntegrationDecoratorImpl;
import org.eclipse.stem.core.scenario.ScenarioInitializationException;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProvider;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProviderAdapter;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProviderAdapterFactory;
import org.eclipse.stem.diseasemodels.standard.DiseaseModel;
import org.eclipse.stem.diseasemodels.standard.DiseaseModelLabel;
import org.eclipse.stem.diseasemodels.standard.DiseaseModelLabelValue;
import org.eclipse.stem.diseasemodels.standard.Infector;
import org.eclipse.stem.diseasemodels.standard.StandardPackage;
import org.eclipse.stem.diseasemodels.standard.impl.DiseaseModelLabelImpl;
import org.eclipse.stem.diseasemodels.standard.impl.Messages;
import org.eclipse.stem.interventions.StandardInterventionLabel;
import org.eclipse.stem.populationmodels.standard.DemographicPopulationModel;
import org.eclipse.stem.populationmodels.standard.PopulationGroup;
import org.eclipse.stem.populationmodels.standard.PopulationModel;
import org.eclipse.stem.populationmodels.standard.PopulationModelLabel;
import org.eclipse.stem.populationmodels.standard.StandardFactory;
import org.eclipse.stem.populationmodels.standard.StandardPopulationModel;

public abstract class DiseaseModelImpl
extends IntegrationDecoratorImpl
implements DiseaseModel {
    protected static final String POPULATION_IDENTIFIER_EDEFAULT = "human";
    protected String populationIdentifier = "human";
    protected static final long TIME_PERIOD_EDEFAULT = STEMTime.Units.DAY.getMilliseconds();
    protected long timePeriod = TIME_PERIOD_EDEFAULT;
    protected static final String DISEASE_NAME_EDEFAULT = null;
    protected String diseaseName = DISEASE_NAME_EDEFAULT;
    protected static final boolean FINITE_DIFFERENCE_EDEFAULT = true;
    protected boolean finiteDifference = true;
    protected static final boolean FREQUENCY_DEPENDENT_EDEFAULT = true;
    protected boolean frequencyDependent = true;

    protected EClass eStaticClass() {
        return StandardPackage.Literals.DISEASE_MODEL;
    }

    @Override
    public long getTimePeriod() {
        return this.timePeriod;
    }

    @Override
    public void setTimePeriod(long newTimePeriod) {
        this.timePeriod = newTimePeriod;
    }

    @Override
    public String getPopulationIdentifier() {
        return this.populationIdentifier;
    }

    @Override
    public void setPopulationIdentifier(String newPopulationIdentifier) {
        this.populationIdentifier = newPopulationIdentifier;
    }

    @Override
    public String getDiseaseName() {
        return this.diseaseName;
    }

    @Override
    public void setDiseaseName(String newDiseaseName) {
        this.diseaseName = newDiseaseName;
    }

    @Override
    public boolean isFiniteDifference() {
        return this.finiteDifference;
    }

    @Override
    public void setFiniteDifference(boolean newFiniteDifference) {
        this.finiteDifference = newFiniteDifference;
    }

    @Override
    public boolean isFrequencyDependent() {
        return this.frequencyDependent;
    }

    @Override
    public void setFrequencyDependent(boolean newFrequencyDependent) {
        this.frequencyDependent = newFrequencyDependent;
    }

    @Override
    public DiseaseModelLabel createDiseaseModelLabel(String populationIdentifier) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DiseaseModelLabelValue createDiseaseModelLabelValue(String populationIdentifier) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Infector createInfector() {
        throw new UnsupportedOperationException();
    }

    @Override
    public EList<String> getAllLabelIdentifiers() {
        BasicEList identifiers = new BasicEList();
        identifiers.add((Object)this.getPopulationIdentifier());
        return identifiers;
    }

    @Override
    public EList<PopulationModelLabel> getPopulationModelLabels(String populationIdentifier, Graph graph) throws ScenarioInitializationException {
        BasicEList retValue = new BasicEList();
        EList labels = graph.getNodeLabelsByTypeURI(PopulationModelLabel.URI_TYPE_DYNAMIC_POPULATION_LABEL);
        for (NodeLabel pl : labels) {
            PopulationModelLabel populationLabel = (PopulationModelLabel)pl;
            if (!populationLabel.getPopulationIdentifier().equals(populationIdentifier) || populationLabel.getNode() == null) continue;
            retValue.add((Object)populationLabel);
        }
        return retValue;
    }

    public void decorateGraph(STEMTime time) throws ScenarioInitializationException {
        if (this.isGraphDecorated()) {
            return;
        }
        if (this.getLabelsToUpdate().size() > 0) {
            return;
        }
        boolean success = false;
        for (PopulationModelLabel populationModelLabel : this.getPopulationModelLabels(this.getPopulationIdentifier(), this.getGraph())) {
            success = true;
            DiseaseModelLabel dml = this.createDiseaseModelLabel(populationModelLabel.getPopulationIdentifier());
            DiseaseModelLabelImpl.labelNode(dml, populationModelLabel, populationModelLabel.getNode());
            URI unique = STEMURI.createURI((String)("label/" + populationModelLabel.getNode().getURI().lastSegment() + "/" + this.getDiseaseName() + "/" + populationModelLabel.getPopulationIdentifier()));
            dml.setURI(unique);
            dml.getDublinCore().setIdentifier(unique.toString());
            this.getLabelsToUpdate().add((Object)dml);
            this.getGraph().putNodeLabel((NodeLabel)dml);
        }
        if (!success) {
            throw new ScenarioInitializationException(NLS.bind((String)Messages.DM_MISSING_POP_MOD_LABELS, (Object[])new Object[]{this.getURI().toString(), this.getPopulationIdentifier()}), (Identifiable)this, new Exception());
        }
        this.resetLabels();
    }

    public List<IItemPropertyDescriptor> getCompartments(String populationIdentifier) {
        DiseaseModelLabel label;
        RelativeValueProviderAdapter rvp;
        if (populationIdentifier == null) {
            populationIdentifier = this.getPopulationIdentifier();
        }
        if ((rvp = (RelativeValueProviderAdapter)RelativeValueProviderAdapterFactory.INSTANCE.adapt((Notifier)(label = this.createDiseaseModelLabel(populationIdentifier)), RelativeValueProvider.class)) != null) {
            rvp.setTarget((Notifier)label);
            return rvp.getProperties();
        }
        return null;
    }

    protected boolean findPopulationModel(Model m, String population) {
        boolean found = false;
        for (Model m2 : m.getModels()) {
            found = this.findPopulationModel(m2, population);
            if (found) break;
        }
        if (found) {
            return found;
        }
        for (NodeDecorator dec : m.getNodeDecorators()) {
            if (dec instanceof DemographicPopulationModel) {
                DemographicPopulationModel dpm = (DemographicPopulationModel)dec;
                if (dpm.getPopulationIdentifier().equals(population)) {
                    found = true;
                    break;
                }
                boolean match = false;
                for (PopulationGroup pg : dpm.getPopulationGroups()) {
                    if (!pg.getIdentifier().equals(population)) continue;
                    match = true;
                    break;
                }
                if (!match) continue;
                found = true;
                break;
            }
            if (!(dec instanceof PopulationModel) || !((PopulationModel)dec).getPopulationIdentifier().equals(population)) continue;
            found = true;
            break;
        }
        return found;
    }

    protected StandardInterventionLabel findInterventionLabel(Node node) {
        int i = 0;
        while (i < node.getLabels().size()) {
            NodeLabel l = (NodeLabel)node.getLabels().get(i);
            if (l instanceof StandardInterventionLabel && ((StandardInterventionLabel)l).getPopulationIdentifier().equals(this.getPopulationIdentifier())) {
                return (StandardInterventionLabel)l;
            }
            ++i;
        }
        return null;
    }

    public void prepare(Model model, STEMTime time) {
        boolean found = this.findPopulationModel(model, this.getPopulationIdentifier());
        if (!found) {
            StandardPopulationModel spm = StandardFactory.eINSTANCE.createStandardPopulationModel();
            spm.setPopulationIdentifier(this.getPopulationIdentifier());
            String title = "Auto Generated " + this.getPopulationIdentifier() + " population model";
            String name = "auto_gen_" + this.getPopulationIdentifier() + "_population_model";
            spm.setURI(STEMURI.createURI((String)(String.valueOf(name) + "/" + STEMURI.generateUniquePart())));
            spm.setName(name);
            spm.getDublinCore().setTitle(title);
            if (this.isAddStochasticNoise()) {
                spm.setAddStochasticNoise(true);
            }
            model.getNodeDecorators().add(0, (Object)spm);
        }
    }

    public void computeAdditionalDeltasAndExchanges(IntegrationLabel integrationLabel, STEMTime time, double t, long timeDelta) {
        IntegrationLabelValue delta = integrationLabel.getDeltaValue();
        EList allAttrs = delta.eClass().getEAllAttributes();
        int i = 0;
        while (i < allAttrs.size()) {
            EAttribute attr = (EAttribute)allAttrs.get(i);
            if (DiseaseModelImpl.isDiseaseDeaths(attr)) {
                double deaths = delta.eGetDouble(attr.getFeatureID());
                Exchange deathExchange = (Exchange)ExchangePool.POOL.get();
                deathExchange.setType(ExchangeType.BIRTHS_AND_DEATHS);
                deathExchange.setCount(deaths);
                deathExchange.setSource(StandardPackage.eINSTANCE.getSILabelValue_I());
                deathExchange.setTarget(attr);
                delta.getDepartures().add((Object)deathExchange);
            }
            ++i;
        }
    }

    private static String getAttributeType(EAttribute attr) {
        EAnnotation a = attr.getEAnnotation("org.eclipse.stem.model.compartmentType");
        if (a == null) {
            return null;
        }
        return (String)a.getDetails().get((Object)"type");
    }

    public static boolean isDiseaseDeaths(EAttribute attr) {
        return attr.getName().startsWith("diseaseDeaths") || "Deaths".equalsIgnoreCase(DiseaseModelImpl.getAttributeType(attr));
    }

    public static boolean isIncidence(EAttribute attr) {
        return attr.getName().startsWith("incidence") || "Incidence".equalsIgnoreCase(DiseaseModelImpl.getAttributeType(attr));
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 11: {
                return this.getPopulationIdentifier();
            }
            case 12: {
                return this.getTimePeriod();
            }
            case 13: {
                return this.getDiseaseName();
            }
            case 14: {
                return this.isFiniteDifference();
            }
            case 15: {
                return this.isFrequencyDependent();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 11: {
                this.setPopulationIdentifier((String)newValue);
                return;
            }
            case 12: {
                this.setTimePeriod((Long)newValue);
                return;
            }
            case 13: {
                this.setDiseaseName((String)newValue);
                return;
            }
            case 14: {
                this.setFiniteDifference((Boolean)newValue);
                return;
            }
            case 15: {
                this.setFrequencyDependent((Boolean)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 11: {
                this.setPopulationIdentifier(POPULATION_IDENTIFIER_EDEFAULT);
                return;
            }
            case 12: {
                this.setTimePeriod(TIME_PERIOD_EDEFAULT);
                return;
            }
            case 13: {
                this.setDiseaseName(DISEASE_NAME_EDEFAULT);
                return;
            }
            case 14: {
                this.setFiniteDifference(true);
                return;
            }
            case 15: {
                this.setFrequencyDependent(true);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 11: {
                return POPULATION_IDENTIFIER_EDEFAULT == null ? this.populationIdentifier != null : !POPULATION_IDENTIFIER_EDEFAULT.equals(this.populationIdentifier);
            }
            case 12: {
                return this.timePeriod != TIME_PERIOD_EDEFAULT;
            }
            case 13: {
                return DISEASE_NAME_EDEFAULT == null ? this.diseaseName != null : !DISEASE_NAME_EDEFAULT.equals(this.diseaseName);
            }
            case 14: {
                return !this.finiteDifference;
            }
            case 15: {
                return !this.frequencyDependent;
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (populationIdentifier: ");
        result.append(this.populationIdentifier);
        result.append(", timePeriod: ");
        result.append(this.timePeriod);
        result.append(", diseaseName: ");
        result.append(this.diseaseName);
        result.append(", finiteDifference: ");
        result.append(this.finiteDifference);
        result.append(", frequencyDependent: ");
        result.append(this.frequencyDependent);
        result.append(')');
        return result.toString();
    }

    public boolean sane() {
        boolean retValue = super.sane();
        boolean bl = retValue = retValue && this.getDiseaseName() != null;
        assert (retValue);
        boolean bl2 = retValue = retValue && (double)this.getTimePeriod() >= 0.0;
        assert (retValue);
        return retValue;
    }
}

