/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.diseasemodels.standard.impl;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.BasicInternalEList;
import org.eclipse.osgi.util.NLS;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.core.graph.Graph;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.core.graph.NodeLabel;
import org.eclipse.stem.core.model.Decorator;
import org.eclipse.stem.core.model.NodeDecorator;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.core.model.impl.NodeDecoratorImpl;
import org.eclipse.stem.core.scenario.ScenarioInitializationException;
import org.eclipse.stem.definitions.LocationUtility;
import org.eclipse.stem.definitions.nodes.impl.RegionImpl;
import org.eclipse.stem.diseasemodels.standard.DiseaseModelLabel;
import org.eclipse.stem.diseasemodels.standard.Infector;
import org.eclipse.stem.diseasemodels.standard.InfectorInoculatorCollection;
import org.eclipse.stem.diseasemodels.standard.StandardDiseaseModel;
import org.eclipse.stem.diseasemodels.standard.StandardPackage;
import org.eclipse.stem.diseasemodels.standard.impl.Messages;

public abstract class InfectorImpl
extends NodeDecoratorImpl
implements Infector {
    protected StandardDiseaseModel diseaseModel;
    protected static final URI TARGET_URI_EDEFAULT = null;
    protected URI targetURI = TARGET_URI_EDEFAULT;
    protected static final String DISEASE_NAME_EDEFAULT = null;
    protected String diseaseName = DISEASE_NAME_EDEFAULT;
    protected static final String TARGET_ISO_KEY_EDEFAULT = null;
    protected String targetISOKey = TARGET_ISO_KEY_EDEFAULT;
    protected EList<DiseaseModelLabel> labelsToInfect;
    protected static final String POPULATION_IDENTIFIER_EDEFAULT = null;
    protected String populationIdentifier = POPULATION_IDENTIFIER_EDEFAULT;
    protected static final boolean INFECT_PERCENTAGE_EDEFAULT = false;
    protected boolean infectPercentage = false;
    protected static final String TARGET_FEATURE_EDEFAULT = "i";
    protected String targetFeature = "i";

    public void decorateGraph(STEMTime time) throws ScenarioInitializationException {
        if (this.isGraphDecorated()) {
            return;
        }
        Graph graph = this.getGraph();
        if (graph == null && this.eContainer() instanceof InfectorInoculatorCollection) {
            graph = ((NodeDecorator)this.eContainer()).getGraph();
        }
        if (this.getDiseaseModel() == null) {
            for (Decorator decorator : graph.getDecorators()) {
                StandardDiseaseModel diseaseModel;
                if (!(decorator instanceof StandardDiseaseModel) || !(diseaseModel = (StandardDiseaseModel)decorator).getDiseaseName().equalsIgnoreCase(this.getDiseaseName())) continue;
                this.setDiseaseModel(diseaseModel);
                break;
            }
        }
        if (this.getDiseaseModel() != null) {
            Node parent = graph.getNode(this.getTargetURI());
            HashSet<Node> allNodes = null;
            if (this.isInfectPercentage()) {
                allNodes = LocationUtility.getAllChildren((Node)parent);
                allNodes.add(parent);
            } else {
                allNodes = new HashSet<Node>();
                allNodes.add(parent);
            }
            Iterator iter = allNodes.iterator();
            block1: while (iter != null && iter.hasNext()) {
                Node node = (Node)iter.next();
                if (node != null) {
                    for (NodeLabel nodeLabel : node.getLabels()) {
                        DiseaseModelLabel diseaseModelLabel;
                        if (!(nodeLabel instanceof DiseaseModelLabel) || (diseaseModelLabel = (DiseaseModelLabel)nodeLabel).getDecorator() != this.getDiseaseModel() || !diseaseModelLabel.getPopulationModelLabel().getPopulationIdentifier().equals(this.getPopulationIdentifier())) continue;
                        this.doInitialization(diseaseModelLabel);
                        this.getLabelsToInfect().add((Object)diseaseModelLabel);
                        continue block1;
                    }
                    continue;
                }
                throw new ScenarioInitializationException(NLS.bind((String)Messages.INF_NODE_NOT_FOUND, (Object[])new Object[]{this.getTargetURI(), this.getURI().toString()}), (Identifiable)this, new Exception());
            }
        } else {
            throw new ScenarioInitializationException(NLS.bind((String)Messages.INFECTOR_DISEASE_NOT_FOUND, (Object[])new Object[]{this.getDiseaseName(), this.getURI().toString()}), (Identifiable)this, new Exception());
        }
        this.setProgress(1.0);
    }

    public void resetLabels() throws ScenarioInitializationException {
        for (DiseaseModelLabel diseaseModelLabel : this.getLabelsToInfect()) {
            this.doInitialization(diseaseModelLabel);
        }
    }

    public void updateLabels(STEMTime time, long timerPeriod, int cycle) {
    }

    protected EClass eStaticClass() {
        return StandardPackage.Literals.INFECTOR;
    }

    @Override
    public StandardDiseaseModel getDiseaseModel() {
        if (this.diseaseModel != null && this.diseaseModel.eIsProxy()) {
            InternalEObject oldDiseaseModel = (InternalEObject)this.diseaseModel;
            this.diseaseModel = (StandardDiseaseModel)this.eResolveProxy(oldDiseaseModel);
        }
        return this.diseaseModel;
    }

    public StandardDiseaseModel basicGetDiseaseModel() {
        return this.diseaseModel;
    }

    @Override
    public void setDiseaseModel(StandardDiseaseModel newDiseaseModel) {
        StandardDiseaseModel oldDiseaseModel = this.getDiseaseModel();
        this.diseaseModel = newDiseaseModel;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 8, (Object)oldDiseaseModel, (Object)this.getDiseaseModel()));
        }
        this.setDiseaseName(this.getDiseaseModel() != null ? this.getDiseaseModel().getDiseaseName() : null);
    }

    @Override
    public URI getTargetURI() {
        if (this.targetURI == null) {
            this.targetURI = RegionImpl.createRegionNodeURI((String)this.getTargetISOKey());
        }
        return this.targetURI;
    }

    @Override
    public void setTargetURI(URI newTargetURI) {
        this.targetURI = newTargetURI;
    }

    @Override
    public String getDiseaseName() {
        return this.diseaseName;
    }

    @Override
    public void setDiseaseName(String newDiseaseName) {
        this.diseaseName = newDiseaseName;
    }

    @Override
    public String getTargetISOKey() {
        return this.targetISOKey;
    }

    @Override
    public void setTargetISOKey(String newTargetISOKey) {
        String oldTargetISOKey = this.targetISOKey;
        this.targetISOKey = newTargetISOKey;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 11, (Object)oldTargetISOKey, (Object)this.targetISOKey));
        }
    }

    @Override
    public EList<DiseaseModelLabel> getLabelsToInfect() {
        if (this.labelsToInfect == null) {
            this.labelsToInfect = new BasicInternalEList(DiseaseModelLabel.class);
        }
        return this.labelsToInfect;
    }

    @Override
    public String getPopulationIdentifier() {
        return this.populationIdentifier;
    }

    @Override
    public void setPopulationIdentifier(String newPopulationIdentifier) {
        this.populationIdentifier = newPopulationIdentifier;
    }

    @Override
    public boolean isInfectPercentage() {
        return this.infectPercentage;
    }

    @Override
    public void setInfectPercentage(boolean newInfectPercentage) {
        this.infectPercentage = newInfectPercentage;
    }

    @Override
    public String getTargetFeature() {
        return this.targetFeature;
    }

    @Override
    public void setTargetFeature(String newTargetFeature) {
        this.targetFeature = newTargetFeature;
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 8: {
                if (resolve) {
                    return this.getDiseaseModel();
                }
                return this.basicGetDiseaseModel();
            }
            case 9: {
                return this.getTargetURI();
            }
            case 10: {
                return this.getDiseaseName();
            }
            case 11: {
                return this.getTargetISOKey();
            }
            case 12: {
                return this.getLabelsToInfect();
            }
            case 13: {
                return this.getPopulationIdentifier();
            }
            case 14: {
                return this.isInfectPercentage();
            }
            case 15: {
                return this.getTargetFeature();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 8: {
                this.setDiseaseModel((StandardDiseaseModel)newValue);
                return;
            }
            case 9: {
                this.setTargetURI((URI)newValue);
                return;
            }
            case 10: {
                this.setDiseaseName((String)newValue);
                return;
            }
            case 11: {
                this.setTargetISOKey((String)newValue);
                return;
            }
            case 12: {
                this.getLabelsToInfect().clear();
                this.getLabelsToInfect().addAll((Collection)newValue);
                return;
            }
            case 13: {
                this.setPopulationIdentifier((String)newValue);
                return;
            }
            case 14: {
                this.setInfectPercentage((Boolean)newValue);
                return;
            }
            case 15: {
                this.setTargetFeature((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 8: {
                this.setDiseaseModel(null);
                return;
            }
            case 9: {
                this.setTargetURI(TARGET_URI_EDEFAULT);
                return;
            }
            case 10: {
                this.setDiseaseName(DISEASE_NAME_EDEFAULT);
                return;
            }
            case 11: {
                this.setTargetISOKey(TARGET_ISO_KEY_EDEFAULT);
                return;
            }
            case 12: {
                this.getLabelsToInfect().clear();
                return;
            }
            case 13: {
                this.setPopulationIdentifier(POPULATION_IDENTIFIER_EDEFAULT);
                return;
            }
            case 14: {
                this.setInfectPercentage(false);
                return;
            }
            case 15: {
                this.setTargetFeature(TARGET_FEATURE_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 8: {
                return this.diseaseModel != null;
            }
            case 9: {
                return TARGET_URI_EDEFAULT == null ? this.targetURI != null : !TARGET_URI_EDEFAULT.equals(this.targetURI);
            }
            case 10: {
                return DISEASE_NAME_EDEFAULT == null ? this.diseaseName != null : !DISEASE_NAME_EDEFAULT.equals(this.diseaseName);
            }
            case 11: {
                return TARGET_ISO_KEY_EDEFAULT == null ? this.targetISOKey != null : !TARGET_ISO_KEY_EDEFAULT.equals(this.targetISOKey);
            }
            case 12: {
                return this.labelsToInfect != null && !this.labelsToInfect.isEmpty();
            }
            case 13: {
                return POPULATION_IDENTIFIER_EDEFAULT == null ? this.populationIdentifier != null : !POPULATION_IDENTIFIER_EDEFAULT.equals(this.populationIdentifier);
            }
            case 14: {
                return this.infectPercentage;
            }
            case 15: {
                return TARGET_FEATURE_EDEFAULT == null ? this.targetFeature != null : !TARGET_FEATURE_EDEFAULT.equals(this.targetFeature);
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer();
        result.append(" (populationIdentifier: ");
        result.append(this.getPopulationIdentifier() != null ? this.getPopulationIdentifier() : "\"\"");
        result.append(", targetURI: ");
        result.append(this.getTargetURI() != null ? this.getTargetURI() : "\"\"");
        result.append(", diseaseName: ");
        result.append(this.getDiseaseName() != null ? this.getDiseaseName() : "\"\"");
        result.append(", targetISOKey: ");
        result.append(this.getTargetISOKey() != null ? this.getTargetISOKey() : "\"\"");
        result.append(')');
        return result.toString();
    }

    public boolean sane() {
        boolean retValue = super.sane();
        boolean bl = retValue = retValue && (this.getTargetISOKey() != null || this.getTargetURI() != null);
        assert (retValue);
        return retValue;
    }

    protected abstract void doInitialization(DiseaseModelLabel var1) throws ScenarioInitializationException;
}

