/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.diseasemodels.standard.impl;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.stem.core.graph.DynamicLabel;
import org.eclipse.stem.core.graph.Exchange;
import org.eclipse.stem.core.graph.ExchangePool;
import org.eclipse.stem.core.graph.ExchangeType;
import org.eclipse.stem.core.graph.IntegrationLabel;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.diseasemodels.standard.DiseaseModelLabel;
import org.eclipse.stem.diseasemodels.standard.DiseaseModelLabelValue;
import org.eclipse.stem.diseasemodels.standard.SEIR;
import org.eclipse.stem.diseasemodels.standard.SEIRLabelValue;
import org.eclipse.stem.diseasemodels.standard.StandardDiseaseModelLabel;
import org.eclipse.stem.diseasemodels.standard.StandardDiseaseModelLabelValue;
import org.eclipse.stem.diseasemodels.standard.StandardFactory;
import org.eclipse.stem.diseasemodels.standard.StandardPackage;
import org.eclipse.stem.diseasemodels.standard.impl.SEIRLabelValueImpl;
import org.eclipse.stem.diseasemodels.standard.impl.SIRImpl;
import org.eclipse.stem.interventions.StandardInterventionLabel;
import org.eclipse.stem.interventions.StandardInterventionLabelValue;

public class SEIRImpl
extends SIRImpl
implements SEIR {
    protected static final double INCUBATION_RATE_EDEFAULT = 0.0;
    protected double incubationRate = 0.0;

    @Override
    public void calculateDeltas(STEMTime time, double t, long timeDelta, EList<DynamicLabel> labels) {
        double adjustedInfectiousMortalityRate = this.getAdjustedInfectiousMortalityRate(timeDelta);
        double transmissionRate = this.getAdjustedTransmissionRate(timeDelta);
        double adjustedRecoveryRate = this.getAdjustedRecoveryRate(timeDelta);
        double adjustedImmunityLossRate = this.getAdjustedImmunityLossRate(timeDelta);
        double adjustedIncubationRate = this.getAdjustedIncubationRate(timeDelta);
        int _i = 0;
        while (_i < labels.size()) {
            DynamicLabel label = (DynamicLabel)labels.get(_i);
            IntegrationLabel ilabel = (IntegrationLabel)label;
            StandardDiseaseModelLabel diseaseLabel = (StandardDiseaseModelLabel)ilabel;
            StandardDiseaseModelLabelValue currentState = (StandardDiseaseModelLabelValue)ilabel.getProbeValue();
            StandardDiseaseModelLabelValue deltaValue = (StandardDiseaseModelLabelValue)ilabel.getDeltaValue();
            deltaValue.reset();
            SEIRLabelValue currentSEIR = (SEIRLabelValue)currentState;
            double diseaseDeaths = adjustedInfectiousMortalityRate * currentSEIR.getI();
            if (!this.isFrequencyDependent()) {
                transmissionRate *= this.getTransmissionRateScaleFactor(diseaseLabel);
            }
            double effectiveInfectious = this.getNormalizedEffectiveInfectious(diseaseLabel.getNode(), diseaseLabel, currentSEIR.getI(), StandardPackage.Literals.SI_LABEL_VALUE__I, StandardPackage.Literals.STANDARD_DISEASE_MODEL__CHARACTERISTIC_MIXING_DISTANCE, StandardPackage.Literals.STANDARD_DISEASE_MODEL__ROAD_NETWORK_INFECTIOUS_PROPORTION);
            double numberOfInfectedToRecovered = adjustedRecoveryRate * currentSEIR.getI();
            double numberOfRecoveredToSusceptible = adjustedImmunityLossRate * currentSEIR.getR();
            double numberOfSusceptibleToExposed = 0.0;
            numberOfSusceptibleToExposed = this.getNonLinearityCoefficient() != 1.0 && effectiveInfectious >= 0.0 ? transmissionRate * currentSEIR.getS() * Math.pow(effectiveInfectious, this.getNonLinearityCoefficient()) : transmissionRate * currentSEIR.getS() * effectiveInfectious;
            double numberOfExposedToInfectious = adjustedIncubationRate * currentSEIR.getE();
            double deltaS = numberOfRecoveredToSusceptible - numberOfSusceptibleToExposed;
            double deltaE = numberOfSusceptibleToExposed - numberOfExposedToInfectious;
            double deltaI = numberOfExposedToInfectious - numberOfInfectedToRecovered - diseaseDeaths;
            double deltaR = numberOfInfectedToRecovered - numberOfRecoveredToSusceptible;
            StandardInterventionLabel scl = this.findInterventionLabel((Node)diseaseLabel.getIdentifiable());
            double vaccinations = 0.0;
            double isolations = 0.0;
            if (scl != null) {
                vaccinations = ((StandardInterventionLabelValue)scl.getCurrentValue()).getVaccinations();
                isolations = ((StandardInterventionLabelValue)scl.getCurrentValue()).getIsolations();
                vaccinations *= (double)timeDelta / (double)this.getTimePeriod();
                isolations *= (double)timeDelta / (double)this.getTimePeriod();
                if (currentSEIR.getS() < vaccinations) {
                    vaccinations = currentSEIR.getS();
                }
                if (currentSEIR.getI() < isolations) {
                    isolations = currentSEIR.getI();
                }
                deltaS -= vaccinations;
                deltaR += vaccinations;
                deltaI -= isolations;
                deltaR += isolations;
            }
            Exchange seExchange = (Exchange)ExchangePool.POOL.get();
            seExchange.setSource(StandardPackage.eINSTANCE.getStandardDiseaseModelLabelValue_S());
            seExchange.setTarget(StandardPackage.eINSTANCE.getSEIRLabelValue_E());
            seExchange.setCount(numberOfSusceptibleToExposed);
            seExchange.getForIncidence().add((Object)StandardPackage.eINSTANCE.getStandardDiseaseModelLabelValue_Incidence());
            seExchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
            deltaValue.getDepartures().add((Object)seExchange);
            Exchange eiExchange = (Exchange)ExchangePool.POOL.get();
            eiExchange.setSource(StandardPackage.eINSTANCE.getSEIRLabelValue_E());
            eiExchange.setTarget(StandardPackage.eINSTANCE.getSILabelValue_I());
            eiExchange.setCount(numberOfExposedToInfectious);
            eiExchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
            deltaValue.getDepartures().add((Object)eiExchange);
            Exchange irExchange = (Exchange)ExchangePool.POOL.get();
            irExchange.setSource(StandardPackage.eINSTANCE.getSILabelValue_I());
            irExchange.setTarget(StandardPackage.eINSTANCE.getSIRLabelValue_R());
            irExchange.setCount(numberOfInfectedToRecovered);
            irExchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
            deltaValue.getDepartures().add((Object)irExchange);
            Exchange rsExchange = (Exchange)ExchangePool.POOL.get();
            rsExchange.setSource(StandardPackage.eINSTANCE.getSIRLabelValue_R());
            rsExchange.setTarget(StandardPackage.eINSTANCE.getStandardDiseaseModelLabelValue_S());
            rsExchange.setCount(numberOfRecoveredToSusceptible);
            rsExchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
            deltaValue.getDepartures().add((Object)rsExchange);
            if (vaccinations > 0.0) {
                Exchange srExchange = (Exchange)ExchangePool.POOL.get();
                srExchange.setSource(StandardPackage.eINSTANCE.getStandardDiseaseModelLabelValue_S());
                srExchange.setTarget(StandardPackage.eINSTANCE.getSIRLabelValue_R());
                srExchange.setCount(vaccinations);
                srExchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
                deltaValue.getDepartures().add((Object)srExchange);
            }
            if (isolations > 0.0) {
                Exchange irIsoExchange = (Exchange)ExchangePool.POOL.get();
                irIsoExchange.setSource(StandardPackage.eINSTANCE.getSILabelValue_I());
                irIsoExchange.setTarget(StandardPackage.eINSTANCE.getSIRLabelValue_R());
                irIsoExchange.setCount(isolations);
                irIsoExchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
                deltaValue.getDepartures().add((Object)irIsoExchange);
            }
            SEIRLabelValueImpl ret = (SEIRLabelValueImpl)deltaValue;
            ret.setS(deltaS);
            ret.setE(deltaE);
            ret.setI(deltaI);
            ret.setIncidence(numberOfSusceptibleToExposed);
            ret.setR(deltaR);
            ret.setDiseaseDeaths(diseaseDeaths);
            this.computeAdditionalDeltasAndExchanges(ilabel, time, t, timeDelta);
            ++_i;
        }
    }

    @Override
    public DiseaseModelLabel createDiseaseModelLabel(String populationIdentifier) {
        return StandardFactory.eINSTANCE.createSEIRLabel();
    }

    @Override
    public DiseaseModelLabelValue createDiseaseModelLabelValue(String populationIdentifier) {
        return StandardFactory.eINSTANCE.createSEIRLabelValue();
    }

    @Override
    protected EClass eStaticClass() {
        return StandardPackage.Literals.SEIR;
    }

    @Override
    public double getIncubationRate() {
        return this.incubationRate;
    }

    @Override
    public void setIncubationRate(double newIncubationRate) {
        this.incubationRate = newIncubationRate;
    }

    @Override
    public double getAdjustedIncubationRate(long timeDelta) {
        return this.getIncubationRate() * ((double)timeDelta / (double)this.getTimePeriod());
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 24: {
                return this.getIncubationRate();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 24: {
                this.setIncubationRate((Double)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 24: {
                this.setIncubationRate(0.0);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 24: {
                return this.incubationRate != 0.0;
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (incubationRate: ");
        result.append(this.incubationRate);
        result.append(')');
        return result.toString();
    }

    @Override
    public boolean sane() {
        boolean retValue = super.sane();
        boolean bl = retValue = retValue && this.getIncubationRate() >= 0.0;
        assert (retValue);
        boolean bl2 = retValue = retValue && !Double.isInfinite(this.getIncubationRate());
        assert (retValue);
        boolean bl3 = retValue = retValue && !Double.isNaN(this.getIncubationRate());
        assert (retValue);
        return retValue;
    }
}

