/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.util.analysis;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.stem.analysis.impl.ReferenceScenarioDataMapImpl;
import org.eclipse.stem.util.analysis.LinearLeastSquaresFit;
import org.eclipse.stem.util.analysis.ModelParameters;
import org.eclipse.stem.util.analysis.Parameter;
import org.eclipse.stem.util.analysis.ParameterEstimator;

public class SIparameterEstimator
extends ParameterEstimator {
    public SIparameterEstimator(ReferenceScenarioDataMapImpl.ReferenceScenarioDataInstance data) {
        super(data);
        ArrayList<Double> sToFit = new ArrayList<Double>();
        ArrayList<Double> iToFit = new ArrayList<Double>();
        List sList = data.getStotals();
        List iList = data.getItotals();
        int icount = 1;
        while (icount < iList.size()) {
            iToFit.add((Double)iList.get(icount));
            sToFit.add((Double)sList.get(icount));
            ++icount;
        }
        this.numDataPoints = iToFit.size();
        if (this.numDataPoints < 7) {
            return;
        }
        this.dataValid = true;
        this.p = new double[this.numDataPoints];
        this.s = new double[this.numDataPoints];
        this.i = new double[this.numDataPoints];
        this.t = new double[this.numDataPoints];
        icount = 0;
        while (icount < this.numDataPoints) {
            this.s[icount] = (Double)sToFit.get(icount);
            this.i[icount] = (Double)iToFit.get(icount);
            this.p[icount] = this.s[icount] + this.i[icount];
            this.t[icount] = icount;
            ++icount;
        }
    }

    @Override
    public ModelParameters estimate(double localDensity, double localPopulation, String locationID) {
        ModelParameters fittedParms = new ModelParameters();
        int npts = this.s.length;
        assert (npts == this.i.length);
        double[] lnS = new double[npts];
        double[] dlnS = new double[npts - 1];
        double[] lnI = new double[npts];
        double[] dlnI = new double[npts - 1];
        double[] sAvg = new double[npts - 1];
        double[] iAvg = new double[npts - 1];
        double[] pAvg = new double[npts - 1];
        double[][] dataS = new double[2][npts - 1];
        double[][] dataI = new double[2][npts - 1];
        int j = 0;
        while (j < npts) {
            lnS[j] = this.s[j] >= 0.0 ? Math.log(this.s[j]) : -1.0;
            lnI[j] = this.i[j] >= 0.0 ? Math.log(this.i[j]) : -1.0;
            ++j;
        }
        j = 1;
        while (j < npts - 1) {
            dlnS[j - 1] = lnS[j] - lnS[j - 1];
            dlnI[j - 1] = lnI[j] - lnI[j - 1];
            sAvg[j - 1] = (this.s[j] + this.s[j - 1]) / 2.0;
            iAvg[j - 1] = (this.i[j] + this.i[j - 1]) / 2.0;
            pAvg[j - 1] = (this.p[j] + this.p[j - 1]) / 2.0;
            ++j;
        }
        double sMax = this.data.getMaxS();
        double iMax = this.data.getMaxI();
        ArrayList<Double> xList1 = new ArrayList<Double>();
        ArrayList<Double> yList1 = new ArrayList<Double>();
        ArrayList<Double> fitList1 = new ArrayList<Double>();
        int j2 = 0;
        while (j2 < npts - 1) {
            double sNorm = sAvg[j2] / sMax;
            double iNorm = iAvg[j2] / iMax;
            dataS[0][j2] = sNorm;
            dataI[0][j2] = iNorm;
            dataS[1][j2] = sNorm;
            dataI[1][j2] = iNorm;
            if (sNorm <= maxSthreshold && sNorm >= minSthreshold && iNorm >= minIthreshold) {
                double numer = pAvg[j2] / sAvg[j2];
                xList1.add(numer);
                yList1.add(pAvg[j2] / iAvg[j2] * dlnS[j2]);
            } else {
                dataS[1][j2] = 0.0;
                dataI[1][j2] = 0.0;
            }
            ++j2;
        }
        LinearLeastSquaresFit lineFit1 = null;
        if (xList1.size() > 2) {
            lineFit1 = new LinearLeastSquaresFit(xList1, yList1);
            double beta = lineFit1.getIntercept();
            double varBeta = lineFit1.getInterceptVariance();
            double stdBeta = lineFit1.getInterceptStdDev();
            double alpha = lineFit1.getSlope();
            double varAlpha = lineFit1.getSlopeVariance();
            double stdAlpha = lineFit1.getSlopeStdDev();
            double newbeta = beta;
            if (!useFreqDependantBeta) {
                newbeta *= 100.0 / localDensity;
            }
            fittedParms.addParameter("beta", new Parameter("beta", newbeta, stdBeta, varBeta));
            fittedParms.addParameter("alpha", new Parameter("alpha", alpha, stdAlpha, varAlpha));
            int i = 0;
            while (i < xList1.size()) {
                double val = lineFit1.getSlope() * (Double)xList1.get(i) + lineFit1.getIntercept();
                fitList1.add(val);
                ++i;
            }
        } else {
            this.rejectCount += 1.0;
        }
        ArrayList<Double> xList2 = new ArrayList<Double>();
        ArrayList<Double> yList2 = new ArrayList<Double>();
        ArrayList<Double> fitList2 = new ArrayList<Double>();
        int j3 = 0;
        while (j3 < npts - 1) {
            double sNorm = sAvg[j3] / sMax;
            double iNorm = iAvg[j3] / iMax;
            if (sNorm <= maxSthreshold && sNorm >= minSthreshold && iNorm >= minIthreshold) {
                xList2.add(pAvg[j3] / sAvg[j3]);
                yList2.add(pAvg[j3] / sAvg[j3] * dlnI[j3]);
            }
            ++j3;
        }
        LinearLeastSquaresFit lineFit2 = null;
        if (xList2.size() > 2) {
            lineFit2 = new LinearLeastSquaresFit(xList2, yList2);
            double beta2 = lineFit2.getIntercept();
            double varBeta2 = lineFit2.getInterceptVariance();
            double stdBeta2 = lineFit2.getInterceptStdDev();
            double alpha2 = lineFit2.getSlope();
            double varAlpha2 = lineFit2.getSlopeVariance();
            double stdAlpha2 = lineFit2.getSlopeStdDev();
            double newbeta2 = beta2 * (100.0 / localDensity);
            fittedParms.addParameter("beta2", new Parameter("beta2", newbeta2, stdBeta2, varBeta2));
            fittedParms.addParameter("alpha2", new Parameter("alpha2", alpha2, stdAlpha2, varAlpha2));
            int i = 0;
            while (i < xList2.size()) {
                double val = lineFit2.getSlope() * (Double)xList2.get(i) + lineFit2.getIntercept();
                fitList2.add(val);
                ++i;
            }
        } else {
            this.rejectCount += 1.0;
        }
        fittedParms.addParameter("rejected", new Parameter("rejected", this.rejectCount));
        this.dataToPlot.add(dataS);
        this.dataToPlot.add(dataI);
        fittedParms.addSelectedData(locationID, this.dataToPlot);
        double[][] regression1 = this.getSortedRegression(xList1, yList1);
        double[][] regression2 = this.getSortedRegression(xList2, yList2);
        double[][] fit1 = this.getSortedRegression(xList1, fitList1);
        double[][] fit2 = this.getSortedRegression(xList2, fitList2);
        this.regressionValues.add(regression1);
        this.regressionValues.add(regression2);
        this.fittedValues.add(fit1);
        this.fittedValues.add(fit2);
        fittedParms.addRegressionData(locationID, this.regressionValues);
        fittedParms.addFittedData(locationID, this.fittedValues);
        return fittedParms;
    }

    @Override
    public int getNumProperties() {
        return 2;
    }
}

