/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.definitions.adapters.spatial.geo;

import java.util.ArrayList;
import java.util.List;

public class LatLong {
    public static final int NUMBER_OF_FACTIONAL_DIGITS = 6;
    private final List<Segment> segments = new ArrayList<Segment>();

    public void add(Segment segment) {
        this.segments.add(segment);
    }

    public void add(List<Segment> segments) {
        this.segments.addAll(segments);
    }

    public void add(LatLong latLong) {
        this.segments.addAll(latLong.getSegments());
    }

    public final List<Segment> getSegments() {
        return this.segments;
    }

    public final int size() {
        return this.segments.size();
    }

    public String toString() {
        return Integer.toString(this.size());
    }

    static String formatLatLngValue(double value, double fracDigits) {
        double power = Math.pow(10.0, fracDigits);
        return String.valueOf((double)((long)(value * power)) / power);
    }

    static String formatLatLngValue(double value) {
        return LatLong.formatLatLngValue(value, 6.0);
    }

    public static class Segment {
        static final int LATITUDE_INDEX = 0;
        static final int LONGITUDE_INDEX = 1;
        private double[][] data = null;

        public Segment(double[][] data) {
            this.data = data;
        }

        public double latitude(int i) {
            return this.data[i][0];
        }

        public double longitude(int i) {
            return this.data[i][1];
        }

        public int size() {
            return this.data.length;
        }

        public boolean isPolygon() {
            int size = this.data.length;
            return size > 2 && this.data[0][0] == this.data[size - 1][0] && this.data[0][1] == this.data[size - 1][1];
        }

        public String toInlineURIString() {
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < this.data.length) {
                sb.append(LatLong.formatLatLngValue(this.data[i][0]));
                sb.append(",");
                sb.append(LatLong.formatLatLngValue(this.data[i][1]));
                if (i < this.data.length - 1) {
                    sb.append(",");
                }
                ++i;
            }
            return sb.toString();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.data.length > 0) {
                sb.append(LatLong.formatLatLngValue(this.data[0][0]));
                sb.append(",");
                sb.append(LatLong.formatLatLngValue(this.data[0][1]));
                if (this.data.length > 2) {
                    sb.append("...<" + (this.data.length - 2) + ">...");
                }
                if (this.data.length > 1) {
                    sb.append(LatLong.formatLatLngValue(this.data[this.data.length - 1][0]));
                    sb.append(",");
                    sb.append(LatLong.formatLatLngValue(this.data[this.data.length - 1][1]));
                }
            }
            return sb.toString();
        }

        public int hashCode() {
            double sum = 1.0;
            double[][] dArray = this.data;
            int n = this.data.length;
            int n2 = 0;
            while (n2 < n) {
                double[] element = dArray[n2];
                sum += Math.abs(element[0] + element[1]);
                ++n2;
            }
            int temp = (int)sum * 31;
            return temp + this.data.length;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Segment other = (Segment)obj;
            if (this.data.length != other.data.length) {
                return false;
            }
            double[][] dArray = this.data;
            int n = this.data.length;
            int n2 = 0;
            while (n2 < n) {
                double[] element = dArray[n2];
                if (element[0] != element[0]) {
                    return false;
                }
                if (element[1] != element[1]) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
    }

    public static class SegmentBuilder {
        private final List<LatLongPair> collectedPairs = new ArrayList<LatLongPair>();

        public void add(String latitudeString, String longitudeString) throws NumberFormatException {
            double dLat = Double.parseDouble(latitudeString);
            double dLng = Double.parseDouble(longitudeString);
            this.add(dLat, dLng);
        }

        public void add(double latitude, double longitude) {
            this.collectedPairs.add(new LatLongPair(latitude, longitude));
        }

        public int size() {
            return this.collectedPairs.size();
        }

        public void clear() {
            this.collectedPairs.clear();
        }

        public Segment toSegment() {
            return this.toSegment(this.collectedPairs);
        }

        public Segment toSegment(int sampleFrequency) {
            return this.toSegment(this.createDownSampledPairs(sampleFrequency, this.collectedPairs));
        }

        private final List<LatLongPair> createDownSampledPairs(int sampleFrequency, List<LatLongPair> pairs) {
            ArrayList<LatLongPair> downSampledPairs = new ArrayList<LatLongPair>();
            if (sampleFrequency >= 1) {
                int lastPoint = this.collectedPairs.size() - 1;
                if (sampleFrequency < lastPoint) {
                    int dataPointCounter = 0;
                    for (LatLongPair pair : pairs) {
                        if (dataPointCounter % sampleFrequency == 0 || dataPointCounter == lastPoint) {
                            downSampledPairs.add(pair);
                        }
                        ++dataPointCounter;
                    }
                } else {
                    downSampledPairs.add(pairs.get(0));
                    downSampledPairs.add(pairs.get(pairs.size() / 2));
                    downSampledPairs.add(pairs.get(lastPoint));
                }
            } else {
                throw new IllegalArgumentException("Sample frequency \"" + sampleFrequency + "\" must be 1 or greater");
            }
            return downSampledPairs;
        }

        private Segment toSegment(List<LatLongPair> pairs) {
            double[][] data = new double[pairs.size()][2];
            int i = 0;
            for (LatLongPair latLongPair : pairs) {
                data[i][0] = latLongPair.latitude;
                data[i][1] = latLongPair.longitude;
                ++i;
            }
            return new Segment(data);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.size() > 0) {
                sb.append(this.collectedPairs.get(0).toString());
                if (this.size() > 2) {
                    sb.append("...<" + (this.size() - 2) + ">...");
                }
                if (this.size() > 1) {
                    sb.append(this.collectedPairs.get(this.size() - 1).toString());
                }
            }
            return sb.toString();
        }

        private static class LatLongPair {
            double latitude = 0.0;
            double longitude = 0.0;

            protected LatLongPair(double latitude, double longitude) {
                assert (longitude >= -180.0 && longitude <= 180.0);
                assert (latitude >= -90.0 && latitude <= 90.0);
                this.latitude = latitude;
                this.longitude = longitude;
            }

            public String toString() {
                StringBuffer sb = new StringBuffer();
                sb.append(LatLong.formatLatLngValue(this.latitude));
                sb.append(", ");
                sb.append(LatLong.formatLatLngValue(this.longitude));
                return sb.toString();
            }
        }
    }
}

