/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.ge.servlet;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Enumeration;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.stem.ui.Activator;
import org.eclipse.stem.ui.ge.servlet.SlideShowServlet;

public class StartServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    public static final String CONTEXT = "/STEM";
    private static String debug = "n";
    private static boolean TEST = false;
    static final String STEM_FOLDER = "c:\\tmp\\ge";
    static final String VERSION = "1.0.1";

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.debug("init: 1.0.1 invoked at startup or deploy");
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.debug("doGet");
        this.doPost(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.debug("doPost");
        String folderName = STEM_FOLDER;
        String waitForKML = "n";
        String interval = "2";
        File folder = null;
        try {
            Enumeration e = request.getParameterNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                String value = request.getParameter(name);
                this.debug(String.valueOf(name) + "=" + value);
                if (name.equals("folder")) {
                    folderName = value;
                    continue;
                }
                if (name.equals("wait")) {
                    waitForKML = value;
                    continue;
                }
                if (name.equals("interval")) {
                    interval = value;
                    continue;
                }
                if (!name.equals("debug")) continue;
                debug = value;
            }
            SlideShowServlet.DEBUG = debug.toLowerCase().startsWith("y");
            folder = new File(folderName);
            this.debug("folder: " + folder.getAbsolutePath());
            long time = 0L;
            String info = "IPaddr: " + request.getRemoteAddr() + " folder: " + folder.getAbsolutePath() + " time: " + time;
            this.debug(info);
            this.sendOutput(request, response, folderName, waitForKML, interval);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private synchronized void sendOutput(HttpServletRequest request, HttpServletResponse response, String folderName, String waitForKML, String interval) throws IOException {
        int port = request.getServerPort();
        String host = String.valueOf(request.getServerName()) + ":" + port;
        long time = new Date().getTime();
        String id = Long.toHexString(time);
        PrintWriter os = new PrintWriter((OutputStream)response.getOutputStream());
        if (TEST) {
            String msg = " KML NetworkLink file: ";
            response.setContentType("text/html");
            os.println("<html>");
            os.println("<head><title>Start Slideshow</title></head>");
            os.println("<body>");
            os.println("<p>" + msg + "</p>");
        } else {
            response.setContentType("application/keyhole");
        }
        try {
            os.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            os.println("<kml xmlns=\"http://earth.google.com/kml/2.0\">");
            os.println("<Folder>");
            os.println("   <description>SlideShow NetworkLink</description>");
            os.println("   <name>Network Links</name>");
            os.println("<NetworkLink>");
            os.println("<Url>");
            String url = "<href>http://" + host + CONTEXT + "/slideshow?id=" + id + "&amp;folder=" + folderName + "&amp;wait=" + waitForKML + "</href>";
            os.println(url);
            this.debug(url);
            os.println("<refreshInterval>" + interval + "</refreshInterval>");
            os.println("<refreshMode>onInterval</refreshMode>");
            os.println("</Url>");
            os.println("<flyToView>0</flyToView>");
            os.println("</NetworkLink>");
            os.println("</Folder>");
            os.println("</kml>");
        }
        catch (Exception e) {
            String msg = "SlideShow startup failure";
            this.debug(msg, e);
            this.errHtml(response, String.valueOf(msg) + e.getMessage());
        }
        if (TEST) {
            os.println("</body></html>");
        }
        os.flush();
    }

    private void debug(String msg) {
        if (SlideShowServlet.DEBUG) {
            Activator.logInformation((String)("StartServlet: " + msg));
        }
    }

    private void debug(String msg, Throwable e) {
        System.err.println(msg);
        e.printStackTrace();
    }

    private void errHtml(HttpServletResponse response, String msg) throws IOException {
        response.setContentType("text/html");
        PrintWriter out = new PrintWriter((OutputStream)response.getOutputStream());
        out.println("<html>");
        out.println("<head><title>KML SlideShow Error</title></head>");
        out.println("<body>");
        out.println("<p>" + msg + "</p>");
        out.println("</body></html>");
        out.flush();
    }
}

