/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.model.ui.editor.figures;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.BorderLayout;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.stem.model.ui.editor.vismodel.CompartmentElement;
import org.eclipse.stem.model.ui.editor.vismodel.provider.VisualMetamodelEditPlugin;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;

public class CompartmentFigure
extends Figure {
    private Label labelName = new Label();
    private Label labelCompartmentType = new Label();
    private Label inheritedLabel;
    private RGB blackColor = new RGB(0, 0, 0);
    private CompartmentElement element;
    private static Image lockIcon;

    public CompartmentFigure(CompartmentElement element) {
        this.element = element;
        if (lockIcon == null) {
            lockIcon = ExtendedImageRegistry.INSTANCE.getImage(VisualMetamodelEditPlugin.INSTANCE.getImage("LockIcon12"));
        }
        BorderLayout layout = new BorderLayout();
        layout.setHorizontalSpacing(3);
        layout.setVerticalSpacing(3);
        layout.setObserveVisibility(true);
        this.setLayoutManager((LayoutManager)layout);
        this.labelName.setForegroundColor(ColorConstants.black);
        this.add((IFigure)this.labelName, BorderLayout.CENTER);
        this.labelCompartmentType.setForegroundColor(ColorConstants.black);
        this.add((IFigure)this.labelCompartmentType, BorderLayout.TOP);
        LineBorder border = new LineBorder();
        border.setStyle(1);
        border.setWidth(2);
        this.setBorder((Border)border);
        if (element.isInherited()) {
            border.setStyle(4);
            border.setColor(ColorConstants.darkGray);
            this.labelName.setForegroundColor(ColorConstants.darkGray);
            this.labelCompartmentType.setForegroundColor(ColorConstants.darkGray);
            this.inheritedLabel = new Label();
            this.inheritedLabel.setIcon(lockIcon);
            this.add((IFigure)this.inheritedLabel, BorderLayout.BOTTOM);
        }
        this.setForegroundColor(new Color(null, this.blackColor));
        this.setBackgroundColor(new Color(null, this.getCompartmentColor()));
        this.setOpaque(true);
        this.setName(element.getCompartment().getName());
        this.setCompartmentType(element.getCompartment().getType().getName());
    }

    public void setName(String text) {
        this.labelName.setText(text);
    }

    public void setCompartmentType(String type) {
        this.labelCompartmentType.setText(type);
    }

    public void setLayout(Rectangle rect) {
        this.getParent().setConstraint((IFigure)this, (Object)rect);
    }

    private RGB getCompartmentColor() {
        switch (this.element.getCompartment().getType()) {
            case DEATHS: {
                return new RGB(224, 61, 63);
            }
            case INCIDENCE: {
                return new RGB(51, 204, 102);
            }
            case DERIVED: {
                return new RGB(252, 210, 224);
            }
        }
        return new RGB(153, 153, 255);
    }
}

