/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.graphgenerators.wizards;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.stem.core.STEMURI;
import org.eclipse.stem.core.common.DublinCore;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.core.graph.Graph;
import org.eclipse.stem.graphgenerators.GraphGenerator;
import org.eclipse.stem.ui.graphgenerators.wizards.GraphGeneratorDefinitionControl;
import org.eclipse.stem.ui.graphgenerators.wizards.Messages;
import org.eclipse.stem.ui.wizards.DublinCorePage;
import org.eclipse.stem.ui.wizards.NewIdentifiablePage;
import org.eclipse.stem.ui.wizards.NewIdentifiableWizard;
import org.eclipse.stem.ui.wizards.STEMWizardDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;

public class NewGraphWizard
extends NewIdentifiableWizard {
    private NewGraphPage ngp = null;

    protected String getWizardTitle() {
        return Messages.getString("NGraphWiz.wizard_title");
    }

    protected NewIdentifiablePage createNewIdentifiablePage() {
        this.ngp = new NewGraphPage(Messages.getString("NGraphWiz.page_title"), this);
        this.ngp.setTitle(Messages.getString("NGraphWiz.page_title"));
        this.ngp.setDescription(Messages.getString("NGraphWiz.page_description"));
        this.setHelpContextId("org.eclipse.stem.doc.newgraph_contextid");
        return this.ngp;
    }

    protected DublinCorePage createDublinCorePage() {
        return new DublinCorePage(){

            protected void initializeDCAttributes() {
                super.initializeDCAttributes();
                this.format.setText("http:///org/eclipse/stem/core/graph.ecore");
                this.format.setEnabled(false);
                this.type.setText(STEMURI.GRAPH_TYPE_URI.toString());
                this.type.setEnabled(false);
                Calendar c = Calendar.getInstance();
                SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd");
                String dateStr = dateFormatter.format(c.getTime());
                this.titleTextField.setText(Messages.getString("NGGWiz.DC_TITLE"));
                this.titleTextField.setEnabled(true);
                this.descriptionTextField.setText(Messages.getString("NGGWiz.DC_DESCRIPTION"));
                this.descriptionTextField.setEnabled(true);
                this.source.setText(Messages.getString("NGGWiz.DC_SOURCE"));
                this.source.setEnabled(true);
                this.date.setText(dateStr);
                this.date.setEnabled(true);
                GraphGenerator graphGenerator = NewGraphWizard.this.ngp.getSelectedGraphGenerator();
                DublinCore plugginDublinCore = graphGenerator.getDublinCore();
                this.updateDublinCorePage(plugginDublinCore);
            }
        };
    }

    protected Identifiable createIdentifiable() {
        Graph retValue = this.ngp.getGraph();
        retValue.setDublinCore(this.newDublinCorePage.createDublinCore());
        return retValue;
    }

    protected String getSerializationFolderName() {
        return "graphs";
    }

    protected String getSerializationFileNameExtension() {
        return "graph";
    }

    protected static class NewGraphPage
    extends NewIdentifiablePage {
        GraphGeneratorDefinitionControl ggdc = null;
        NewGraphWizard parentWizard = null;

        protected NewGraphPage(String pageName, NewGraphWizard ngw) {
            super(pageName);
            this.parentWizard = ngw;
        }

        GraphGenerator getSelectedGraphGenerator() {
            return this.ggdc.getSelectedGraphGenerator();
        }

        protected Composite createSpecificComposite(Composite parent) {
            this.ggdc = new GraphGeneratorDefinitionControl(parent, 0, this.projectValidator, this.getSelectedProject(), this.parentWizard);
            return this.ggdc;
        }

        protected boolean validatePage() {
            boolean retValue = super.validatePage();
            if (retValue) {
                this.setErrorMessage(null);
                retValue = this.ggdc.validate();
                if (!retValue) {
                    this.setErrorMessage(this.ggdc.getErrorMessage());
                }
            }
            return retValue;
        }

        Graph getGraph() {
            return this.ggdc.getGraph(this.parentWizard.getSerializationFileName());
        }
    }

    public static class NewGraphWizardCommandHandler
    extends AbstractHandler
    implements IHandler {
        public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
            IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)executionEvent);
            NewGraphWizard wizard = new NewGraphWizard();
            wizard.init(window.getWorkbench(), (IStructuredSelection)StructuredSelection.EMPTY);
            STEMWizardDialog wizardDialog = new STEMWizardDialog(window.getShell(), (IWizard)wizard);
            wizardDialog.open();
            return null;
        }
    }
}

