/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.diseasemodels.standard.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.stem.core.graph.IntegrationLabelValue;
import org.eclipse.stem.core.graph.LabelValue;
import org.eclipse.stem.diseasemodels.standard.SILabelValue;
import org.eclipse.stem.diseasemodels.standard.StandardFactory;
import org.eclipse.stem.diseasemodels.standard.StandardPackage;
import org.eclipse.stem.diseasemodels.standard.impl.StandardDiseaseModelLabelValueImpl;

public class SILabelValueImpl
extends StandardDiseaseModelLabelValueImpl
implements SILabelValue {
    protected static final double I_EDEFAULT = 0.0;
    protected double i = 0.0;

    public SILabelValueImpl() {
    }

    public SILabelValueImpl(double s, double i, double incidence, double diseaseDeaths) {
        super(s, incidence, diseaseDeaths);
        this.setI(i);
    }

    public SILabelValueImpl(double s, double i, double diseaseDeaths) {
        super(s, 0.0, diseaseDeaths);
        this.setI(i);
        this.setDiseaseDeaths(diseaseDeaths);
    }

    @Override
    protected EClass eStaticClass() {
        return StandardPackage.Literals.SI_LABEL_VALUE;
    }

    @Override
    public double getI() {
        return this.i;
    }

    @Override
    public void setI(double newI) {
        this.i = newI;
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 6: {
                return this.getI();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 6: {
                this.setI((Double)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 6: {
                this.setI(0.0);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 6: {
                return this.i != 0.0;
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (i: ");
        result.append(this.i);
        result.append(')');
        return result.toString();
    }

    @Override
    public IntegrationLabelValue set(IntegrationLabelValue value) {
        SILabelValue v = (SILabelValue)value;
        super.set(value);
        this.setI(v.getI());
        return this;
    }

    @Override
    public IntegrationLabelValue add(IntegrationLabelValue value) {
        SILabelValue v = (SILabelValue)value;
        super.add(value);
        this.setI(this.getI() + v.getI());
        return this;
    }

    @Override
    public IntegrationLabelValue sub(IntegrationLabelValue value) {
        SILabelValue v = (SILabelValue)value;
        super.sub(value);
        this.setI(this.getI() - v.getI());
        return this;
    }

    @Override
    public IntegrationLabelValue scale(double scaleFactor) {
        super.scale(scaleFactor);
        this.setI(scaleFactor * this.getI());
        return this;
    }

    @Override
    public IntegrationLabelValue add(double addition) {
        super.add(addition);
        this.setI(this.getI() + addition);
        return this;
    }

    @Override
    public IntegrationLabelValue abs() {
        super.abs();
        this.setI(Math.abs(this.getI()));
        return this;
    }

    @Override
    public boolean avoidNegative(IntegrationLabelValue value) {
        SILabelValue v = (SILabelValue)value;
        boolean adjusted = super.avoidNegative(value);
        if (this.getI() + v.getI() < 0.0) {
            this.setI(-v.getI());
        }
        return adjusted;
    }

    @Override
    public double computeDeltaAdjustment(IntegrationLabelValue value) {
        SILabelValue v = (SILabelValue)value;
        double factor = super.computeDeltaAdjustment(value);
        if (this.getI() + v.getI() < 0.0) {
            factor = Math.min(factor, -v.getI() / this.getI());
        }
        return factor;
    }

    @Override
    public IntegrationLabelValue divide(IntegrationLabelValue value) {
        SILabelValue v = (SILabelValue)value;
        super.divide(value);
        this.setI(this.getI() / v.getI());
        return this;
    }

    @Override
    public double max() {
        double max = super.max();
        max = Math.max(max, this.getI());
        return max;
    }

    @Override
    public void reset() {
        super.reset();
        this.setI(0.0);
    }

    @Override
    public boolean sameValue(LabelValue otherLabelValue) {
        SILabelValue v = (SILabelValue)otherLabelValue;
        if (!super.sameValue(otherLabelValue)) {
            return false;
        }
        return this.getI() == v.getI();
    }

    @Override
    public double getPopulationCount() {
        return super.getPopulationCount() + this.getI();
    }

    public IntegrationLabelValue copy() {
        SILabelValue ilv = StandardFactory.eINSTANCE.createSILabelValue();
        ilv.set(this);
        return ilv;
    }

    @Override
    public void eSetDouble(int featureId, double newValue) {
        switch (featureId) {
            case 6: {
                this.setI(newValue);
                return;
            }
        }
        super.eSetDouble(featureId, newValue);
    }

    @Override
    public double eGetDouble(int featureId) {
        switch (featureId) {
            case 6: {
                return this.getI();
            }
        }
        return super.eGetDouble(featureId);
    }
}

