/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.model.ui.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.stem.model.common.ModelProjectNature;
import org.eclipse.stem.model.ui.MetamodelEditorPlugin;
import org.eclipse.ui.handlers.HandlerUtil;

public class ToggleNatureHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage().getSelection();
        if (selection instanceof IStructuredSelection) {
            for (Object element : (IStructuredSelection)selection) {
                IProject project = null;
                if (element instanceof IProject) {
                    project = (IProject)element;
                } else if (element instanceof IAdaptable) {
                    project = (IProject)((IAdaptable)element).getAdapter(IProject.class);
                }
                if (project == null) continue;
                ToggleNatureHandler.toggleNature(project);
            }
        }
        return null;
    }

    public static void toggleNature(IProject project) {
        try {
            if (ModelProjectNature.hasNature((IProject)project)) {
                ModelProjectNature.removeNature((IProject)project);
            } else {
                ModelProjectNature.addNature((IProject)project);
            }
        }
        catch (CoreException ce) {
            MetamodelEditorPlugin.log((IStatus)new Status(4, "org.eclipse.stem.model.ui", "Error toggling nature", (Throwable)ce));
        }
    }
}

