/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.model.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.stem.model.metamodel.Package;
import org.eclipse.stem.model.transform.ModelGenerator;
import org.eclipse.stem.model.ui.MetamodelEditorPlugin;
import org.eclipse.stem.model.ui.wizards.GeneratorOptionsPage;
import org.eclipse.stem.model.ui.wizards.PackagePropertiesPage;
import org.eclipse.stem.model.ui.wizards.WizardHelper;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class ModelGeneratorWizard
extends Wizard
implements INewWizard {
    protected IStatus status;
    protected PackagePropertiesPage packagePage;
    protected GeneratorOptionsPage advancedOptionsPage;
    protected Package modelPackage;
    protected URI metamodelURI;
    protected IWorkbench workbench;

    public ModelGeneratorWizard(Package pkg) {
        this.setNeedsProgressMonitor(true);
        this.modelPackage = pkg;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
    }

    public void setPackage(Package pkg) {
        this.modelPackage = pkg;
        if (this.packagePage != null) {
            this.packagePage.setPackage(this.modelPackage);
        }
        if (this.advancedOptionsPage != null) {
            this.advancedOptionsPage.setPackage(this.modelPackage);
        }
    }

    public void addPages() {
        this.packagePage = new PackagePropertiesPage(this.modelPackage);
        this.advancedOptionsPage = new GeneratorOptionsPage(this.modelPackage);
        this.addPage((IWizardPage)this.packagePage);
        this.addPage((IWizardPage)this.advancedOptionsPage);
    }

    public boolean performFinish() {
        boolean done;
        block9: {
            this.packagePage.applyChanges();
            done = true;
            try {
                try {
                    this.getContainer().run(true, true, (IRunnableWithProgress)new WorkspaceModifyOperation(){

                        protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                            ModelGeneratorWizard.this.status = Status.OK_STATUS;
                            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Generating Models ", (int)100);
                            try {
                                ModelGenerator generator = new ModelGenerator(ModelGeneratorWizard.this.modelPackage);
                                generator.transform((IProgressMonitor)subMonitor.split(10));
                                generator.generate((IProgressMonitor)subMonitor.split(90));
                                ModelGeneratorWizard.this.metamodelURI = generator.getMetaModel().eResource().getURI();
                            }
                            catch (Throwable e) {
                                ModelGeneratorWizard.this.status = new Status(4, "org.eclipse.stem.model.ui", e.getMessage(), e);
                                MetamodelEditorPlugin.log(ModelGeneratorWizard.this.status);
                                throw new CoreException(ModelGeneratorWizard.this.status);
                            }
                        }
                    });
                }
                catch (Exception exception) {
                    if (this.status != null && this.status != Status.OK_STATUS) {
                        done = false;
                        ErrorDialog.openError((Shell)this.getShell(), (String)"Error generating models", null, (IStatus)this.status);
                    }
                    break block9;
                }
            }
            catch (Throwable throwable) {
                if (this.status != null && this.status != Status.OK_STATUS) {
                    done = false;
                    ErrorDialog.openError((Shell)this.getShell(), (String)"Error generating models", null, (IStatus)this.status);
                }
                throw throwable;
            }
            if (this.status != null && this.status != Status.OK_STATUS) {
                done = false;
                ErrorDialog.openError((Shell)this.getShell(), (String)"Error generating models", null, (IStatus)this.status);
            }
        }
        if (done && this.metamodelURI != null) {
            WizardHelper.openEditor(PlatformUI.getWorkbench(), this.metamodelURI);
        }
        return done;
    }
}

