/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.analysis.automaticexperiment;

import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.stem.analysis.automaticexperiment.ALGORITHM_STATUS;
import org.eclipse.stem.analysis.automaticexperiment.AutomaticExperiment;
import org.eclipse.stem.analysis.automaticexperiment.AutomaticExperimentManagerEvent;
import org.eclipse.stem.analysis.automaticexperiment.AutomaticExperimentManagerListener;
import org.eclipse.stem.analysis.automaticexperiment.ErrorAnalysisAlgorithm;
import org.eclipse.stem.analysis.automaticexperiment.ErrorAnalysisAlgorithmEvent;
import org.eclipse.stem.analysis.automaticexperiment.ErrorAnalysisAlgorithmFactory;
import org.eclipse.stem.analysis.automaticexperiment.ErrorAnalysisAlgorithmListener;
import org.eclipse.stem.analysis.automaticexperiment.MANAGER_STATUS;
import org.eclipse.stem.analysis.automaticexperiment.OptimizerAlgorithm;
import org.eclipse.stem.core.common.util.LogInitializationException;

public class AutomaticExperimentManager {
    private static final AutomaticExperimentManager instance = new AutomaticExperimentManager();
    protected static boolean QUIT_NOW = false;
    protected static boolean PAUSE_NOW = false;
    protected static ErrorAnalysisAlgorithm currentRunningAlgorithm = null;
    protected static AutomaticExperiment currentRunningExperient;
    private ArrayList<AutomaticExperimentManagerListener> listeners = new ArrayList();

    public void quitNow() {
        QUIT_NOW = true;
    }

    public static void pause() {
        PAUSE_NOW = true;
    }

    public static void continueRun() {
        PAUSE_NOW = false;
    }

    public void restartNow(double[] restartParamValues) {
        QUIT_NOW = false;
        currentRunningAlgorithm.reinitStartParams(currentRunningExperient, restartParamValues);
        currentRunningAlgorithm.clearListeners();
        Job j = new Job("Minimizer algorith"){

            protected IStatus run(IProgressMonitor monitor) {
                currentRunningAlgorithm.execute();
                return Status.OK_STATUS;
            }
        };
        AutomaticExperimentManagerEvent newEvent = new AutomaticExperimentManagerEvent(currentRunningExperient, currentRunningAlgorithm, MANAGER_STATUS.SCHEDULED);
        this.fireEvent(newEvent);
        j.schedule();
    }

    private AutomaticExperimentManager() {
    }

    public static AutomaticExperimentManager getInstance() {
        return instance;
    }

    public ErrorAnalysisAlgorithm createAlgorithm(OptimizerAlgorithm alg) {
        QUIT_NOW = false;
        PAUSE_NOW = false;
        ErrorAnalysisAlgorithm result = ErrorAnalysisAlgorithmFactory.INSTANCE.createErrorAnalysisAlgorithm(alg);
        return result;
    }

    public void executeAlgorithm(final ErrorAnalysisAlgorithm algorithm, AutomaticExperiment automaticExperiment) throws LogInitializationException {
        QUIT_NOW = false;
        PAUSE_NOW = false;
        currentRunningAlgorithm = algorithm;
        currentRunningExperient = automaticExperiment;
        algorithm.init(automaticExperiment, algorithm);
        Job j = new Job("Minimizer algorith"){

            protected IStatus run(IProgressMonitor monitor) {
                algorithm.execute();
                return Status.OK_STATUS;
            }
        };
        AutomaticExperimentManagerEvent newEvent = new AutomaticExperimentManagerEvent(automaticExperiment, algorithm, MANAGER_STATUS.SCHEDULED);
        this.fireEvent(newEvent);
        j.schedule();
    }

    private void fireEvent(AutomaticExperimentManagerEvent evt) {
        for (AutomaticExperimentManagerListener l : this.listeners) {
            l.eventReceived(evt);
        }
    }

    public void addListener(AutomaticExperimentManagerListener l) {
        this.listeners.add(l);
    }

    public void clearListeners() {
        this.listeners.clear();
    }

    public static void main() {
        QUIT_NOW = false;
        PAUSE_NOW = false;
        AutomaticExperimentManager manager = AutomaticExperimentManager.getInstance();
        manager.addListener(new AutomaticExperimentManagerListener(){

            @Override
            public void eventReceived(AutomaticExperimentManagerEvent evt) {
                if (evt.status == MANAGER_STATUS.SCHEDULED) {
                    ErrorAnalysisAlgorithm alg = evt.algorithm;
                    alg.addListener(new ErrorAnalysisAlgorithmListener(){

                        @Override
                        public void eventReceived(ErrorAnalysisAlgorithmEvent evt) {
                            if (evt.status != ALGORITHM_STATUS.FINISHED_ALGORITHM && evt.status != ALGORITHM_STATUS.FINISHED_SIMULATION) {
                                ALGORITHM_STATUS cfr_ignored_0 = evt.status;
                            }
                        }
                    });
                }
            }
        });
    }
}

