/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.stem.ui.adapters.color.ColorProviderAdapterFactory;
import org.eclipse.stem.ui.adapters.featuremodifiereditcomposite.ExperimentFeatureModifierEditCompositeFactory;
import org.eclipse.stem.ui.adapters.newmodifierpage.CommonNewModifierPageAdapterFactory;
import org.eclipse.stem.ui.adapters.newmodifierpage.EdgesNewModifierPageAdapterFactory;
import org.eclipse.stem.ui.adapters.newmodifierpage.FeatureModifierNewModifierPageAdapterFactory;
import org.eclipse.stem.ui.adapters.newmodifierpage.GraphNewModifierPageAdapterFactory;
import org.eclipse.stem.ui.adapters.newmodifierpage.LabelsNewModifierPageAdapterFactory;
import org.eclipse.stem.ui.adapters.newmodifierpage.SequencerNewModifierPageAdapterFactory;
import org.eclipse.stem.ui.adapters.propertystrings.DecoratorsPropertyStringProviderAdapterFactory;
import org.eclipse.stem.ui.adapters.propertystrings.FeatureModifierPropertyStringProviderAdapterFactory;
import org.eclipse.stem.ui.adapters.propertystrings.LabelsPropertyStringProviderAdapterFactory;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.stem.ui";
    private static Activator plugin;
    private static ColorRegistry colorRegistry;
    private static FontRegistry fontRegistry;

    static {
        colorRegistry = null;
        fontRegistry = null;
    }

    public Activator() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        IConfigurationElement[] elements;
        super.start(context);
        new SequencerNewModifierPageAdapterFactory();
        new GraphNewModifierPageAdapterFactory();
        new EdgesNewModifierPageAdapterFactory();
        new LabelsNewModifierPageAdapterFactory();
        new ExperimentFeatureModifierEditCompositeFactory();
        new LabelsPropertyStringProviderAdapterFactory();
        new DecoratorsPropertyStringProviderAdapterFactory();
        new CommonNewModifierPageAdapterFactory();
        new FeatureModifierNewModifierPageAdapterFactory();
        new FeatureModifierPropertyStringProviderAdapterFactory();
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.stem.ui.colorproviders");
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (!element.isValid()) {
                Activator.logError("Invalid color provider extension", null);
            } else {
                Bundle bundle = Platform.getBundle((String)element.getContributor().getName());
                String name = element.getAttribute("name");
                String factory = element.getAttribute("factory");
                String provider = element.getAttribute("provider");
                Class factoryClass = bundle.loadClass(factory);
                Object factoryInstance = factoryClass.newInstance();
                Class providerClass = bundle.loadClass(provider);
                ColorProviderAdapterFactory.INSTANCE.addAdapterFactory((AdapterFactory)factoryInstance, providerClass, name);
            }
            ++n2;
        }
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
    }

    public static Activator getDefault() {
        return plugin;
    }

    public ColorRegistry getColorRegistry() {
        if (colorRegistry == null) {
            colorRegistry = new ColorRegistry();
            this.initializeColorRegistry(colorRegistry);
        }
        return colorRegistry;
    }

    public FontRegistry getFontRegistry() {
        if (fontRegistry == null) {
            fontRegistry = new FontRegistry();
            this.initializeFontRegistry(fontRegistry);
        }
        return fontRegistry;
    }

    protected void initializeImageRegistry(ImageRegistry registry) {
        String ICON_ACTION_PATH_PREFIX = "icons/full/actions16/";
        String CUSTOM_ICON_PATH_PREFIX2 = "icons/full/customobj16/";
        registry.put("automaticexperiment.image", Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/full/customobj16/AutomaticExperiment.gif"));
        registry.put("decorator.image", Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/full/customobj16/Decorator.gif"));
        registry.put("decorator_model_file.image", Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/full/customobj16/DecoratorModelFile.gif"));
        registry.put("solvers_model_file.image", Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/full/customobj16/SolversModelFile.png"));
        registry.put("dynamic_label.image", Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/full/customobj16/DynamicLabel.gif"));
        registry.put("edge.image", Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/full/customobj16/Edge.gif"));
        registry.put("experiment.image", Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/full/customobj16/Experiment.gif"));
        registry.put("experiment_model_file.image", Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/full/customobj16/ExperimentModelFile.gif"));
        registry.put("graph.image", Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/full/customobj16/Graph.gif"));
        registry.put("graph_model_file.image", Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/full/customobj16/GraphModelFile.gif"));
        registry.put("model.image", Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/full/customobj16/Model.gif"));
        registry.put("model_model_file.image", Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/full/customobj16/ModelModelFile.gif"));
        registry.put("modifier.image", Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/full/customobj16/Modifier.gif"));
        registry.put("modifier_model_file.image", Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/full/customobj16/ModifierModelFile.gif"));
        registry.put("node.image", Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/full/customobj16/Node.gif"));
        registry.put("predicate.image", Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/full/customobj16/Predicate.gif"));
        registry.put("predicate_model_file.image", Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/full/customobj16/PredicateModelFile.gif"));
        registry.put("recorded_simulation.image", Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/full/customobj16/RecordedSimulations.gif"));
        registry.put("recorded_simulation_model_file.image", Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/full/customobj16/RecordedSimulationsModelFile.gif"));
        registry.put("scenario.image", Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/full/customobj16/Scenario.gif"));
        registry.put("scenario_model_file.image", Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/full/customobj16/ScenarioModelFile.gif"));
        registry.put("sequencer.image", Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/full/customobj16/Sequencer.gif"));
        registry.put("sequencer_model_file.image", Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/full/customobj16/SequencerModelFile.gif"));
        registry.put("static_label.image", Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/full/customobj16/StaticLabel.gif"));
        registry.put("trigger.image", Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/full/customobj16/Trigger.gif"));
        registry.put("trigger_model_file.image", Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/full/customobj16/TriggerModelFile.gif"));
        registry.put("stem_project.image", Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/full/customobj16/stem.gif"));
        registry.put("stem_project.image", Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/full/customobj16/StemProject.gif"));
        registry.put("stem_explorer.image", Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/full/customobj16/stemExplorer.gif"));
        registry.put("simulation_control_view.image", Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/full/customobj16/simulationControlView.gif"));
        registry.put("simulation_control.image", Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/full/customobj16/simulationControl.gif"));
        registry.put("delete.image", Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/full/customobj16/delete.gif"));
        registry.put("generic_file.image", Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/full/customobj16/genericFile.gif"));
        registry.put("scenario_File.image", Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/full/customobj16/ScenarioModelFile.gif"));
        registry.put("scenario_file.image", Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/full/customobj16/ScenarioModelFile.gif"));
        registry.put("run.image", Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/full/actions16/run.gif"));
        registry.put("pause.image", Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/full/actions16/pause.gif"));
        registry.put("reset.image", Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/full/actions16/reset.gif"));
        registry.put("restart.image", Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/full/actions16/restart.gif"));
        registry.put("step.image", Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/full/actions16/step.gif"));
        registry.put("stop.image", Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/full/actions16/stop.gif"));
        registry.put("disabled_run.image", Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/full/actions16/disabledRun.gif"));
        registry.put("disabled_pause.image", Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/full/actions16/disabledPause.gif"));
        registry.put("disabled_reset.image", Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/full/actions16/disabledReset.gif"));
        registry.put("disabled_step.image", Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/full/actions16/disabledStep.gif"));
        registry.put("disabled_stop.image", Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/full/actions16/disabledStop.gif"));
        registry.put("map.image", Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/full/customobj16/map.gif"));
        registry.put("logger.image", Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/full/customobj16/Logger.gif"));
        registry.put("logger_model_file.image", Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/full/customobj16/LoggerModelFile.gif"));
    }

    protected void initializeColorRegistry(ColorRegistry colorRegistry) {
        colorRegistry.put("green", new RGB(55, 255, 50));
        colorRegistry.put("yellow", new RGB(255, 255, 0));
        colorRegistry.put("orange", new RGB(255, 170, 30));
        colorRegistry.put("gray", new RGB(217, 217, 217));
    }

    protected void initializeFontRegistry(FontRegistry fontRegistry) {
        int fontHeight = JFaceResources.getDefaultFont().getFontData()[0].getHeight();
        FontData fontData = new FontData("Courier New", fontHeight, 0);
        fontRegistry.put("default", new FontData[]{fontData});
    }

    public static void logWarning(String message, Throwable exception) {
        plugin.getLog().log((IStatus)new Status(2, plugin.getBundle().getSymbolicName(), 0, message, exception));
    }

    public static void logError(String message, Throwable exception) {
        plugin.getLog().log((IStatus)new Status(4, plugin.getBundle().getSymbolicName(), 0, message, exception));
    }

    public static void logInformation(String message, Throwable exception) {
        plugin.getLog().log((IStatus)new Status(1, plugin.getBundle().getSymbolicName(), 0, message, exception));
    }

    public static void logInformation(String message) {
        if (plugin != null) {
            plugin.getLog().log((IStatus)new Status(1, plugin.getBundle().getSymbolicName(), 0, message, null));
        } else {
            System.out.println(message);
        }
    }

    public static void switchToPerspective(String perspectiveId) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        try {
            workbench.showPerspective(perspectiveId, workbench.getActiveWorkbenchWindow());
        }
        catch (WorkbenchException e) {
            Activator.logError("Problem switching to Perspective with ID=\"" + perspectiveId + "\"", e);
        }
    }
}

