/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.launcher;

import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.stem.ui.launcher.CommandArgumentParser;
import org.eclipse.stem.ui.launcher.Launcher;
import org.eclipse.stem.ui.launcher.WorkbenchLauncher;

public class LauncherFactory {
    public static final String LAUNCHERS_EXTENSION_POINT_ID = "org.eclipse.stem.ui.launchers";

    public static Launcher getLauncher(IApplicationContext context) {
        String[] args = (String[])context.getArguments().get("application.args");
        Map<String, List<String>> commandArgs = CommandArgumentParser.parse(args);
        Launcher launcher = LauncherFactory.getLauncherFromExtensions(commandArgs);
        if (launcher == null) {
            launcher = new WorkbenchLauncher();
        }
        launcher.setContext(context);
        launcher.setCommandArguments(commandArgs);
        return launcher;
    }

    private static Launcher getLauncherFromExtensions(Map<String, List<String>> commandArgs) {
        IConfigurationElement[] extensions;
        String launcherName = null;
        if (commandArgs.containsKey("launcher") && commandArgs.get("launcher").size() > 0) {
            launcherName = commandArgs.get("launcher").get(0);
        }
        Launcher launcher = null;
        IConfigurationElement[] iConfigurationElementArray = extensions = Platform.getExtensionRegistry().getConfigurationElementsFor(LAUNCHERS_EXTENSION_POINT_ID);
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            try {
                String name = e.getAttribute("name");
                if (name != null && (name.equals(launcherName) || commandArgs.containsKey(name))) {
                    launcher = (Launcher)e.createExecutableExtension("class");
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n2;
        }
        return launcher;
    }
}

