/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.widgets;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.stem.core.Utility;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.ui.Activator;
import org.eclipse.stem.ui.wizards.Messages;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class ShowReferencesDialog
extends Dialog {
    private String title;
    XMIResource resource;
    Identifiable identifiable;

    public ShowReferencesDialog(Shell parent, int style, Identifiable ident, XMIResource resource, String title) {
        super(parent, style);
        this.title = title;
        this.resource = resource;
        this.identifiable = ident;
    }

    public String open() {
        Shell parent = this.getParent();
        final Shell shell = new Shell(parent, 67680);
        shell.setText(this.title);
        GridLayout gl = new GridLayout();
        gl.numColumns = 1;
        shell.setLayout((Layout)gl);
        GridData lgd = new GridData();
        lgd.horizontalSpan = 1;
        Label refLabel = new Label((Composite)shell, 0);
        refLabel.setText(Messages.getString("show.references.refs.found"));
        refLabel.setLayoutData((Object)lgd);
        Table refTable = new Table((Composite)shell, 0);
        GridData tGD = new GridData();
        tGD.horizontalSpan = 1;
        refTable.setLayoutData((Object)tGD);
        List refs = null;
        try {
            refs = Utility.findReferences((Identifiable)this.identifiable);
        }
        catch (CoreException ce) {
            Activator.logError(ce.getMessage(), ce);
        }
        if (refs != null && refs.size() > 0) {
            for (URI u : refs) {
                TableItem ti = new TableItem(refTable, 0);
                ti.setText(u.toString());
            }
        } else {
            refTable.dispose();
        }
        Button okayButton = new Button((Composite)shell, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = 1;
        okayButton.setText(Messages.getString("show.references.dialog.okay"));
        okayButton.setLayoutData((Object)gd);
        okayButton.setEnabled(true);
        okayButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                shell.dispose();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        shell.pack();
        shell.open();
        Display display = parent.getDisplay();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return null;
    }
}

