/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.model.builder;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.stem.model.codegen.GeneratorUtils;
import org.eclipse.stem.model.ctdl.ContextSensitiveResourceWrapper;
import org.eclipse.stem.model.metamodel.Compartment;
import org.eclipse.stem.model.metamodel.Package;
import org.eclipse.stem.model.metamodel.Transition;
import org.eclipse.xtext.resource.XtextResource;

public final class BuilderUtils {
    private static final String METAMODEL_FILE_EXTENSION = ".metamodel";

    private BuilderUtils() {
    }

    public static boolean isNullOrEmpty(String s) {
        return s == null || s.length() == 0;
    }

    public static void safeUnload(EObject obj) {
        if (obj == null) {
            return;
        }
        BuilderUtils.safeUnload(obj.eResource());
    }

    public static void safeUnload(Resource resource) {
        if (resource == null) {
            return;
        }
        resource.unload();
    }

    private static String getTransitionName(Transition transition) {
        Compartment target;
        if (transition == null) {
            return "";
        }
        String sourceName = "?";
        String targetName = "?";
        Compartment source = transition.getSource();
        if (source != null && !BuilderUtils.isNullOrEmpty(source.getName())) {
            sourceName = source.getName();
        }
        if ((target = transition.getTarget()) != null && !BuilderUtils.isNullOrEmpty(target.getName())) {
            targetName = target.getName();
        }
        return String.valueOf(sourceName) + " -> " + targetName;
    }

    public static void createGenericResourceMarker(IResource workspaceResource, String message, int severity) throws CoreException {
        IMarker marker = workspaceResource.createMarker("org.eclipse.core.resources.problemmarker");
        if (marker.exists()) {
            marker.setAttribute("severity", severity);
            marker.setAttribute("message", (Object)message);
        }
    }

    public static void createNeedsRegenerationMarker(IResource workspaceResource, String message, int severity) throws CoreException {
        IMarker marker = workspaceResource.createMarker("org.eclipse.stem.model.builder.ModelNeedsRegenerationErrorMarker");
        if (marker.exists()) {
            marker.setAttribute("severity", severity);
            marker.setAttribute("message", (Object)message);
        }
    }

    public static void createEmfResourceMarker(IResource workspaceResource, Resource emfResource, Resource.Diagnostic diagnostic, int severity) throws CoreException {
        BuilderUtils.createGenericResourceMarker(workspaceResource, diagnostic.getMessage(), severity);
    }

    public static void createXtextResourceMarker(IResource workspaceResource, XtextResource xtextResource, Resource.Diagnostic diagnostic, int severity) throws CoreException {
        String type = "org.eclipse.stem.model.builder.ExpressionCompileErrorMarker";
        String message = diagnostic.getMessage();
        String location = diagnostic.getLocation();
        IMarker marker = workspaceResource.createMarker(type);
        if (marker.exists()) {
            marker.setAttribute("severity", severity);
            marker.setAttribute("message", (Object)message);
            marker.setAttribute("location", (Object)location);
            if (xtextResource instanceof ContextSensitiveResourceWrapper) {
                Transition transition = ((ContextSensitiveResourceWrapper)xtextResource).getTransition();
                String transitionName = BuilderUtils.getTransitionName(transition);
                String modelName = transition.getContainerModel().getName();
                location = String.valueOf(modelName) + " / " + transitionName;
                marker.setAttribute("location", (Object)location);
                marker.setAttribute("model", (Object)modelName);
                marker.setAttribute("sourceCompartment", (Object)transition.getSource().getName());
                marker.setAttribute("targetCompartment", (Object)transition.getTarget().getName());
            }
        }
    }

    public static List<IFile> findMetamodelsInProject(IProject project, IProgressMonitor monitor) {
        return BuilderUtils.findMetamodelsInContainer((IResource)project, monitor);
    }

    private static URI getUriForPath(IPath path) {
        return URI.createPlatformResourceURI((String)path.toString(), (boolean)true);
    }

    public static Package loadMetamodel(IFile file) throws IOException {
        return GeneratorUtils.loadMetamodel((URI)BuilderUtils.getUriForPath(file.getFullPath()));
    }

    public static GenModel loadGenmodelForMetamodel(IFile metamodelFile) throws IOException {
        return GeneratorUtils.loadGenModel((URI)BuilderUtils.getUriForPath(BuilderUtils.getGenModelFileForMetamodel(metamodelFile)));
    }

    private static IPath getGenModelFileForMetamodel(IFile metamodelFile) {
        IPath ext = metamodelFile.getFullPath().removeFileExtension().addFileExtension("genmodel");
        return ext;
    }

    private static List<IFile> findMetamodelsInContainer(IResource container, IProgressMonitor monitor) {
        return BuilderUtils.findFilesInContainer(METAMODEL_FILE_EXTENSION, container, monitor);
    }

    private static List<IFile> findFilesInContainer(final String extension, IResource container, final IProgressMonitor monitor) {
        final ArrayList<IFile> files = new ArrayList<IFile>();
        try {
            container.accept(new IResourceProxyVisitor(){

                public boolean visit(IResourceProxy proxy) throws CoreException {
                    IResource file;
                    if (monitor.isCanceled() || proxy.getName().startsWith(".")) {
                        return false;
                    }
                    if (proxy.getName().endsWith(extension) && (file = proxy.requestResource()) instanceof IFile) {
                        files.add((IFile)file);
                    }
                    return true;
                }
            }, 0);
        }
        catch (CoreException coreException) {}
        return files;
    }
}

