/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.loggers.imagewriter.impl;

import java.io.File;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.stem.jobs.simulation.ISimulation;
import org.eclipse.stem.loggers.common.Constants;
import org.eclipse.stem.loggers.common.FileUtils;
import org.eclipse.stem.loggers.imagewriter.ImageWriterLogger;
import org.eclipse.stem.loggers.imagewriter.ImagewriterPackage;
import org.eclipse.stem.loggers.impl.SimulationLoggerImpl;

public abstract class ImageWriterLoggerImpl
extends SimulationLoggerImpl
implements ImageWriterLogger {
    protected static final boolean USE_DEFAULT_LOG_DIRECTORY_EDEFAULT = true;
    protected boolean useDefaultLogDirectory = true;
    protected static final String DATA_PATH_EDEFAULT = null;
    protected String dataPath = DATA_PATH_EDEFAULT;

    protected EClass eStaticClass() {
        return ImagewriterPackage.Literals.IMAGE_WRITER_LOGGER;
    }

    @Override
    public boolean isUseDefaultLogDirectory() {
        return this.useDefaultLogDirectory;
    }

    @Override
    public void setUseDefaultLogDirectory(boolean newUseDefaultLogDirectory) {
        boolean oldUseDefaultLogDirectory = this.useDefaultLogDirectory;
        this.useDefaultLogDirectory = newUseDefaultLogDirectory;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, oldUseDefaultLogDirectory, this.useDefaultLogDirectory));
        }
    }

    @Override
    public String getDataPath() {
        return this.dataPath;
    }

    @Override
    public void setDataPath(String newDataPath) {
        String oldDataPath = this.dataPath;
        this.dataPath = newDataPath;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 7, (Object)oldDataPath, (Object)this.dataPath));
        }
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 6: {
                return this.isUseDefaultLogDirectory();
            }
            case 7: {
                return this.getDataPath();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 6: {
                this.setUseDefaultLogDirectory((Boolean)newValue);
                return;
            }
            case 7: {
                this.setDataPath((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 6: {
                this.setUseDefaultLogDirectory(true);
                return;
            }
            case 7: {
                this.setDataPath(DATA_PATH_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 6: {
                return !this.useDefaultLogDirectory;
            }
            case 7: {
                return DATA_PATH_EDEFAULT == null ? this.dataPath != null : !DATA_PATH_EDEFAULT.equals(this.dataPath);
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (useDefaultLogDirectory: ");
        result.append(this.useDefaultLogDirectory);
        result.append(", dataPath: ");
        result.append(this.dataPath);
        result.append(')');
        return result.toString();
    }

    protected File getLogFileDirectory(ISimulation simulation) {
        StringBuilder directory = new StringBuilder();
        if (this.isUseDefaultLogDirectory() || "".equals(this.getDataPath())) {
            directory.append(FileUtils.getRootLoggingFolderForScenario((String)simulation.getScenario().getURI().toString()));
        } else {
            directory.append(this.getDataPath());
        }
        directory.append(Constants.SYSTEM_PATH_SEPARATOR);
        directory.append(simulation.getUniqueIDString());
        directory.append(Constants.SYSTEM_PATH_SEPARATOR);
        return new File(directory.toString());
    }
}

