/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.solvers.stochastic.presentation;

import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.stem.core.STEMURI;
import org.eclipse.stem.core.solver.Solver;
import org.eclipse.stem.core.solver.SolverPropertyEditor;
import org.eclipse.stem.solvers.stochastic.StandardStochastic;
import org.eclipse.stem.solvers.stochastic.StochasticFactory;
import org.eclipse.stem.solvers.stochastic.StochasticPackage;
import org.eclipse.stem.solvers.stochastic.presentation.SolverMessages;
import org.eclipse.stem.ui.adapters.propertystrings.PropertyStringProvider;
import org.eclipse.stem.ui.adapters.propertystrings.PropertyStringProviderAdapter;
import org.eclipse.stem.ui.adapters.propertystrings.PropertyStringProviderAdapterFactory;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class StochasticSolverPropertyEditor
extends SolverPropertyEditor {
    public StochasticSolverPropertyEditor(Composite parent, int style, Solver solver, ModifyListener projectValidator) {
        super(parent, style);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        this.setLayout((Layout)gridLayout);
        PropertyStringProviderAdapter pspa = (PropertyStringProviderAdapter)PropertyStringProviderAdapterFactory.INSTANCE.adapt((Notifier)solver, PropertyStringProvider.class);
        ComposedAdapterFactory itemProviderFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        IItemPropertySource propertySource = (IItemPropertySource)itemProviderFactory.adapt((Notifier)solver, IItemPropertySource.class);
        List properties = propertySource.getPropertyDescriptors((Object)solver);
        for (IItemPropertyDescriptor descriptor : properties) {
            EStructuralFeature feature = (EStructuralFeature)descriptor.getFeature(null);
            if (!StochasticSolverPropertyEditor.isUserSpecifiedSolverProperty(feature)) continue;
            Label label = new Label((Composite)this, 0);
            label.setText(pspa.getPropertyName(descriptor));
            GridData labelGD = new GridData(1);
            labelGD.grabExcessHorizontalSpace = true;
            labelGD.horizontalAlignment = 4;
            labelGD.horizontalIndent = 0;
            label.setLayoutData((Object)labelGD);
            String defaultValueString = this.getPropertyDefaultValueString(descriptor);
            Text text = new Text((Composite)this, 133120);
            text.setText(defaultValueString);
            text.setToolTipText(pspa.getPropertyToolTip(descriptor));
            this.map.put(feature, text);
            GridData textGD = new GridData(3);
            textGD.grabExcessHorizontalSpace = true;
            textGD.horizontalAlignment = 4;
            text.setLayoutData((Object)textGD);
            text.addModifyListener(projectValidator);
            Label unitLabel = new Label((Composite)this, 0);
            unitLabel.setText(pspa.getPropertyUnits(descriptor));
            GridData unitLabelGD = new GridData(3);
            unitLabelGD.verticalAlignment = 2;
            unitLabel.setLayoutData((Object)unitLabelGD);
        }
    }

    public static boolean isUserSpecifiedSolverProperty(EStructuralFeature feature) {
        boolean retValue = false;
        EClass containingClass = feature.getEContainingClass();
        if (containingClass.equals(StochasticPackage.eINSTANCE.getStandardStochastic())) {
            retValue = true;
        }
        return retValue;
    }

    public StochasticSolverPropertyEditor(Composite parent, int style) {
        super(parent, style);
    }

    public void populate(Solver solver) {
        super.populate(solver);
        for (Map.Entry entry : this.map.entrySet()) {
            if (!(solver instanceof StandardStochastic)) continue;
            switch (((EStructuralFeature)entry.getKey()).getFeatureID()) {
                case 5: {
                    long lVal = new Long(((Text)entry.getValue()).getText());
                    ((StandardStochastic)solver).setSeed(lVal);
                    break;
                }
            }
        }
    }

    public boolean validate() {
        if (!super.validate()) {
            return false;
        }
        Text text = (Text)this.map.get(StochasticPackage.Literals.STANDARD_STOCHASTIC__SEED);
        if (text != null) {
            if (text.getText().equals("")) {
                this.errorMessage = SolverMessages.getString("SOLV_STANDARD_INVALID_SEED");
                return false;
            }
            String s = text.getText();
            try {
                Long.parseLong(s);
            }
            catch (Exception exception) {
                this.errorMessage = SolverMessages.getString("SOLV_STANDARD_INVALID_SEED");
                return false;
            }
        }
        return true;
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
    }

    public Solver createAndPopulateSolver() {
        StandardStochastic retValue = StochasticFactory.eINSTANCE.createStandardStochastic();
        retValue.setURI(STEMURI.createURI((String)("StandardStochastic/" + STEMURI.generateUniquePart())));
        this.populate((Solver)retValue);
        return retValue;
    }
}

