/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.wizards;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.ui.action.WorkbenchWindowActionDelegate;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.stem.core.Utility;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.core.common.presentation.CoreEditorAdvisor;
import org.eclipse.stem.ui.Activator;
import org.eclipse.stem.ui.wizards.DublinCorePage;
import org.eclipse.stem.ui.wizards.Messages;
import org.eclipse.stem.ui.wizards.NewIdentifiablePage;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public abstract class NewIdentifiableWizard
extends Wizard
implements INewWizard {
    private IWorkbench workbench;
    protected NewIdentifiablePage newIdentifiablePage = null;
    public DublinCorePage newDublinCorePage;
    protected String helpContextId;

    protected String getHelpContextId() {
        return this.helpContextId;
    }

    protected void setHelpContextId(String helpContextId) {
        this.helpContextId = helpContextId;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.setWindowTitle(this.getWizardTitle());
        this.setHelpAvailable(true);
    }

    public void addPages() {
        super.addPages();
        this.setForcePreviousAndNextButtons(false);
        this.newIdentifiablePage = this.createNewIdentifiablePage();
        if (this.newIdentifiablePage == null) {
            return;
        }
        this.newDublinCorePage = this.createDublinCorePage();
        if (this.newDublinCorePage == null) {
            return;
        }
        this.addPage((IWizardPage)this.newIdentifiablePage);
        this.addPage((IWizardPage)this.newDublinCorePage);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        IWizardPage nextPage = super.getNextPage(page);
        boolean cfr_ignored_0 = nextPage instanceof DublinCorePage;
        return nextPage;
    }

    public boolean performFinish() {
        try {
            final URI serializationURI = this.createSerializationURI();
            WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor monitor) {
                    NewIdentifiableWizard.this.createIdentifiable((IProgressMonitor)(monitor == null ? new NullProgressMonitor() : monitor), serializationURI);
                }
            };
            this.getContainer().run(false, true, (IRunnableWithProgress)op);
            try {
                this.newIdentifiablePage.getSelectedProject().refreshLocal(2, null);
            }
            catch (CoreException coreException) {}
            return CoreEditorAdvisor.openEditor(this.workbench, serializationURI);
        }
        catch (InvocationTargetException e) {
            Activator.logError("org.eclipse.stem.ui", e);
        }
        catch (InterruptedException e) {
            Activator.logInformation("org.eclipse.stem.ui", e);
        }
        return true;
    }

    void createIdentifiable(IProgressMonitor monitor, URI serializationURI) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(Messages.getString("NIdWiz.creating"), 100);
        try {
            try {
                Identifiable identifiable = this.createIdentifiable();
                identifiable.setURI(serializationURI);
                assert (identifiable.sane());
                Utility.serializeIdentifiable((Identifiable)identifiable, (URI)serializationURI);
            }
            catch (IOException e) {
                Activator.logError(Messages.getString("NIdWiz.saveErr"), e);
                monitor.done();
            }
            catch (Exception e) {
                Activator.logError(Messages.getString("NIdWiz.saveErr"), e);
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    private URI createSerializationURI() {
        StringBuilder sb = new StringBuilder(this.newIdentifiablePage.getSelectedProject().getName());
        sb.append("/");
        sb.append(this.getSerializationFolderName());
        sb.append("/");
        sb.append(this.getSerializationFileName());
        sb.append(".");
        sb.append(this.getSerializationFileNameExtension());
        return URI.createPlatformResourceURI((String)sb.toString(), (boolean)true);
    }

    protected String getSerializationFileName() {
        return this.newIdentifiablePage.serializationFileNameField.getText();
    }

    protected abstract String getWizardTitle();

    protected abstract NewIdentifiablePage createNewIdentifiablePage();

    protected abstract DublinCorePage createDublinCorePage();

    protected abstract Identifiable createIdentifiable();

    protected abstract String getSerializationFolderName();

    protected abstract String getSerializationFileNameExtension();

    protected static abstract class NewIdentifiableWizardAction
    extends WorkbenchWindowActionDelegate {
        protected NewIdentifiableWizardAction() {
        }

        protected void run(NewIdentifiableWizard wizard) {
            wizard.init(this.getWindow().getWorkbench(), (IStructuredSelection)StructuredSelection.EMPTY);
            WizardDialog wizardDialog = new WizardDialog(this.getWindow().getShell(), (IWizard)wizard);
            wizardDialog.open();
        }
    }
}

