/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.eval.preferences;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.actf.visualization.eval.preferences.IGuidelineTreeItem;
import org.eclipse.actf.visualization.internal.eval.EvaluationPlugin;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GuidelineTreeItemData
implements IGuidelineTreeItem {
    private static final int GUIDELINE_WCAG_P1 = 30;
    private static final int GUIDELINE_WCAG_P2 = 31;
    private static final int GUIDELINE_WCAG_P3 = 32;
    private static final int GUIDELINE_SECTION508 = 33;
    private static final int GUIDELINE_JIS = 34;
    private static final int GUIDELINE_IBMGUIDELINE = 35;
    private static final int GUIDELINE_IBMW3V8 = 36;
    private static final int GUIDELINE_ODF = 37;
    private static final int GUIDELINE_PII = 38;
    private static final int GUIDELINE_WACAG_2 = 50;
    private int _guideline = -1;
    private IGuidelineTreeItem _parent = null;
    private List<IGuidelineTreeItem> _children = null;
    private boolean _isEnabled = false;
    private boolean[] _correspondingCriteria;
    private int _index;
    private String _name = "";
    private String _category = "";
    private String _description = "";

    public GuidelineTreeItemData(String string) {
        this.setName(string);
        this._children = new ArrayList<IGuidelineTreeItem>();
    }

    @Override
    public IGuidelineTreeItem getParent() {
        return this._parent;
    }

    @Override
    public void add(IGuidelineTreeItem iGuidelineTreeItem) {
        this._children.add(iGuidelineTreeItem);
        this._parent = this;
    }

    @Override
    public List<IGuidelineTreeItem> getChildren() {
        return this._children;
    }

    private int getGuideline() {
        return this._guideline;
    }

    public void setName(String string) {
        this._name = string;
        if (this._name != null) {
            if (this._name.equals("WCAG (P1)")) {
                this._guideline = 30;
            } else if (this._name.equals("WCAG (P2)")) {
                this._guideline = 31;
            } else if (this._name.equals("WCAG (P3)")) {
                this._guideline = 32;
            } else if (this._name.equals("Section508")) {
                this._guideline = 33;
            } else if (this._name.startsWith("JIS")) {
                this._guideline = 34;
            } else if (this._name.equals("IBMGuideline")) {
                this._guideline = 35;
            } else if (this._name.equals("IBM w3 v8")) {
                this._guideline = 36;
            } else if (this._name.equals("ODF Guide")) {
                this._guideline = 37;
            } else if (this._name.equals("PII")) {
                this._guideline = 38;
            } else if (this._name.startsWith("WCAG 2.0")) {
                this._guideline = 50;
            }
        }
    }

    public Image getGuidelineImage() {
        switch (this.getGuideline()) {
            case 30: 
            case 31: 
            case 32: 
            case 50: {
                return EvaluationPlugin.getImageDescriptor("icons/media/w3c.png").createImage();
            }
            case 33: {
                return EvaluationPlugin.getImageDescriptor("icons/media/508.png").createImage();
            }
            case 34: {
                return EvaluationPlugin.getImageDescriptor("icons/media/jsa.png").createImage();
            }
            case 35: 
            case 36: 
            case 38: {
                return EvaluationPlugin.getImageDescriptor("icons/media/ibm.png").createImage();
            }
            case 37: {
                return EvaluationPlugin.getImageDescriptor("icons/media/oasis.png").createImage();
            }
        }
        return null;
    }

    public void setEnabled(boolean bl) {
        this._isEnabled = bl;
    }

    public boolean isEnabled() {
        return this._isEnabled;
    }

    public void setCorrespondingCriteria(boolean[] blArray) {
        this._correspondingCriteria = blArray;
    }

    public boolean[] getCorrespondingCriteria() {
        return this._correspondingCriteria;
    }

    public void setIndex(int n) {
        this._index = n;
    }

    public int getIndex() {
        return this._index;
    }

    public void setCategory(String string) {
        this._category = string;
    }

    public String getCategory() {
        return this._category;
    }

    public void setDescription(String string) {
        this._description = string;
    }

    public String getDescription() {
        return this._description;
    }
}

