/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.voice.internal;

import org.eclipse.actf.ai.tts.ITTSEngine;
import org.eclipse.actf.ai.tts.TTSRegistry;
import org.eclipse.actf.ai.voice.IVoice;
import org.eclipse.actf.ai.voice.IVoiceEventListener;
import org.eclipse.actf.ai.voice.VoiceUtil;
import org.eclipse.actf.ai.voice.internal.VoicePlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class Voice
implements IVoice,
IPropertyChangeListener {
    private ITTSEngine ttsEngine = this.newTTSEngine();
    private IVoiceEventListener eventListener;
    private static final IPreferenceStore preferenceStore = VoicePlugin.getDefault().getPreferenceStore();

    public Voice() {
        VoicePlugin.getDefault().addPropertyChangeListener(this);
        this.setSpeed();
    }

    private ITTSEngine newTTSEngine() {
        ITTSEngine iTTSEngine = TTSRegistry.createTTSEngine(preferenceStore.getString("activeEngine"));
        if (iTTSEngine == null) {
            iTTSEngine = TTSRegistry.createTTSEngine(TTSRegistry.getDefaultEngine());
        }
        return iTTSEngine;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("activeEngine".equals(propertyChangeEvent.getProperty())) {
            if (this.ttsEngine != null) {
                this.stop();
                this.ttsEngine.dispose();
                this.ttsEngine = this.newTTSEngine();
                this.setSpeed();
                this.setEventListener(this.eventListener);
            }
        } else if ("defaultSpeed".equals(propertyChangeEvent.getProperty())) {
            this.stop();
            this.setSpeed();
        }
    }

    public void speak(String string, boolean bl) {
        this.speak(string, bl, -1);
    }

    public void speak(String string, boolean bl, int n) {
        if (this.ttsEngine != null) {
            this.ttsEngine.speak(string, bl ? 1 : 0, n);
        }
    }

    public void stop() {
        if (this.ttsEngine != null) {
            this.ttsEngine.stop();
        }
    }

    public int getSpeed() {
        if (this.ttsEngine != null) {
            return this.ttsEngine.getSpeed();
        }
        return -1;
    }

    public void setSpeed() {
        this.setSpeed(VoiceUtil.getDefaultSpeed());
    }

    public void setSpeed(int n) {
        if (this.ttsEngine != null) {
            this.ttsEngine.setSpeed(n);
        }
    }

    public void setEventListener(IVoiceEventListener iVoiceEventListener) {
        this.eventListener = iVoiceEventListener;
        if (this.ttsEngine != null) {
            this.ttsEngine.setEventListener(iVoiceEventListener);
        }
    }

    public void dispose() {
        if (this.ttsEngine != null) {
            this.stop();
            this.ttsEngine.dispose();
            this.ttsEngine = null;
        }
    }

    public ITTSEngine getTTSEngine() {
        return this.ttsEngine;
    }
}

