/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.lowvision.util;

import org.eclipse.actf.visualization.engines.lowvision.LowVisionType;
import org.eclipse.actf.visualization.lowvision.ui.internal.Messages;

public class ParamLowVision {
    private static ParamLowVision INSTANCE;
    private boolean oEyeSight = true;
    private int iCurEyeSightValue = (int)Math.rint(50.0);
    private boolean oColorVision = true;
    private int iCurColorVisionValue = 2;
    private boolean oColorFilter = true;
    private int iCurColorFilterValue = (int)Math.rint(80.0);
    private LowVisionType lowVisionType = new LowVisionType();
    private static final double DEFAULT_EYESIGHT_DEGREE = 0.5;
    private static final int DEFAULT_CVD_TYPE = 2;
    private static final double DEFAULT_COLOR_FILTER = 0.8;

    public static ParamLowVision getDefaultInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ParamLowVision();
        }
        return INSTANCE;
    }

    public LowVisionType getLowVisionType() {
        try {
            this.lowVisionType.setEyesight(this.oEyeSight);
            if (this.oEyeSight) {
                float f = (float)this.iCurEyeSightValue / 100.0f;
                this.lowVisionType.setEyesightDegree(f);
            }
            this.lowVisionType.setCVD(this.oColorVision);
            if (this.oColorVision) {
                this.lowVisionType.setCVDType(this.iCurColorVisionValue);
            }
            this.lowVisionType.setColorFilter(this.oColorFilter);
            if (this.oColorFilter) {
                this.lowVisionType.setColorFilterDegree((float)this.iCurColorFilterValue / 100.0f);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return this.lowVisionType;
    }

    public Object clone() {
        ParamLowVision paramLowVision = new ParamLowVision();
        paramLowVision.setColorFilterValue(this.iCurColorFilterValue);
        paramLowVision.setColorVisionValue(this.iCurColorVisionValue);
        paramLowVision.setEyeSightValue(this.iCurEyeSightValue);
        paramLowVision.setColorFilter(this.oColorFilter);
        paramLowVision.setColorVision(this.oColorVision);
        paramLowVision.setEyeSight(this.oEyeSight);
        return paramLowVision;
    }

    public int getColorFilterValue() {
        return this.iCurColorFilterValue;
    }

    public int getColorVisionValue() {
        return this.iCurColorVisionValue;
    }

    public int getEyeSightValue() {
        return this.iCurEyeSightValue;
    }

    public boolean useColorFilter() {
        return this.oColorFilter;
    }

    public boolean useColorVision() {
        return this.oColorVision;
    }

    public boolean useEyeSight() {
        return this.oEyeSight;
    }

    public void setColorFilterValue(int n) {
        this.iCurColorFilterValue = n;
    }

    public void setColorVisionValue(int n) {
        this.iCurColorVisionValue = n;
    }

    public void setEyeSightValue(int n) {
        this.iCurEyeSightValue = n;
    }

    public void setColorFilter(boolean bl) {
        this.oColorFilter = bl;
    }

    public void setColorVision(boolean bl) {
        this.oColorVision = bl;
    }

    public void setEyeSight(boolean bl) {
        this.oEyeSight = bl;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(" ");
        if (this.useEyeSight()) {
            stringBuffer.append(String.valueOf(Messages.ParamLowVision_1) + " " + (float)this.getEyeSightValue() / 100.0f + "  ");
        }
        if (this.useColorVision()) {
            stringBuffer.append(String.valueOf(Messages.ParamLowVision_4) + " " + this.getColorVisionValue() + "  ");
        }
        if (this.useColorFilter()) {
            stringBuffer.append(String.valueOf(Messages.ParamLowVision_7) + " " + (float)this.getColorFilterValue() / 100.0f + "  ");
        }
        return stringBuffer.toString();
    }
}

