/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.accservice.swtbridge.internal.ia2;

import org.eclipse.actf.accservice.swtbridge.AccessibleObject;
import org.eclipse.actf.accservice.swtbridge.ia2.AccessibleTable;
import org.eclipse.actf.accservice.swtbridge.ia2.AccessibleTableModelChange;
import org.eclipse.actf.accservice.swtbridge.ia2.RowColumnExtents;
import org.eclipse.actf.accservice.swtbridge.internal.InternalAccessibleObject;
import org.eclipse.actf.accservice.swtbridge.internal.ia2.IAccessibleTable;
import org.eclipse.actf.util.win32.MemoryUtil;
import org.eclipse.actf.util.win32.NativeIntAccess;
import org.eclipse.actf.util.win32.NativeStringAccess;
import org.eclipse.swt.internal.ole.win32.COM;

public class InternalAccessibleTable
implements AccessibleTable {
    private IAccessibleTable accessibleTable = null;

    public InternalAccessibleTable(int n) {
        this.accessibleTable = new IAccessibleTable(n);
        this.accessibleTable.AddRef();
    }

    public void dispose() {
        if (this.accessibleTable != null) {
            this.accessibleTable.Release();
            this.accessibleTable = null;
        }
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    public AccessibleObject getAccessibleCellAt(int n, int n2) {
        if (this.accessibleTable != null) {
            NativeIntAccess nativeIntAccess = new NativeIntAccess();
            try {
                if (this.accessibleTable.get_accessibleAt(n, n2, nativeIntAccess.getAddress()) == 0) {
                    AccessibleObject accessibleObject = InternalAccessibleObject.newInstance(nativeIntAccess.getInt());
                    return accessibleObject;
                }
            }
            finally {
                nativeIntAccess.dispose();
            }
        }
        return null;
    }

    public Object getAccessibleCaption() {
        if (this.accessibleTable != null) {
            NativeIntAccess nativeIntAccess = new NativeIntAccess();
            try {
                if (this.accessibleTable.get_caption(nativeIntAccess.getAddress()) == 0) {
                    AccessibleObject accessibleObject = InternalAccessibleObject.newInstance(nativeIntAccess.getInt());
                    return accessibleObject;
                }
            }
            finally {
                nativeIntAccess.dispose();
            }
        }
        return null;
    }

    public int getAccessibleIndex(int n, int n2) {
        if (this.accessibleTable != null) {
            NativeIntAccess nativeIntAccess = new NativeIntAccess();
            try {
                if (this.accessibleTable.get_childIndex(n, n2, nativeIntAccess.getAddress()) == 0) {
                    int n3 = nativeIntAccess.getInt();
                    return n3;
                }
            }
            finally {
                nativeIntAccess.dispose();
            }
        }
        return -1;
    }

    public String getAccessibleColumnDescription(int n) {
        if (this.accessibleTable != null) {
            NativeStringAccess nativeStringAccess = new NativeStringAccess();
            try {
                if (this.accessibleTable.get_columnDescription(n, nativeStringAccess.getAddress()) == 0) {
                    String string = nativeStringAccess.getString();
                    return string;
                }
            }
            finally {
                nativeStringAccess.dispose();
            }
        }
        return null;
    }

    public int getAccessibleColumnExtentAt(int n, int n2) {
        if (this.accessibleTable != null) {
            NativeIntAccess nativeIntAccess = new NativeIntAccess();
            try {
                if (this.accessibleTable.get_columnExtentAt(n, n2, nativeIntAccess.getAddress()) == 0) {
                    int n3 = nativeIntAccess.getInt();
                    return n3;
                }
            }
            finally {
                nativeIntAccess.dispose();
            }
        }
        return -1;
    }

    public InternalAccessibleTable getAccessibleColumnHeaders(int[] nArray) {
        if (this.accessibleTable != null) {
            NativeIntAccess nativeIntAccess = new NativeIntAccess(2);
            try {
                if (this.accessibleTable.get_columnHeader(nativeIntAccess.getAddress(0), nativeIntAccess.getAddress(1)) == 0) {
                    nArray[0] = nativeIntAccess.getInt(1);
                    InternalAccessibleTable internalAccessibleTable = new InternalAccessibleTable(nativeIntAccess.getInt(0));
                    return internalAccessibleTable;
                }
            }
            finally {
                nativeIntAccess.dispose();
            }
        }
        return null;
    }

    public int getAccessibleColumnIndex(int n) {
        if (this.accessibleTable != null) {
            NativeIntAccess nativeIntAccess = new NativeIntAccess();
            try {
                if (this.accessibleTable.get_columnIndex(n, nativeIntAccess.getAddress()) == 0) {
                    int n2 = nativeIntAccess.getInt();
                    return n2;
                }
            }
            finally {
                nativeIntAccess.dispose();
            }
        }
        return -1;
    }

    public int getAccessibleColumnCount() {
        if (this.accessibleTable != null) {
            NativeIntAccess nativeIntAccess = new NativeIntAccess();
            try {
                if (this.accessibleTable.get_nColumns(nativeIntAccess.getAddress()) == 0) {
                    int n = nativeIntAccess.getInt();
                    return n;
                }
            }
            finally {
                nativeIntAccess.dispose();
            }
        }
        return 0;
    }

    public int getAccessibleRowCount() {
        if (this.accessibleTable != null) {
            NativeIntAccess nativeIntAccess = new NativeIntAccess();
            try {
                if (this.accessibleTable.get_nRows(nativeIntAccess.getAddress()) == 0) {
                    int n = nativeIntAccess.getInt();
                    return n;
                }
            }
            finally {
                nativeIntAccess.dispose();
            }
        }
        return 0;
    }

    public int getSelectedAccessibleChildCount() {
        if (this.accessibleTable != null) {
            NativeIntAccess nativeIntAccess = new NativeIntAccess();
            try {
                if (this.accessibleTable.get_nSelectedChildren(nativeIntAccess.getAddress()) == 0) {
                    int n = nativeIntAccess.getInt();
                    return n;
                }
            }
            finally {
                nativeIntAccess.dispose();
            }
        }
        return 0;
    }

    public int getSelectedAccessibleColumnCount() {
        if (this.accessibleTable != null) {
            NativeIntAccess nativeIntAccess = new NativeIntAccess();
            try {
                if (this.accessibleTable.get_nSelectedColumns(nativeIntAccess.getAddress()) == 0) {
                    int n = nativeIntAccess.getInt();
                    return n;
                }
            }
            finally {
                nativeIntAccess.dispose();
            }
        }
        return 0;
    }

    public int getSelectedAccessibleRowCount() {
        if (this.accessibleTable != null) {
            NativeIntAccess nativeIntAccess = new NativeIntAccess();
            try {
                if (this.accessibleTable.get_nSelectedRows(nativeIntAccess.getAddress()) == 0) {
                    int n = nativeIntAccess.getInt();
                    return n;
                }
            }
            finally {
                nativeIntAccess.dispose();
            }
        }
        return 0;
    }

    public String getAccessibleRowDescription(int n) {
        if (this.accessibleTable != null) {
            NativeStringAccess nativeStringAccess = new NativeStringAccess();
            try {
                if (this.accessibleTable.get_rowDescription(n, nativeStringAccess.getAddress()) == 0) {
                    String string = nativeStringAccess.getString();
                    return string;
                }
            }
            finally {
                nativeStringAccess.dispose();
            }
        }
        return null;
    }

    public int getAccessibleRowExtentAt(int n, int n2) {
        if (this.accessibleTable != null) {
            NativeIntAccess nativeIntAccess = new NativeIntAccess();
            try {
                if (this.accessibleTable.get_rowExtentAt(n, n2, nativeIntAccess.getAddress()) == 0) {
                    int n3 = nativeIntAccess.getInt();
                    return n3;
                }
            }
            finally {
                nativeIntAccess.dispose();
            }
        }
        return 0;
    }

    public InternalAccessibleTable getAccessibleRowHeaders(int[] nArray) {
        if (this.accessibleTable != null) {
            NativeIntAccess nativeIntAccess = new NativeIntAccess(2);
            try {
                if (this.accessibleTable.get_rowHeader(nativeIntAccess.getAddress(0), nativeIntAccess.getAddress(1)) == 0) {
                    nArray[0] = nativeIntAccess.getInt(1);
                    InternalAccessibleTable internalAccessibleTable = new InternalAccessibleTable(nativeIntAccess.getInt(0));
                    return internalAccessibleTable;
                }
            }
            finally {
                nativeIntAccess.dispose();
            }
        }
        return null;
    }

    public int getAccessibleRowIndex(int n) {
        if (this.accessibleTable != null) {
            NativeIntAccess nativeIntAccess = new NativeIntAccess();
            try {
                if (this.accessibleTable.get_rowIndex(n, nativeIntAccess.getAddress()) == 0) {
                    int n2 = nativeIntAccess.getInt();
                    return n2;
                }
            }
            finally {
                nativeIntAccess.dispose();
            }
        }
        return 0;
    }

    public int[] getSelectedAccessibleChildren(int n) {
        if (this.accessibleTable != null && n > 0) {
            NativeIntAccess nativeIntAccess = new NativeIntAccess(n + 1);
            try {
                if (this.accessibleTable.get_selectedChildren(n, nativeIntAccess.getAddress(1), nativeIntAccess.getAddress(0)) == 0) {
                    int n2 = nativeIntAccess.getInt(0);
                    int[] nArray = new int[n2];
                    MemoryUtil.MoveMemory((int[])nArray, (int)nativeIntAccess.getInt(1), (int)(4 * n2));
                    COM.CoTaskMemFree((int)nativeIntAccess.getInt(1));
                    int[] nArray2 = nArray;
                    return nArray2;
                }
            }
            finally {
                nativeIntAccess.dispose();
            }
        }
        return null;
    }

    public int[] getSelectedAccessibleRows(int n) {
        if (this.accessibleTable != null && n > 0) {
            NativeIntAccess nativeIntAccess = new NativeIntAccess(n + 1);
            try {
                if (this.accessibleTable.get_selectedRows(n, nativeIntAccess.getAddress(1), nativeIntAccess.getAddress(0)) == 0) {
                    int n2 = nativeIntAccess.getInt(0);
                    int[] nArray = new int[n2];
                    MemoryUtil.MoveMemory((int[])nArray, (int)nativeIntAccess.getInt(1), (int)(4 * n2));
                    COM.CoTaskMemFree((int)nativeIntAccess.getInt(1));
                    int[] nArray2 = nArray;
                    return nArray2;
                }
            }
            finally {
                nativeIntAccess.dispose();
            }
        }
        return null;
    }

    public int[] getSelectedAccessibleColumns(int n) {
        if (this.accessibleTable != null) {
            NativeIntAccess nativeIntAccess = new NativeIntAccess(n + 1);
            try {
                if (this.accessibleTable.get_selectedColumns(n, nativeIntAccess.getAddress(1), nativeIntAccess.getAddress(0)) == 0) {
                    int n2 = nativeIntAccess.getInt(0);
                    int[] nArray = new int[n2];
                    MemoryUtil.MoveMemory((int[])nArray, (int)nativeIntAccess.getInt(1), (int)(4 * n2));
                    COM.CoTaskMemFree((int)nativeIntAccess.getInt(1));
                    int[] nArray2 = nArray;
                    return nArray2;
                }
            }
            finally {
                nativeIntAccess.dispose();
            }
        }
        return null;
    }

    public Object getAccessibleSummary() {
        if (this.accessibleTable != null) {
            NativeIntAccess nativeIntAccess = new NativeIntAccess();
            try {
                if (this.accessibleTable.get_summary(nativeIntAccess.getAddress()) == 0) {
                    AccessibleObject accessibleObject = InternalAccessibleObject.newInstance(nativeIntAccess.getInt());
                    return accessibleObject;
                }
            }
            finally {
                nativeIntAccess.dispose();
            }
        }
        return null;
    }

    public boolean isAccessibleColumnSelected(int n) {
        if (this.accessibleTable != null) {
            NativeIntAccess nativeIntAccess = new NativeIntAccess();
            try {
                if (this.accessibleTable.get_isColumnSelected(n, nativeIntAccess.getAddress()) == 0) {
                    boolean bl = nativeIntAccess.getInt() != 0;
                    return bl;
                }
            }
            finally {
                nativeIntAccess.dispose();
            }
        }
        return false;
    }

    public boolean isAccessibleRowSelected(int n) {
        if (this.accessibleTable != null) {
            NativeIntAccess nativeIntAccess = new NativeIntAccess();
            try {
                if (this.accessibleTable.get_isRowSelected(n, nativeIntAccess.getAddress()) == 0) {
                    boolean bl = nativeIntAccess.getInt() != 0;
                    return bl;
                }
            }
            finally {
                nativeIntAccess.dispose();
            }
        }
        return false;
    }

    public boolean isAccessibleSelected(int n, int n2) {
        if (this.accessibleTable != null) {
            NativeIntAccess nativeIntAccess = new NativeIntAccess();
            try {
                if (this.accessibleTable.get_isSelected(n, n2, nativeIntAccess.getAddress()) == 0) {
                    boolean bl = nativeIntAccess.getInt() != 0;
                    return bl;
                }
            }
            finally {
                nativeIntAccess.dispose();
            }
        }
        return false;
    }

    public boolean selectAccessibleRow(int n) {
        if (this.accessibleTable != null) {
            return this.accessibleTable.selectRow(n) == 0;
        }
        return false;
    }

    public boolean selectAccessibleColumn(int n) {
        if (this.accessibleTable != null) {
            return this.accessibleTable.selectColumn(n) == 0;
        }
        return false;
    }

    public boolean unselectAccessibleRow(int n) {
        if (this.accessibleTable != null) {
            return this.accessibleTable.unselectRow(n) == 0;
        }
        return false;
    }

    public boolean unselectAccessibleColumn(int n) {
        if (this.accessibleTable != null) {
            return this.accessibleTable.unselectColumn(n) == 0;
        }
        return false;
    }

    public RowColumnExtents getAccessibleRowColumnExtentAtIndex(int n) {
        if (this.accessibleTable != null) {
            NativeIntAccess nativeIntAccess = new NativeIntAccess(5);
            try {
                if (this.accessibleTable.get_rowColumnExtentsAtIndex(n, nativeIntAccess.getAddress(0), nativeIntAccess.getAddress(1), nativeIntAccess.getAddress(2), nativeIntAccess.getAddress(3), nativeIntAccess.getAddress(4)) == 0) {
                    RowColumnExtents rowColumnExtents = new RowColumnExtents(nativeIntAccess.getAddress(0), nativeIntAccess.getAddress(1), nativeIntAccess.getAddress(2), nativeIntAccess.getAddress(3), nativeIntAccess.getAddress(4) != 0);
                    return rowColumnExtents;
                }
            }
            finally {
                nativeIntAccess.dispose();
            }
        }
        return null;
    }

    public AccessibleTableModelChange getAccessibleTableModelChange() {
        if (this.accessibleTable != null) {
            NativeIntAccess nativeIntAccess = new NativeIntAccess(5);
            try {
                if (this.accessibleTable.get_modelChange(nativeIntAccess.getAddress()) == 0) {
                    AccessibleTableModelChange accessibleTableModelChange = new AccessibleTableModelChange(nativeIntAccess.getAddress(0), nativeIntAccess.getAddress(1), nativeIntAccess.getAddress(2), nativeIntAccess.getAddress(3), nativeIntAccess.getAddress(4));
                    return accessibleTableModelChange;
                }
            }
            finally {
                nativeIntAccess.dispose();
            }
        }
        return null;
    }
}

