/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.gui.ui.views;

import org.eclipse.actf.accservice.swtbridge.AccessibleObject;
import org.eclipse.actf.accservice.swtbridge.MSAA;
import org.eclipse.actf.util.win32.HighlightComposite;
import org.eclipse.actf.util.win32.OverlayLabel;
import org.eclipse.actf.visualization.gui.IGuiViewIDs;
import org.eclipse.actf.visualization.gui.internal.util.AccessiblePropertyUtil;
import org.eclipse.actf.visualization.gui.internal.util.GuiImages;
import org.eclipse.actf.visualization.gui.internal.util.Messages;
import org.eclipse.actf.visualization.gui.msaa.checker.MSAAProblem;
import org.eclipse.actf.visualization.gui.msaa.checker.MSAAProblemChecker;
import org.eclipse.actf.visualization.gui.msaa.checker.MSAAProblemConst;
import org.eclipse.actf.visualization.gui.preferences.GuiPreferenceManager;
import org.eclipse.actf.visualization.gui.ui.views.AccessibleObjectSelectionProvider;
import org.eclipse.actf.visualization.gui.ui.views.IMSAAOutlineView;
import org.eclipse.actf.visualization.gui.ui.views.IMSAAProblemsView;
import org.eclipse.actf.visualization.gui.ui.views.MSAAOutlineView;
import org.eclipse.actf.visualization.gui.ui.views.MSAAViewRegistory;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.ArmEvent;
import org.eclipse.swt.events.ArmListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class MSAAProblemsView
extends ViewPart
implements IMSAAProblemsView,
MSAAProblemConst {
    private static final String[] HEADINGS = new String[]{"", Messages.msaa_description, "Name", "Role", "State", "X", "Y", "W", "H"};
    private static final int[] WEIGHTS = new int[]{1, 15, 8, 6, 10, 2, 2, 2, 2};
    private static final int[] ALIGNMENTS = new int[]{131072, 16384, 16384, 16384, 16384, 131072, 131072, 131072, 131072};
    private TableViewer viewer;
    private MSAAProblemsViewerSorter sorter = new MSAAProblemsViewerSorter();
    private boolean suppressLabelAdjust = false;
    private Action refreshAction;
    private Action showLabelsAction;
    private Action showErrorAction;
    private Action showWarningAction;
    private Action showInformationAction;
    private ProblemFilter filter = new ProblemFilter();

    public void createPartControl(Composite composite) {
        Table table = new Table(composite, 68356);
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        int n = 0;
        while (n < HEADINGS.length) {
            tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(WEIGHTS[n]));
            TableColumn tableColumn = new TableColumn(table, 0);
            tableColumn.setText(HEADINGS[n]);
            tableColumn.setAlignment(ALIGNMENTS[n]);
            tableColumn.setResizable(true);
            final int n2 = n + 1;
            tableColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    ((MSAAProblemsView)MSAAProblemsView.this).sorter.sortingColumn = n2 == ((MSAAProblemsView)MSAAProblemsView.this).sorter.sortingColumn ? -n2 : n2;
                    MSAAProblemsView.this.viewer.refresh();
                }
            });
            ++n;
        }
        this.viewer = new TableViewer(table);
        MSAAProblemsContentAndLabelProvider mSAAProblemsContentAndLabelProvider = new MSAAProblemsContentAndLabelProvider();
        this.viewer.setContentProvider((IContentProvider)mSAAProblemsContentAndLabelProvider);
        this.viewer.setLabelProvider((IBaseLabelProvider)mSAAProblemsContentAndLabelProvider);
        this.viewer.setSorter((ViewerSorter)this.sorter);
        this.viewer.addFilter((ViewerFilter)this.filter);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                Object object;
                ISelection iSelection = selectionChangedEvent.getSelection();
                if (iSelection instanceof IStructuredSelection && (object = ((IStructuredSelection)iSelection).getFirstElement()) instanceof MSAAProblem) {
                    AccessibleObject accessibleObject = ((MSAAProblem)object).getErrorObject();
                    if (accessibleObject != null) {
                        IMSAAOutlineView iMSAAOutlineView = (IMSAAOutlineView)MSAAViewRegistory.findView(IGuiViewIDs.ID_OUTLINEVIEW);
                        if (iMSAAOutlineView != null) {
                            iMSAAOutlineView.setSelection(accessibleObject);
                        } else {
                            HighlightComposite.flashRectangle((Rectangle)accessibleObject.getAccLocation());
                        }
                    }
                    if (!MSAAProblemsView.this.suppressLabelAdjust) {
                        MSAAProblemsView.this.showOverlayLabels();
                    }
                }
            }
        });
        this.makeActions();
        this.hookContextMenu();
        this.contributeToActionBars();
        HighlightComposite.initOverlayWindow();
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void refresh() {
        AccessibleObject accessibleObject = MSAAViewRegistory.getRootObject();
        if (accessibleObject != null) {
            this.viewer.setInput((Object)new MSAAProblemChecker(accessibleObject));
            this.showOverlayLabels();
        }
    }

    private void showOverlayLabels() {
        OverlayLabel.removeAll();
        if (this.showLabelsAction.isChecked()) {
            TableItem[] tableItemArray = this.viewer.getTable().getItems();
            Object object = ((StructuredSelection)this.viewer.getSelection()).getFirstElement();
            int n = 1;
            while (n <= 3) {
                this.createOverlayLabels(tableItemArray, object, n);
                ++n;
            }
            OverlayLabel.setOwnerId((String)IGuiViewIDs.ID_REPORTVIEW);
        }
    }

    private void createOverlayLabels(TableItem[] tableItemArray, Object object, int n) {
        int n2 = 0;
        while (n2 < tableItemArray.length) {
            AccessibleObject accessibleObject;
            Rectangle rectangle;
            MSAAProblem mSAAProblem = (MSAAProblem)tableItemArray[n2].getData();
            if (n == mSAAProblem.getErrorCategory() && (rectangle = (accessibleObject = mSAAProblem.getErrorObject()).getAccLocation()) != null) {
                OverlayLabel overlayLabel = OverlayLabel.create((Object)mSAAProblem);
                if (mSAAProblem.equals(object)) {
                    overlayLabel.setForeground(overlayLabel.getDisplay().getSystemColor(27));
                    overlayLabel.setBackground(overlayLabel.getDisplay().getSystemColor(26));
                }
                MSAAProblemsContentAndLabelProvider mSAAProblemsContentAndLabelProvider = (MSAAProblemsContentAndLabelProvider)this.viewer.getLabelProvider();
                overlayLabel.setImage(mSAAProblemsContentAndLabelProvider.getColumnImage(mSAAProblem, 0));
                String string = String.valueOf(mSAAProblemsContentAndLabelProvider.getColumnText(mSAAProblem, 1)) + "\n" + MSAAOutlineView.getTreeText(accessibleObject);
                String[][] stringArray = AccessiblePropertyUtil.getPropertyStrings(accessibleObject);
                overlayLabel.setTooltop(string, stringArray);
                overlayLabel.pack();
                overlayLabel.setLocation(rectangle.x, rectangle.y);
                overlayLabel.addMouseListener((MouseListener)new MouseAdapter(){

                    public void mouseDown(MouseEvent mouseEvent) {
                        if (mouseEvent.widget instanceof OverlayLabel) {
                            OverlayLabel[] overlayLabelArray = OverlayLabel.getLabelsAtPosition((Point)mouseEvent.display.getCursorLocation());
                            if (overlayLabelArray.length > 0) {
                                MSAAProblemsView.this.showSelectionMenu(overlayLabelArray, (OverlayLabel)mouseEvent.widget);
                            } else {
                                MSAAProblemsView.this.viewer.setSelection((ISelection)new StructuredSelection(((OverlayLabel)mouseEvent.widget).associatedObject));
                            }
                        }
                    }
                });
                overlayLabel.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

                    public void mouseEnter(MouseEvent mouseEvent) {
                        MSAAProblem mSAAProblem;
                        AccessibleObject accessibleObject;
                        if (mouseEvent.widget instanceof OverlayLabel && (accessibleObject = (mSAAProblem = (MSAAProblem)((OverlayLabel)mouseEvent.widget).associatedObject).getErrorObject()) != null) {
                            HighlightComposite.flashRectangle((Rectangle)accessibleObject.getAccLocation());
                        }
                    }

                    public void mouseExit(MouseEvent mouseEvent) {
                        HighlightComposite.show((boolean)false);
                    }
                });
            }
            ++n2;
        }
    }

    private void showSelectionMenu(OverlayLabel[] overlayLabelArray, OverlayLabel overlayLabel) {
        Menu menu = overlayLabel.createPopupMenu();
        MenuItem[] menuItemArray = new MenuItem[overlayLabelArray.length];
        int n = 0;
        while (n < overlayLabelArray.length) {
            menuItemArray[n] = new MenuItem(menu, 8);
            menuItemArray[n].setText(overlayLabelArray[n].getMenuText());
            menuItemArray[n].setImage(overlayLabelArray[n].getImage());
            menuItemArray[n].setData(overlayLabelArray[n].associatedObject);
            menuItemArray[n].addArmListener(new ArmListener(){

                public void widgetArmed(ArmEvent armEvent) {
                    AccessibleObject accessibleObject;
                    Object object = ((MenuItem)armEvent.getSource()).getData();
                    if (object instanceof MSAAProblem && (accessibleObject = ((MSAAProblem)object).getErrorObject()) != null) {
                        HighlightComposite.flashRectangle((Rectangle)accessibleObject.getAccLocation());
                    }
                }
            });
            menuItemArray[n].addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    Object object = ((MenuItem)selectionEvent.getSource()).getData();
                    MSAAProblemsView.this.suppressLabelAdjust = true;
                    MSAAProblemsView.this.viewer.setSelection((ISelection)new StructuredSelection(object));
                    MSAAProblemsView.this.suppressLabelAdjust = false;
                }
            });
            ++n;
        }
        menu.setVisible(true);
    }

    private void hookContextMenu() {
        MenuManager menuManager = new MenuManager("#PopupMenu");
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                MSAAProblemsView.this.fillContextMenu(iMenuManager);
            }
        });
        Menu menu = menuManager.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.viewer);
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)new AccessibleObjectSelectionProvider(){

            public Object getSelectedAccessibleObject() {
                return MSAAProblemsView.this.getSelectedItem();
            }
        });
    }

    private void contributeToActionBars() {
        IActionBars iActionBars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(iActionBars.getMenuManager());
        this.fillLocalToolBar(iActionBars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager iMenuManager) {
        iMenuManager.add((IAction)this.showErrorAction);
        iMenuManager.add((IAction)this.showWarningAction);
        iMenuManager.add((IAction)this.showInformationAction);
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add((IAction)this.showLabelsAction);
    }

    private void fillContextMenu(IMenuManager iMenuManager) {
        iMenuManager.add((IAction)this.refreshAction);
        iMenuManager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager iToolBarManager) {
        iToolBarManager.add((IAction)this.refreshAction);
        iToolBarManager.add((IAction)this.showLabelsAction);
    }

    private void makeActions() {
        Shell shell = this.getViewSite().getShell();
        this.refreshAction = new Action(Messages.msaa_refresh){

            public void run() {
                MSAAProblemsView.this.refresh();
            }
        };
        this.refreshAction.setToolTipText(Messages.msaa_refresh);
        this.refreshAction.setImageDescriptor(GuiImages.IMAGE_REFRESH);
        this.showLabelsAction = new Action(Messages.msaa_show_problem, 2){

            public void run() {
                MSAAProblemsView.this.showOverlayLabels();
            }
        };
        this.showLabelsAction.setToolTipText(Messages.msaa_show_problem);
        this.showLabelsAction.setImageDescriptor(GuiImages.IMAGE_OVERLAY);
        shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellActivated(ShellEvent shellEvent) {
                if (IGuiViewIDs.ID_REPORTVIEW.equals(OverlayLabel.getOwnerId())) {
                    MSAAProblemsView.this.showOverlayLabels();
                }
            }

            public void shellDeactivated(ShellEvent shellEvent) {
                if (IGuiViewIDs.ID_REPORTVIEW.equals(OverlayLabel.getOwnerId())) {
                    OverlayLabel.removeAll((boolean)false);
                }
            }
        });
        this.showLabelsAction.setEnabled(GuiPreferenceManager.getPreferenceBoolean("UseOverlayWindow"));
        IPreferenceStore iPreferenceStore = GuiPreferenceManager.getPreferenceStore();
        iPreferenceStore.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("UseOverlayWindow".equals(propertyChangeEvent.getProperty())) {
                    MSAAProblemsView.this.showLabelsAction.setEnabled(GuiPreferenceManager.getPreferenceBoolean("UseOverlayWindow"));
                }
            }
        });
        this.showErrorAction = new Action(Messages.msaa_showError, 2){

            public void run() {
                ((MSAAProblemsView)MSAAProblemsView.this).filter.categorySelect[1] = MSAAProblemsView.this.showErrorAction.isChecked();
                MSAAProblemsView.this.refresh();
            }
        };
        this.showErrorAction.setChecked(this.filter.categorySelect[1]);
        this.showWarningAction = new Action(Messages.msaa_showWarning, 2){

            public void run() {
                ((MSAAProblemsView)MSAAProblemsView.this).filter.categorySelect[2] = MSAAProblemsView.this.showWarningAction.isChecked();
                MSAAProblemsView.this.refresh();
            }
        };
        this.showWarningAction.setChecked(this.filter.categorySelect[2]);
        this.showInformationAction = new Action(Messages.msaa_showInformation, 2){

            public void run() {
                ((MSAAProblemsView)MSAAProblemsView.this).filter.categorySelect[3] = MSAAProblemsView.this.showInformationAction.isChecked();
                MSAAProblemsView.this.refresh();
            }
        };
        this.showInformationAction.setChecked(this.filter.categorySelect[3]);
    }

    private Object getSelectedItem() {
        Object object;
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.viewer.getSelection();
        if (iStructuredSelection.size() == 1 && (object = iStructuredSelection.getFirstElement()) instanceof MSAAProblem) {
            return ((MSAAProblem)object).getErrorObject();
        }
        return null;
    }

    private class MSAAProblemsContentAndLabelProvider
    extends LabelProvider
    implements IStructuredContentProvider,
    IPropertyChangeListener,
    ITableLabelProvider {
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();

        private MSAAProblemsContentAndLabelProvider() {
        }

        public Object[] getElements(Object object) {
            if (object instanceof MSAAProblemChecker) {
                return ((MSAAProblemChecker)object).getProblems();
            }
            return new Object[0];
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        }

        public Image getColumnImage(Object object, int n) {
            if (n == 0 && object instanceof MSAAProblem) {
                switch (((MSAAProblem)object).getErrorCategory()) {
                    case 1: {
                        return this.sharedImages.getImage("IMG_OBJS_ERROR_TSK");
                    }
                    case 2: {
                        return this.sharedImages.getImage("IMG_OBJS_WARN_TSK");
                    }
                    case 3: {
                        return this.sharedImages.getImage("IMG_OBJS_INFO_TSK");
                    }
                }
            }
            return null;
        }

        public String getColumnText(Object object, int n) {
            if (object instanceof MSAAProblem) {
                MSAAProblem mSAAProblem = (MSAAProblem)object;
                AccessibleObject accessibleObject = mSAAProblem.getErrorObject();
                switch (n) {
                    case 0: {
                        return "";
                    }
                    case 1: {
                        return ((MSAAProblem)object).getErrorDescription();
                    }
                    case 2: {
                        if (accessibleObject == null) {
                            return "";
                        }
                        return accessibleObject.getAccName();
                    }
                    case 3: {
                        if (accessibleObject == null) {
                            return "";
                        }
                        return accessibleObject.getRoleText();
                    }
                    case 4: {
                        if (accessibleObject == null) {
                            return "";
                        }
                        return MSAA.getStateText(accessibleObject.getAccState());
                    }
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        if (accessibleObject == null) {
                            return "";
                        }
                        Rectangle rectangle = accessibleObject.getAccLocation();
                        if (rectangle == null) {
                            return "";
                        }
                        switch (n - 5) {
                            case 0: {
                                return Integer.toString(rectangle.x);
                            }
                            case 1: {
                                return Integer.toString(rectangle.y);
                            }
                            case 2: {
                                return Integer.toString(rectangle.width);
                            }
                            case 3: {
                                return Integer.toString(rectangle.height);
                            }
                        }
                    }
                }
                return "???";
            }
            return null;
        }
    }

    private class MSAAProblemsViewerSorter
    extends ViewerSorter {
        public int sortingColumn = 0;

        private MSAAProblemsViewerSorter() {
        }

        public int compare(Viewer viewer, Object object, Object object2) {
            IBaseLabelProvider iBaseLabelProvider;
            if (this.sortingColumn != 0 && viewer instanceof TableViewer && (iBaseLabelProvider = ((TableViewer)viewer).getLabelProvider()) instanceof ITableLabelProvider) {
                int n = Math.abs(this.sortingColumn) - 1;
                String string = ((ITableLabelProvider)iBaseLabelProvider).getColumnText(object, n);
                String string2 = ((ITableLabelProvider)iBaseLabelProvider).getColumnText(object2, n);
                int n2 = 0;
                switch (n) {
                    case 0: {
                        n2 = ((MSAAProblem)object).getErrorCategory() - ((MSAAProblem)object2).getErrorCategory();
                        break;
                    }
                    default: {
                        try {
                            n2 = Integer.parseInt(string) - Integer.parseInt(string2);
                            break;
                        }
                        catch (Exception exception) {}
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        n2 = this.getComparator().compare(string, string2);
                    }
                }
                return this.sortingColumn > 0 ? n2 : -n2;
            }
            return 0;
        }
    }

    private class ProblemFilter
    extends ViewerFilter {
        public boolean[] categorySelect;

        private ProblemFilter() {
            boolean[] blArray = new boolean[5];
            blArray[1] = true;
            this.categorySelect = blArray;
        }

        public boolean select(Viewer viewer, Object object, Object object2) {
            int n;
            if (object2 instanceof MSAAProblem && (n = ((MSAAProblem)object2).getErrorCategory()) < this.categorySelect.length) {
                return this.categorySelect[n];
            }
            return true;
        }
    }
}

