/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.gui.ui.views;

import org.eclipse.actf.accservice.swtbridge.AccessibleObject;
import org.eclipse.actf.accservice.swtbridge.AccessibleObjectFactory;
import org.eclipse.actf.ui.util.PlatformUIUtil;
import org.eclipse.actf.util.win32.HighlightComposite;
import org.eclipse.actf.visualization.gui.IGuiViewIDs;
import org.eclipse.actf.visualization.gui.internal.util.TargetWindow;
import org.eclipse.actf.visualization.gui.ui.views.IFlashDOMView;
import org.eclipse.actf.visualization.gui.ui.views.IJAWSTextView;
import org.eclipse.actf.visualization.gui.ui.views.IMSAAListView;
import org.eclipse.actf.visualization.gui.ui.views.IMSAAOutlineView;
import org.eclipse.actf.visualization.gui.ui.views.IMSAAProblemsView;
import org.eclipse.actf.visualization.gui.ui.views.IMSAAPropertiesView;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.views.properties.PropertySheet;

public class MSAAViewRegistory
implements IGuiViewIDs {
    public static AccessibleObject rootObject = null;
    public static AccessibleObject outlineObject = null;
    private static int updateRef = 0;
    private static final Display display = Display.getCurrent();
    private static int hwndRoot = 0;
    private static IPartListener2 partListener = new IPartListener2(){

        public void partActivated(IWorkbenchPartReference iWorkbenchPartReference) {
            int n;
            if (iWorkbenchPartReference instanceof IEditorReference && TargetWindow.isEmbeddedBrowser() && (n = TargetWindow.getRootWindow()) != hwndRoot) {
                display.timerExec("Web Browser".equals(iWorkbenchPartReference.getPartName()) ? 3000 : 0, new Runnable(){

                    public void run() {
                        if (!display.isDisposed() && n != hwndRoot) {
                            MSAAViewRegistory.refreshRootObject();
                        }
                    }
                });
            }
        }

        public void partBroughtToTop(IWorkbenchPartReference iWorkbenchPartReference) {
        }

        public void partClosed(IWorkbenchPartReference iWorkbenchPartReference) {
        }

        public void partDeactivated(IWorkbenchPartReference iWorkbenchPartReference) {
        }

        public void partHidden(IWorkbenchPartReference iWorkbenchPartReference) {
        }

        public void partInputChanged(IWorkbenchPartReference iWorkbenchPartReference) {
        }

        public void partOpened(IWorkbenchPartReference iWorkbenchPartReference) {
        }

        public void partVisible(IWorkbenchPartReference iWorkbenchPartReference) {
        }
    };
    private static boolean partListening = false;

    public static void outlineSelected(Object object) {
        MSAAViewRegistory.addUpdateRef();
        try {
            object = MSAAViewRegistory.adjustSelection(object);
            if (object instanceof AccessibleObject) {
                IJAWSTextView iJAWSTextView;
                outlineObject = (AccessibleObject)object;
                MSAAViewRegistory.showProperties(outlineObject);
                IMSAAListView iMSAAListView = (IMSAAListView)MSAAViewRegistory.findView(ID_SIBLINGSVIEW);
                if (iMSAAListView != null) {
                    iMSAAListView.setSelection(outlineObject);
                }
                if ((iJAWSTextView = (IJAWSTextView)MSAAViewRegistory.findView(ID_SUMMARYVIEW)) != null) {
                    iJAWSTextView.setSelection(outlineObject);
                }
                HighlightComposite.flashRectangle((Rectangle)outlineObject.getAccLocation());
            }
        }
        finally {
            MSAAViewRegistory.releaseUpdateRef();
        }
    }

    public static boolean showProperties(Object object) {
        IViewPart iViewPart;
        boolean bl = false;
        IMSAAPropertiesView iMSAAPropertiesView = (IMSAAPropertiesView)MSAAViewRegistory.findView(ID_PROPERTIESVIEW);
        if (iMSAAPropertiesView != null) {
            iMSAAPropertiesView.setInput(object);
            bl = true;
        }
        if ((iViewPart = MSAAViewRegistory.findView("org.eclipse.ui.views.PropertySheet")) instanceof PropertySheet) {
            ((PropertySheet)iViewPart).selectionChanged(null, (ISelection)new StructuredSelection(object));
            bl = true;
        }
        return bl;
    }

    public static IViewReference findViewReference(String string) {
        try {
            IWorkbenchPage iWorkbenchPage = PlatformUIUtil.getActivePage();
            if (iWorkbenchPage != null) {
                return iWorkbenchPage.findViewReference(string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    public static IViewPart findView(String string) {
        try {
            IViewReference iViewReference = MSAAViewRegistory.findViewReference(string);
            if (iViewReference != null) {
                return iViewReference.getView(false);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    public static IViewPart showView(String string, boolean bl) {
        try {
            IWorkbenchPage iWorkbenchPage = PlatformUIUtil.getActivePage();
            if (iWorkbenchPage != null) {
                IViewPart iViewPart = iWorkbenchPage.findView(string);
                if (iViewPart != null) {
                    if (bl) {
                        iWorkbenchPage.activate((IWorkbenchPart)iViewPart);
                    }
                    return iViewPart;
                }
                return iWorkbenchPage.showView(string, null, bl ? 1 : 3);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    public static void hideView(String string) {
        try {
            IViewPart iViewPart;
            IWorkbenchPage iWorkbenchPage = PlatformUIUtil.getActivePage();
            if (iWorkbenchPage != null && (iViewPart = iWorkbenchPage.findView(string)) != null) {
                iWorkbenchPage.hideView(iViewPart);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static AccessibleObject getRootObject() {
        if (rootObject == null && (hwndRoot = TargetWindow.getRootWindow()) != 0) {
            rootObject = AccessibleObjectFactory.getAccessibleObjectFromWindow(hwndRoot);
        }
        if (!partListening) {
            IWorkbenchPage iWorkbenchPage = PlatformUIUtil.getActivePage();
            iWorkbenchPage.addPartListener(partListener);
            partListening = true;
        }
        return rootObject;
    }

    public static void refreshRootObject() {
        MSAAViewRegistory.addUpdateRef();
        HighlightComposite.updateSuppressCount((int)1);
        try {
            IJAWSTextView iJAWSTextView;
            IMSAAProblemsView iMSAAProblemsView;
            IFlashDOMView iFlashDOMView;
            IMSAAOutlineView iMSAAOutlineView;
            if (rootObject != null) {
                rootObject.reset();
                rootObject = null;
            }
            if ((iMSAAOutlineView = (IMSAAOutlineView)MSAAViewRegistory.findView(ID_OUTLINEVIEW)) != null) {
                iMSAAOutlineView.refresh();
            }
            if ((iFlashDOMView = (IFlashDOMView)MSAAViewRegistory.findView("org.eclipse.actf.visualization.flash.ui.views.FlashDOMView")) != null) {
                iFlashDOMView.refresh();
            }
            if ((iMSAAProblemsView = (IMSAAProblemsView)MSAAViewRegistory.findView(ID_REPORTVIEW)) != null) {
                iMSAAProblemsView.refresh();
            }
            if ((iJAWSTextView = (IJAWSTextView)MSAAViewRegistory.findView(ID_SUMMARYVIEW)) != null) {
                iJAWSTextView.refresh();
            }
            MSAAViewRegistory.outlineSelected(null);
        }
        finally {
            HighlightComposite.updateSuppressCount((int)-1);
            MSAAViewRegistory.releaseUpdateRef();
        }
    }

    public static AccessibleObject adjustSelection(Object object) {
        AccessibleObject[] accessibleObjectArray;
        MSAAViewRegistory.getRootObject();
        if (object instanceof AccessibleObject && object != rootObject) {
            return (AccessibleObject)object;
        }
        if (rootObject != null && (accessibleObjectArray = rootObject.getChildren()) != null && accessibleObjectArray.length > 0) {
            return accessibleObjectArray[0];
        }
        return rootObject;
    }

    public static int addUpdateRef() {
        return ++updateRef;
    }

    public static int releaseUpdateRef() {
        return --updateRef;
    }

    public static int getUpdateRef() {
        return updateRef;
    }
}

