/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.blind;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.eclipse.actf.util.FileUtils;
import org.eclipse.actf.visualization.engines.blind.BlindVizResourceUtil;
import org.eclipse.actf.visualization.engines.blind.TextChecker;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class BlindVizEnginePlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.actf.visualization.engines.blind";
    private static BlindVizEnginePlugin plugin;
    private static File tmpDir;

    static {
        tmpDir = null;
    }

    public BlindVizEnginePlugin() {
        plugin = this;
    }

    public void start(BundleContext bundleContext) throws Exception {
        String string;
        super.start(bundleContext);
        if (!this.getPreferenceStore().getBoolean("blindViz.not_first_time")) {
            TextChecker.getInstance();
        }
        BlindVizEnginePlugin.createTempDirectory();
        if (tmpDir != null && FileUtils.isAvailableDirectory((String)(string = String.valueOf(tmpDir.getAbsolutePath()) + File.separator + "img"))) {
            String string2 = String.valueOf(string) + File.separator;
            BlindVizResourceUtil.saveImages(string2);
            BlindVizResourceUtil.saveScripts(string2);
        }
    }

    public void stop(BundleContext bundleContext) throws Exception {
        this.getPreferenceStore().setValue("blindViz.not_first_time", true);
        plugin = null;
        super.stop(bundleContext);
        this.deleteFiles(tmpDir);
    }

    public static BlindVizEnginePlugin getDefault() {
        return plugin;
    }

    public String getConfigDir() {
        try {
            URL uRL = plugin.getBundle().getEntry("config");
            uRL = FileLocator.resolve((URL)uRL);
            return new Path(uRL.getPath()).makeAbsolute().toOSString();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return "";
        }
    }

    private static void createTempDirectory() {
        if (tmpDir == null) {
            String string = String.valueOf(plugin.getStateLocation().toOSString()) + File.separator + "tmp";
            if (FileUtils.isAvailableDirectory((String)string)) {
                tmpDir = new File(string);
            } else {
                System.err.println("org.eclipse.actf.visualization.engines.blind : can't create tmp Directory");
                tmpDir = new File(System.getProperty("java.io.tmpdir"));
            }
        }
    }

    public static File createTempFile(String string, String string2) throws Exception {
        BlindVizEnginePlugin.createTempDirectory();
        return File.createTempFile(string, string2, tmpDir);
    }

    public static File getTempDirectory() {
        if (tmpDir == null) {
            BlindVizEnginePlugin.createTempDirectory();
        }
        return tmpDir;
    }

    private void deleteFiles(File file) {
        if (file != null) {
            File[] fileArray = file.listFiles();
            int n = 0;
            while (n < fileArray.length) {
                if (fileArray[n].isDirectory()) {
                    this.deleteFiles(fileArray[n]);
                }
                fileArray[n].delete();
                ++n;
            }
        }
    }
}

