/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.engines.lowvision;

import org.eclipse.actf.visualization.engines.lowvision.LowVisionException;
import org.eclipse.actf.visualization.internal.engines.lowvision.operator.CVDOp;
import org.eclipse.actf.visualization.internal.engines.lowvision.operator.ColorFilterOp;
import org.eclipse.actf.visualization.internal.engines.lowvision.operator.GlareOp;

public class LowVisionType {
    public static final int CVD_PROTAN = 1;
    public static final int CVD_DEUTAN = 2;
    public static final int CVD_TRITAN = 3;
    private static final double EYESIGHT_DEGREE_MARGIN = 0.1;
    private final int DISPLAY_RESOLUTION = 1024;
    private final double DISPLAY_HEIGHT = 20.8;
    private final double EYE_DISPLAY_DISTANCE = 30.0;
    private boolean eyesight = false;
    private float eyesightDegree;
    private int eyesightRadius;
    private double eyesightPixel;
    private double eyesightLength;
    private boolean CVD = false;
    private int CVDType;
    private boolean colorFilter = false;
    private float colorFilterR;
    private float colorFilterG;
    private float colorFilterB;
    private boolean glare = false;
    private float glareDegree = 0.0f;
    private int displayResolution = 1024;
    private double displayHeight = 20.8;
    private double eyeDisplayDistance = 30.0;

    public boolean doEyesight() {
        return this.eyesight;
    }

    public void setEyesight(boolean bl) {
        this.eyesight = bl;
    }

    public float getEyesightDegree() {
        return this.eyesightDegree;
    }

    public void setEyesightDegree(float f) throws LowVisionException {
        if ((double)f <= 0.0) {
            throw new LowVisionException("Eyesight degree must be positive.");
        }
        this.eyesightDegree = f;
        this.eyesightPixel = this.calcUndistinguishablePixel(this.eyesightDegree);
        this.eyesightRadius = this.calcRadius(this.eyesightPixel);
        this.eyesightLength = this.calcUndistinguishableLength(this.eyesightDegree);
    }

    public double getEyesightPixel() {
        return this.eyesightPixel;
    }

    public int getEyesightRadius() {
        return this.eyesightRadius;
    }

    public double getEyesightLength() {
        return this.eyesightLength;
    }

    private double calcUndistinguishablePixel(double d) {
        double d2 = d + 0.1;
        double d3 = 1.0 / d2;
        double d4 = d3 * Math.PI / 10800.0;
        return 2.0 * Math.tan(d4 / 2.0) * (double)this.displayResolution * this.eyeDisplayDistance / this.displayHeight;
    }

    private int calcRadius(double d) {
        return (int)Math.ceil(d);
    }

    private double calcUndistinguishableLength(double d) {
        double d2 = d + 0.1;
        double d3 = 1.0 / d2;
        double d4 = d3 * Math.PI / 10800.0;
        return 20.0 * Math.tan(d4 / 2.0) * this.eyeDisplayDistance;
    }

    public boolean doCVD() {
        return this.CVD;
    }

    public void setCVD(boolean bl) {
        this.CVD = bl;
    }

    public int getCVDType() {
        return this.CVDType;
    }

    public void setCVDType(int n) throws LowVisionException {
        if (n != 1 && n != 2 && n != 3) {
            throw new LowVisionException("CVD type must be 1,2, or 3");
        }
        this.CVDType = n;
    }

    public boolean doColorFilter() {
        return this.colorFilter;
    }

    public void setColorFilter(boolean bl) {
        this.colorFilter = bl;
    }

    public float[] getColorFilterRGB() {
        float[] fArray = new float[]{this.colorFilterR, this.colorFilterG, this.colorFilterB};
        return fArray;
    }

    private void setColorFilterRGB(float f, float f2, float f3) throws LowVisionException {
        if ((double)f < 0.0 || 1.0 < (double)f) {
            throw new LowVisionException("Value of R(" + f + ") is out of range.");
        }
        this.colorFilterR = f;
        if ((double)f2 < 0.0 || 1.0 < (double)f2) {
            throw new LowVisionException("Value of G(" + f2 + ") is out of range.");
        }
        this.colorFilterG = f2;
        if ((double)f3 < 0.0 || 1.0 < (double)f3) {
            throw new LowVisionException("Value of B(" + f3 + ") is out of range.");
        }
        this.colorFilterB = f3;
    }

    public void setColorFilterDegree(float f) throws LowVisionException {
        float f2 = f;
        float f3 = 1.0f - (1.0f - f2) / 2.0f;
        this.setColorFilterRGB(f3, f3, f2);
    }

    public boolean doGlare() {
        return this.glare;
    }

    public void setGlare(boolean bl) {
        this.glare = bl;
    }

    public float getGlareDegree() {
        return this.glareDegree;
    }

    public void setGlareDegree(float f) {
        this.glareDegree = f;
    }

    public int countTypes() {
        int n = 0;
        if (this.eyesight) {
            ++n;
        }
        if (this.CVD) {
            ++n;
        }
        if (this.colorFilter) {
            ++n;
        }
        if (this.glare) {
            ++n;
        }
        return n;
    }

    public boolean doBlur() {
        return this.eyesight;
    }

    public boolean doChangeColors() {
        return this.CVD || this.colorFilter || this.glare;
    }

    public int convertColor(int n) throws LowVisionException {
        int n2 = n;
        if (this.colorFilter) {
            n2 = ColorFilterOp.convertColor(n2, this.colorFilterR, this.colorFilterG, this.colorFilterB);
        }
        if (this.glare) {
            n2 = GlareOp.convertColor(n2, this.glareDegree);
        }
        if (this.CVD) {
            n2 = CVDOp.convertColor(n2, this.CVDType);
        }
        return n2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.eyesight) {
            stringBuffer.append("Eyesight:on Degree=");
            stringBuffer.append("" + this.eyesightDegree);
        } else {
            stringBuffer.append("Eyesight:off,");
        }
        if (this.CVD) {
            stringBuffer.append("  CVD:on Type=" + this.CVDType + ",");
        } else {
            stringBuffer.append("  CVD: off,");
        }
        if (this.colorFilter) {
            stringBuffer.append("  ColorFilter:on Degree=" + this.colorFilterB);
        } else {
            stringBuffer.append("  ColorFilter:off");
        }
        return stringBuffer.toString();
    }

    public double getDisplayHeight() {
        return this.displayHeight;
    }

    public int getDisplayResolution() {
        return this.displayResolution;
    }

    public double getEyeDisplayDistance() {
        return this.eyeDisplayDistance;
    }

    public void setDisplayHeight(double d) {
        this.displayHeight = d;
    }

    public void setDisplayResolution(int n) {
        this.displayResolution = n;
    }

    public void setEyeDisplayDistance(double d) {
        this.eyeDisplayDistance = d;
    }
}

