/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.lowvision.checker;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Stack;
import java.util.Vector;
import org.eclipse.actf.visualization.engines.lowvision.LowVisionType;
import org.eclipse.actf.visualization.engines.lowvision.image.ImageException;
import org.eclipse.actf.visualization.internal.engines.lowvision.DecisionMaker;
import org.eclipse.actf.visualization.internal.engines.lowvision.character.CharacterMS;
import org.eclipse.actf.visualization.internal.engines.lowvision.character.CharacterSM;
import org.eclipse.actf.visualization.internal.engines.lowvision.character.CharacterSS;
import org.eclipse.actf.visualization.internal.engines.lowvision.checker.W3CColorChecker;
import org.eclipse.actf.visualization.internal.engines.lowvision.color.ColorIRGB;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.BinaryImage;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.ConnectedComponent;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.Container;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.IInt2D;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.Int2D;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.PageImage;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.Topology;
import org.eclipse.actf.visualization.internal.engines.lowvision.operator.LowVisionFilter;
import org.eclipse.actf.visualization.internal.engines.lowvision.problem.BlurProblem;
import org.eclipse.actf.visualization.internal.engines.lowvision.problem.ColorProblem;
import org.eclipse.actf.visualization.internal.engines.lowvision.problem.LowVisionProblem;
import org.eclipse.actf.visualization.internal.engines.lowvision.problem.LowVisionProblemException;
import org.eclipse.actf.visualization.internal.engines.lowvision.problem.LowVisionProblemGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CharacterChecker {
    public static final double THRESHOLD_MIN_SM_COLOR_PROBLEM_RATIO = 0.8;
    private PageImage pageImage;

    public CharacterChecker(PageImage pageImage) {
        this.pageImage = pageImage;
    }

    public LowVisionProblemGroup[] checkAllCharacters(LowVisionType lowVisionType) throws ImageException, LowVisionProblemException {
        Object object;
        if (lowVisionType.countTypes() == 0) {
            return new LowVisionProblemGroup[0];
        }
        Vector<LowVisionProblem> vector = new Vector<LowVisionProblem>();
        int n = 0;
        while (n < this.pageImage.getNumContainers()) {
            LowVisionProblem lowVisionProblem;
            Container container = this.pageImage.getContainers()[n];
            object = new Vector();
            int n2 = 0;
            while (n2 < container.getNumSSCharacters()) {
                lowVisionProblem = this.checkOneSSCharacter(container.getSsCharacters()[n2], lowVisionType);
                if (lowVisionProblem != null) {
                    ((Vector)object).addElement(lowVisionProblem);
                }
                ++n2;
            }
            n2 = 0;
            while (n2 < container.getNumMSCharacters()) {
                lowVisionProblem = this.checkOneMSCharacter(container.getMsCharacters()[n2], lowVisionType);
                if (lowVisionProblem != null) {
                    ((Vector)object).addElement(lowVisionProblem);
                }
                ++n2;
            }
            n2 = 0;
            while (n2 < container.getNumSMCharacters()) {
                lowVisionProblem = this.checkOneSMCharacter(container.getSmCharacters()[n2], lowVisionType);
                if (lowVisionProblem != null) {
                    ((Vector)object).addElement(lowVisionProblem);
                }
                ++n2;
            }
            Vector<LowVisionProblemGroup> vector2 = this.collectProblems((Vector<LowVisionProblem>)object);
            if (vector2 != null) {
                int n3 = vector2.size();
                int n4 = 0;
                while (n4 < n3) {
                    vector.addElement(vector2.elementAt(n4));
                    ++n4;
                }
            }
            ++n;
        }
        Vector<LowVisionProblem> vector3 = new Vector<LowVisionProblem>();
        int n5 = 0;
        while (n5 < this.pageImage.getNumNonContainedCharacters()) {
            object = this.checkOneSMCharacter(this.pageImage.getNonContainedCharacters()[n5], lowVisionType);
            if (object != null) {
                vector3.addElement((LowVisionProblem)object);
            }
            ++n5;
        }
        Vector<LowVisionProblemGroup> vector4 = this.collectProblems(vector3);
        if (vector4 != null) {
            int n6 = vector4.size();
            int n7 = 0;
            while (n7 < n6) {
                vector.addElement(vector4.elementAt(n7));
                ++n7;
            }
        }
        Collections.sort(vector, new CompareByPriority());
        LowVisionProblemGroup[] lowVisionProblemGroupArray = null;
        int n8 = vector.size();
        if (n8 > 0) {
            lowVisionProblemGroupArray = new LowVisionProblemGroup[n8];
            int n9 = 0;
            while (n9 < n8) {
                lowVisionProblemGroupArray[n9] = (LowVisionProblemGroup)vector.elementAt(n9);
                ++n9;
            }
            vector.removeAllElements();
            return lowVisionProblemGroupArray;
        }
        return new LowVisionProblemGroup[0];
    }

    private LowVisionProblem simulateAndCheckMSCharacter(CharacterMS characterMS, LowVisionType lowVisionType, int n) throws ImageException, LowVisionProblemException {
        ConnectedComponent connectedComponent;
        Object object;
        int n2;
        int n3;
        if (!lowVisionType.doBlur()) {
            return null;
        }
        int n4 = 0;
        if (lowVisionType.doEyesight()) {
            n4 = lowVisionType.getEyesightRadius();
        }
        IInt2D iInt2D = characterMS.makeMarginedImage(n4 * 2);
        LowVisionFilter lowVisionFilter = new LowVisionFilter(lowVisionType);
        Int2D int2D = null;
        try {
            int2D = new Int2D(lowVisionFilter.filter(iInt2D.toBufferedImage(), null));
        }
        catch (Exception exception) {
            throw new ImageException("Error occurred while simulating an MSCharacter.");
        }
        int n5 = int2D.getWidth() - 2 * n4;
        int n6 = int2D.getHeight() - 2 * n4;
        BinaryImage binaryImage = new BinaryImage(n5, n6);
        HashMap<Object, Boolean> hashMap = new HashMap<Object, Boolean>();
        try {
            n3 = 0;
            while (n3 < n6) {
                n2 = 0;
                while (n2 < n5) {
                    int n7 = int2D.getData()[n3 + n4][n2 + n4];
                    if (n7 != n) {
                        object = new Integer(n7);
                        Boolean bl = (Boolean)hashMap.get(object);
                        if (bl == null) {
                            if (DecisionMaker.distinguishableTextColors(n7, n)) {
                                binaryImage.data[n3][n2] = 1;
                                hashMap.put(object, new Boolean(true));
                            } else {
                                hashMap.put(object, new Boolean(false));
                            }
                        } else if (bl.booleanValue()) {
                            binaryImage.data[n3][n2] = 1;
                        }
                    }
                    ++n2;
                }
                ++n3;
            }
        }
        catch (Exception exception) {
            throw new ImageException("Error occurred while making binary image.");
        }
        n3 = characterMS.cc.getLeft() - n4;
        if (n3 < 0) {
            n3 = 0;
        }
        if ((n2 = characterMS.cc.getTop() - n4) < 0) {
            n2 = 0;
        }
        if (((Topology)(object = (connectedComponent = new ConnectedComponent(n3, n2, binaryImage, 2)).thinning().calcTopology())).match(characterMS.getTopology())) {
            return null;
        }
        double d = 1.0;
        if (characterMS.getTopology().getCount() > 0 && (d = (double)Math.abs(characterMS.getTopology().getCount() - ((Topology)object).getCount()) / (double)characterMS.getTopology().getCount()) > 1.0) {
            d = 1.0;
        }
        return new BlurProblem(characterMS, lowVisionType, d);
    }

    private LowVisionProblem simulateAndCheckSMCharacter(CharacterSM characterSM, LowVisionType lowVisionType, int n) throws ImageException, LowVisionProblemException {
        ConnectedComponent connectedComponent;
        Object object;
        int n2;
        int n3;
        if (!lowVisionType.doBlur()) {
            return null;
        }
        int n4 = 0;
        if (lowVisionType.doEyesight()) {
            n4 = lowVisionType.getEyesightRadius();
        }
        IInt2D iInt2D = characterSM.makeMarginedImage(n4 * 2);
        LowVisionFilter lowVisionFilter = new LowVisionFilter(lowVisionType);
        Int2D int2D = null;
        try {
            int2D = new Int2D(lowVisionFilter.filter(iInt2D.toBufferedImage(), null));
        }
        catch (Exception exception) {
            throw new ImageException("Error occurred while simulating an SMCharacter.");
        }
        int n5 = int2D.getWidth() - 2 * n4;
        int n6 = int2D.getHeight() - 2 * n4;
        BinaryImage binaryImage = new BinaryImage(n5, n6);
        HashMap<Object, Boolean> hashMap = new HashMap<Object, Boolean>();
        try {
            n3 = 0;
            while (n3 < n6) {
                n2 = 0;
                while (n2 < n5) {
                    int n7 = int2D.getData()[n3 + n4][n2 + n4];
                    if (n7 == n) {
                        binaryImage.data[n3][n2] = 1;
                    } else {
                        object = new Integer(n7);
                        Boolean bl = (Boolean)hashMap.get(object);
                        if (bl == null) {
                            if (!DecisionMaker.distinguishableTextColors(n7, n)) {
                                binaryImage.data[n3][n2] = 1;
                                hashMap.put(object, new Boolean(false));
                            } else {
                                hashMap.put(object, new Boolean(true));
                            }
                        } else if (!bl.booleanValue()) {
                            binaryImage.data[n3][n2] = 1;
                        }
                    }
                    ++n2;
                }
                ++n3;
            }
        }
        catch (Exception exception) {
            throw new ImageException("Error occurred while making binary image.");
        }
        n3 = characterSM.cc.getLeft() - n4;
        if (n3 < 0) {
            n3 = 0;
        }
        if ((n2 = characterSM.cc.getTop() - n4) < 0) {
            n2 = 0;
        }
        if (((Topology)(object = (connectedComponent = new ConnectedComponent(n3, n2, binaryImage, 2)).thinning().calcTopology())).match(characterSM.getTopology())) {
            return null;
        }
        double d = 1.0;
        if (characterSM.getTopology().getCount() > 0 && (d = (double)Math.abs(characterSM.getTopology().getCount() - ((Topology)object).getCount()) / (double)characterSM.getTopology().getCount()) > 1.0) {
            d = 1.0;
        }
        return new BlurProblem(characterSM, lowVisionType, d);
    }

    private LowVisionProblem simulateAndCheckSSCharacter(CharacterSS characterSS, LowVisionType lowVisionType, int n) throws ImageException, LowVisionProblemException {
        ConnectedComponent connectedComponent;
        Object object;
        int n2;
        int n3;
        int n4 = 0;
        if (lowVisionType.doEyesight()) {
            n4 = lowVisionType.getEyesightRadius();
        }
        IInt2D iInt2D = characterSS.makeMarginedImage(n4 * 2);
        LowVisionFilter lowVisionFilter = new LowVisionFilter(lowVisionType);
        Int2D int2D = null;
        try {
            int2D = new Int2D(lowVisionFilter.filter(iInt2D.toBufferedImage(), null));
        }
        catch (Exception exception) {
            throw new ImageException("Error occurred while simulating an SSCharacter.");
        }
        int n5 = int2D.getWidth() - 2 * n4;
        int n6 = int2D.getHeight() - 2 * n4;
        BinaryImage binaryImage = new BinaryImage(n5, n6);
        HashMap<Object, Boolean> hashMap = new HashMap<Object, Boolean>();
        try {
            n3 = 0;
            while (n3 < n6) {
                n2 = 0;
                while (n2 < n5) {
                    int n7 = int2D.getData()[n3 + n4][n2 + n4];
                    if (n7 != n) {
                        object = new Integer(n7);
                        Boolean bl = (Boolean)hashMap.get(object);
                        if (bl == null) {
                            if (DecisionMaker.distinguishableTextColors(n7, n)) {
                                binaryImage.data[n3][n2] = 1;
                                hashMap.put(object, new Boolean(true));
                            } else {
                                hashMap.put(object, new Boolean(false));
                            }
                        } else if (bl.booleanValue()) {
                            binaryImage.data[n3][n2] = 1;
                        }
                    }
                    ++n2;
                }
                ++n3;
            }
        }
        catch (Exception exception) {
            throw new ImageException("Error occurred while making binary image.");
        }
        n3 = characterSS.cc.getLeft() - n4;
        if (n3 < 0) {
            n3 = 0;
        }
        if ((n2 = characterSS.cc.getTop() - n4) < 0) {
            n2 = 0;
        }
        if (((Topology)(object = (connectedComponent = new ConnectedComponent(n3, n2, binaryImage, 2)).thinning().calcTopology())).match(characterSS.getTopology())) {
            return null;
        }
        double d = 1.0;
        if (characterSS.getTopology().getCount() > 0 && (d = (double)Math.abs(characterSS.getTopology().getCount() - ((Topology)object).getCount()) / (double)characterSS.getTopology().getCount()) > 1.0) {
            d = 1.0;
        }
        return new BlurProblem(characterSS, lowVisionType, d);
    }

    private LowVisionProblem checkOneMSCharacter(CharacterMS characterMS, LowVisionType lowVisionType) throws ImageException, LowVisionProblemException {
        int n = characterMS.getBackgroundColor();
        if (lowVisionType.doChangeColors()) {
            try {
                n = lowVisionType.convertColor(characterMS.getBackgroundColor());
                int n2 = lowVisionType.convertColor(characterMS.getForegroundColor());
                double d = W3CColorChecker.calcSeverity(new ColorIRGB(n2), new ColorIRGB(n));
                if (d > 0.0) {
                    return new ColorProblem(characterMS, lowVisionType, d);
                }
            }
            catch (Exception exception) {}
        }
        if (lowVisionType.doBlur()) {
            return this.simulateAndCheckMSCharacter(characterMS, lowVisionType, n);
        }
        return null;
    }

    private LowVisionProblem checkOneSMCharacter(CharacterSM characterSM, LowVisionType lowVisionType) throws ImageException, LowVisionProblemException {
        int n = characterSM.getForegroundColor();
        if (lowVisionType.doChangeColors()) {
            try {
                n = lowVisionType.convertColor(characterSM.getForegroundColor());
                int n2 = 0;
                int n3 = characterSM.getWidth();
                int n4 = characterSM.getHeight();
                int[][] nArray = characterSM.getImage();
                byte[][] byArray = characterSM.cc.getShape().getData();
                HashMap<Integer, Boolean> hashMap = new HashMap<Integer, Boolean>();
                int n5 = 0;
                while (n5 < n4) {
                    int n6 = 0;
                    while (n6 < n3) {
                        if (byArray[n5][n6] == 0) {
                            int n7 = lowVisionType.convertColor(nArray[n5][n6]);
                            Integer n8 = new Integer(n7);
                            Boolean bl = (Boolean)hashMap.get(n8);
                            if (bl == null) {
                                if (!DecisionMaker.distinguishableTextColors(n, n7)) {
                                    ++n2;
                                    hashMap.put(n8, new Boolean(false));
                                } else {
                                    hashMap.put(n8, new Boolean(true));
                                }
                            } else if (!bl.booleanValue()) {
                                ++n2;
                            }
                        }
                        ++n6;
                    }
                    ++n5;
                }
                double d = (double)n2 / (double)(n3 * n4 - characterSM.cc.getCount());
                if (d >= 0.8) {
                    double d2 = (d - 0.8) / 0.19999999999999996;
                    return new ColorProblem(characterSM, lowVisionType, d2);
                }
            }
            catch (Exception exception) {}
        }
        if (lowVisionType.doBlur()) {
            return this.simulateAndCheckSMCharacter(characterSM, lowVisionType, n);
        }
        return null;
    }

    private LowVisionProblem checkOneSSCharacter(CharacterSS characterSS, LowVisionType lowVisionType) throws ImageException, LowVisionProblemException {
        int n = characterSS.getBackgroundColor();
        if (lowVisionType.doChangeColors()) {
            try {
                int n2 = lowVisionType.convertColor(characterSS.getForegroundColor());
                n = lowVisionType.convertColor(characterSS.getBackgroundColor());
                double d = W3CColorChecker.calcSeverity(new ColorIRGB(n2), new ColorIRGB(n));
                if (d > 0.0) {
                    return new ColorProblem(characterSS, lowVisionType, d);
                }
            }
            catch (Exception exception) {
                throw new ImageException("An error occurred while checking colors of an SSCharacter.");
            }
        }
        if (lowVisionType.doBlur()) {
            return this.simulateAndCheckSSCharacter(characterSS, lowVisionType, n);
        }
        return null;
    }

    private Vector<LowVisionProblemGroup> collectProblems(Vector<LowVisionProblem> vector) throws ImageException {
        int n = vector.size();
        if (n == 0) {
            return null;
        }
        int[] nArray = new int[n];
        int n2 = 1;
        int n3 = 0;
        while (n3 < n) {
            LowVisionProblem lowVisionProblem = vector.elementAt(n3);
            if (nArray[n3] == 0) {
                nArray[n3] = n2;
                this.assignProblemGroupID(lowVisionProblem, n2, vector, n, nArray);
                ++n2;
            }
            ++n3;
        }
        Vector<LowVisionProblemGroup> vector2 = new Vector<LowVisionProblemGroup>();
        int n4 = 1;
        while (n4 < n2) {
            this.makeProblemGroupByID(vector2, n4, vector, n, nArray);
            ++n4;
        }
        return vector2;
    }

    private void assignProblemGroupID(LowVisionProblem lowVisionProblem, int n, Vector<LowVisionProblem> vector, int n2, int[] nArray) throws ImageException {
        try {
            Stack<LowVisionProblem> stack = new Stack<LowVisionProblem>();
            stack.push(lowVisionProblem);
            while (!stack.empty()) {
                LowVisionProblem lowVisionProblem2 = (LowVisionProblem)stack.pop();
                int n3 = 0;
                while (n3 < n2) {
                    LowVisionProblem lowVisionProblem3;
                    if (nArray[n3] == 0 && DecisionMaker.areSameGroupProblems(lowVisionProblem2, lowVisionProblem3 = vector.elementAt(n3))) {
                        nArray[n3] = n;
                        stack.push(lowVisionProblem3);
                    }
                    ++n3;
                }
            }
        }
        catch (LowVisionProblemException lowVisionProblemException) {
            throw new ImageException("Error occurred while making problem group.");
        }
    }

    private void makeProblemGroupByID(Vector<LowVisionProblemGroup> vector, int n, Vector<LowVisionProblem> vector2, int n2, int[] nArray) throws ImageException {
        LowVisionProblem lowVisionProblem;
        Vector<LowVisionProblem> vector3 = new Vector<LowVisionProblem>();
        int n3 = 0;
        while (n3 < n2) {
            if (nArray[n3] == n) {
                lowVisionProblem = vector2.elementAt(n3);
                vector3.addElement(lowVisionProblem);
            }
            ++n3;
        }
        n3 = vector3.size();
        if (n3 <= 0) {
            throw new ImageException("No instance belongs to the group. id = " + n);
        }
        lowVisionProblem = null;
        try {
            lowVisionProblem = new LowVisionProblemGroup(vector3);
        }
        catch (LowVisionProblemException lowVisionProblemException) {
            throw new ImageException("LowVisionProblemGroup cannot be constracted.");
        }
        vector.addElement((LowVisionProblemGroup)lowVisionProblem);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CompareByPriority
    implements Comparator<LowVisionProblem> {
        private CompareByPriority() {
        }

        @Override
        public int compare(LowVisionProblem lowVisionProblem, LowVisionProblem lowVisionProblem2) {
            return lowVisionProblem2.getPriority() - lowVisionProblem.getPriority();
        }
    }
}

