/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.lowvision.color;

import java.io.PrintStream;
import java.io.PrintWriter;
import org.eclipse.actf.visualization.internal.engines.lowvision.color.ColorIRGB;

public class ColorUtil {
    private static final String[] predefinedColors = new String[]{"black", "#000000", "silver", "#c0c0c0", "gray", "#808080", "grey", "#808080", "white", "#ffffff", "maroon", "#800000", "red", "#ff0000", "purple", "#800080", "fuchsia", "#ff00ff", "green", "#008000", "lime", "#00ff00", "olive", "#808000", "yellow", "#ffff00", "navy", "#000080", "blue", "#0000ff", "teal", "#008080", "aqua", "#00ffff"};
    private static final int numPredefinedColors = predefinedColors.length / 2;

    public static boolean isPredefinedColor(String string) {
        String string2 = string.toLowerCase();
        int n = 0;
        while (n < numPredefinedColors) {
            if (predefinedColors[n * 2].equals(string2)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static String predefinedColor2Pound(String string) {
        String string2 = string.toLowerCase();
        int n = 0;
        while (n < numPredefinedColors) {
            if (predefinedColors[n * 2].equals(string2)) {
                return predefinedColors[n * 2 + 1];
            }
            ++n;
        }
        return null;
    }

    public static int[] intToRGB(int n) {
        int[] nArray = new int[]{n >> 16 & 0xFF, n >> 8 & 0xFF, n & 0xFF};
        return nArray;
    }

    public static int RGBToInt(int n, int n2, int n3) {
        return (n & 0xFF) << 16 | (n2 & 0xFF) << 8 | n3 & 0xFF;
    }

    public static void dumpColor(PrintStream printStream, int n) {
        new ColorIRGB(n).dump(printStream);
    }

    public static void dumpColor(PrintWriter printWriter, int n) {
        new ColorIRGB(n).dump(printWriter);
    }

    public static int distinguishableColor(int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (n == 0) {
            return 0xFFFFFF;
        }
        int n5 = 0;
        while (n5 < 8) {
            n2 += (n >> n5 * 3 & 1) << 7 - n5;
            n3 += (n >> n5 * 3 + 1 & 1) << 7 - n5;
            n4 += (n >> n5 * 3 + 2 & 1) << 7 - n5;
            ++n5;
        }
        return n2 << 16 | n3 << 8 | n4;
    }
}

