/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.examples.adesigner.eval.odf;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.actf.model.dom.odf.ODFConstants;
import org.eclipse.actf.model.dom.odf.base.ContentBaseElement;
import org.eclipse.actf.model.dom.odf.base.DrawingObjectElement;
import org.eclipse.actf.model.dom.odf.base.EmbedDrawingObjectElement;
import org.eclipse.actf.model.dom.odf.base.ODFDocument;
import org.eclipse.actf.model.dom.odf.base.ODFElement;
import org.eclipse.actf.model.dom.odf.dr3d.SceneElement;
import org.eclipse.actf.model.dom.odf.draw.CaptionElement;
import org.eclipse.actf.model.dom.odf.draw.CircleElement;
import org.eclipse.actf.model.dom.odf.draw.ConnectorElement;
import org.eclipse.actf.model.dom.odf.draw.ControlElement;
import org.eclipse.actf.model.dom.odf.draw.CustomShapeElement;
import org.eclipse.actf.model.dom.odf.draw.EllipseElement;
import org.eclipse.actf.model.dom.odf.draw.FrameElement;
import org.eclipse.actf.model.dom.odf.draw.GElement;
import org.eclipse.actf.model.dom.odf.draw.ImageElement;
import org.eclipse.actf.model.dom.odf.draw.ImageMapAreaElement;
import org.eclipse.actf.model.dom.odf.draw.ImageMapElement;
import org.eclipse.actf.model.dom.odf.draw.LineElement;
import org.eclipse.actf.model.dom.odf.draw.MeasureElement;
import org.eclipse.actf.model.dom.odf.draw.ObjectElement;
import org.eclipse.actf.model.dom.odf.draw.PageElement;
import org.eclipse.actf.model.dom.odf.draw.PageThumbnailElement;
import org.eclipse.actf.model.dom.odf.draw.PathElement;
import org.eclipse.actf.model.dom.odf.draw.PolygonElement;
import org.eclipse.actf.model.dom.odf.draw.PolylineElement;
import org.eclipse.actf.model.dom.odf.draw.RectElement;
import org.eclipse.actf.model.dom.odf.draw.RegularPolygonElement;
import org.eclipse.actf.model.dom.odf.draw.TextBoxElement;
import org.eclipse.actf.model.dom.odf.form.FormControlElement;
import org.eclipse.actf.model.dom.odf.office.BodyElement;
import org.eclipse.actf.model.dom.odf.office.DocumentContentElement;
import org.eclipse.actf.model.dom.odf.office.DrawingElement;
import org.eclipse.actf.model.dom.odf.office.PresentationElement;
import org.eclipse.actf.model.dom.odf.office.SpreadSheetElement;
import org.eclipse.actf.model.dom.odf.office.TextElement;
import org.eclipse.actf.model.dom.odf.table.TableElement;
import org.eclipse.actf.model.dom.odf.text.AElement;
import org.eclipse.actf.model.dom.odf.text.TrackedChangesElement;
import org.eclipse.actf.util.xpath.XPathService;
import org.eclipse.actf.util.xpath.XPathServiceFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OdfCheckerUtil {
    private static OdfCheckerUtil instance = null;
    private double odfVersion = -1.0;
    private XPathService xpathService = XPathServiceFactory.newService();
    private Object exp1 = this.xpathService.compile(".//*[namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:drawing:1.0' and local-name()='frame']/*[1][(namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:drawing:1.0' and local-name()='object') or (namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:drawing:1.0' and local-name()='object-ole')]");
    private Object exp2 = this.xpathService.compile(".//*[namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:drawing:1.0' and local-name()='frame']/*[1][(namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:drawing:1.0' and local-name()='object') or (namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:drawing:1.0' and local-name()='object-ole')]");
    private Object exp3 = this.xpathService.compile(".//*[namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:drawing:1.0' and local-name()='frame']/*[1][namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:drawing:1.0' and local-name()='image']");
    private Object exp4 = this.xpathService.compile(".//*[namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:drawing:1.0' and local-name()='frame']/*[1][namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:drawing:1.0' and local-name()='image']");
    private Object exp5 = this.xpathService.compile("./descendant::*[(namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:table:1.0' and local-name()='table-cell')]/*[(namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:drawing:1.0' and local-name()='rect') or(namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:drawing:1.0' and local-name()='line') or(namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:drawing:1.0' and local-name()='polyline') or(namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:drawing:1.0' and local-name()='polygon') or(namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:drawing:1.0' and local-name()='regular-polygon') or(namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:drawing:1.0' and local-name()='path') or(namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:drawing:1.0' and local-name()='circle') or(namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:drawing:1.0' and local-name()='ellipse') or(namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:drawing:1.0' and local-name()='g') or(namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:drawing:1.0' and local-name()='page-thumbnail') or(namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:drawing:1.0' and local-name()='measure') or(namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:drawing:1.0' and local-name()='caption') or(namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:drawing:1.0' and local-name()='connector') or(namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:drawing:1.0' and local-name()='custom-shape') or(namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:dr3d:1.0' and local-name()='scene')][parent::*[namespace-uri()!='urn:oasis:names:tc:opendocument:xmlns:drawing:1.0' or local-name()!='g']]");
    private Object exp6 = this.xpathService.compile(".//*[(namespace-uri()!='urn:oasis:names:tc:opendocument:xmlns:table:1.0' or local-name()!='table-cell') and (namespace-uri()!='urn:oasis:names:tc:opendocument:xmlns:table:1.0' or local-name()!='covered-table-cell')]/*[namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:table:1.0' and local-name()='table']");
    private Object exp7 = this.xpathService.compile(".//*[(namespace-uri()!='urn:oasis:names:tc:opendocument:xmlns:table:1.0' or local-name()!='table-cell') and (namespace-uri()!='urn:oasis:names:tc:opendocument:xmlns:table:1.0' or local-name()!='covered-table-cell')]/*[namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:table:1.0' and local-name()='table']");
    private Object exp8 = this.xpathService.compile("./descendant::*[(namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:text:1.0' and local-name()='p')]/*[(namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:drawing:1.0' and local-name()='rect') or(namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:drawing:1.0' and local-name()='line') or(namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:drawing:1.0' and local-name()='polyline') or(namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:drawing:1.0' and local-name()='polygon') or(namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:drawing:1.0' and local-name()='regular-polygon') or(namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:drawing:1.0' and local-name()='path') or(namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:drawing:1.0' and local-name()='circle') or(namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:drawing:1.0' and local-name()='ellipse') or(namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:drawing:1.0' and local-name()='g') or(namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:drawing:1.0' and local-name()='page-thumbnail') or(namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:drawing:1.0' and local-name()='measure') or(namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:drawing:1.0' and local-name()='caption') or(namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:drawing:1.0' and local-name()='connector') or(namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:drawing:1.0' and local-name()='custom-shape') or(namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:dr3d:1.0' and local-name()='scene')][parent::*[namespace-uri()!='urn:oasis:names:tc:opendocument:xmlns:drawing:1.0' or local-name()!='g']]");

    private OdfCheckerUtil() {
    }

    public static OdfCheckerUtil getInstance() {
        if (instance == null) {
            instance = new OdfCheckerUtil();
        }
        return instance;
    }

    public void setOdfVersion(double d) {
        this.odfVersion = d;
    }

    private double getOdfVersion(Document document) {
        double d = -1.0;
        if (document instanceof ODFDocument) {
            d = ((ODFDocument)document).getODFVersion();
        }
        return d;
    }

    private boolean isGroupedShape(DrawingObjectElement drawingObjectElement) {
        Node node = drawingObjectElement.getParentNode();
        while (node != null && !(node instanceof BodyElement)) {
            if (node instanceof GElement) {
                return true;
            }
            node = node.getParentNode();
        }
        return false;
    }

    private boolean isTrackedChanges(ODFElement oDFElement) {
        Node node = oDFElement.getParentNode();
        while (node != null && !(node instanceof BodyElement)) {
            if (node instanceof TrackedChangesElement) {
                return true;
            }
            node = node.getParentNode();
        }
        return false;
    }

    private boolean checkImageShortDescError(ImageElement imageElement) {
        FrameElement frameElement = imageElement.getFrameElement();
        if (!this.isGroupedShape((DrawingObjectElement)frameElement)) {
            ODFElement oDFElement = null;
            oDFElement = this.odfVersion != -1.0 ? imageElement.getShortDescElement(this.odfVersion) : imageElement.getShortDescElement();
            if (oDFElement == null) {
                TextBoxElement textBoxElement = null;
                textBoxElement = this.odfVersion != -1.0 ? frameElement.getBoundCaptionTextBoxElement(this.odfVersion) : frameElement.getBoundCaptionTextBoxElement();
                if (textBoxElement == null && !this.isTrackedChanges((ODFElement)imageElement)) {
                    return false;
                }
            }
        }
        return true;
    }

    private List<ImageElement> getImageShortDescError(Element element) {
        ArrayList<ImageElement> arrayList = new ArrayList<ImageElement>();
        NodeList nodeList = this.xpathService.evalForNodeList(this.exp4, (Node)element);
        int n = 0;
        while (n < nodeList.getLength()) {
            ImageElement imageElement = (ImageElement)nodeList.item(n);
            if (!this.checkImageShortDescError(imageElement)) {
                arrayList.add(imageElement);
            }
            ++n;
        }
        return arrayList;
    }

    public List<ImageElement> getImageShortDescError(Document document) {
        BodyElement bodyElement = null;
        Element element = document.getDocumentElement();
        if (element instanceof DocumentContentElement) {
            DocumentContentElement documentContentElement = (DocumentContentElement)element;
            bodyElement = documentContentElement.getBodyElement();
        }
        if (bodyElement == null) {
            return new ArrayList<ImageElement>();
        }
        return this.getImageShortDescError((Element)bodyElement);
    }

    public List<ImageElement> getImageShortDescError(Document document, long l) {
        DocumentContentElement documentContentElement = (DocumentContentElement)document.getDocumentElement();
        ContentBaseElement contentBaseElement = documentContentElement.getBodyElement().getContent();
        ODFConstants.ContentType contentType = contentBaseElement.getContentType();
        if ((contentType == ODFConstants.ContentType.PRESENTATION || contentType == ODFConstants.ContentType.DRAW) && contentBaseElement instanceof DrawingElement) {
            return this.getImageShortDescError((Element)((DrawingElement)contentBaseElement).getPage(l));
        }
        return new ArrayList<ImageElement>();
    }

    private boolean checkImageLongDescError(ImageElement imageElement) {
        FrameElement frameElement = imageElement.getFrameElement();
        if (!this.isGroupedShape((DrawingObjectElement)frameElement)) {
            ODFElement oDFElement = null;
            oDFElement = this.odfVersion != -1.0 ? imageElement.getLongDescElement(this.odfVersion) : imageElement.getLongDescElement();
            if (oDFElement == null && !this.isTrackedChanges((ODFElement)imageElement)) {
                return false;
            }
        }
        return true;
    }

    private List<ImageElement> getImageLongDescError(Element element) {
        ArrayList<ImageElement> arrayList = new ArrayList<ImageElement>();
        NodeList nodeList = this.xpathService.evalForNodeList(this.exp3, (Node)element);
        int n = 0;
        while (n < nodeList.getLength()) {
            ImageElement imageElement = (ImageElement)nodeList.item(n);
            if (!this.checkImageLongDescError(imageElement)) {
                arrayList.add(imageElement);
            }
            ++n;
        }
        return arrayList;
    }

    public List<ImageElement> getImageLongDescError(Document document) {
        if (this.odfVersion != -1.0 ? this.odfVersion < 1.1 : this.getOdfVersion(document) < 1.1) {
            return new ArrayList<ImageElement>();
        }
        BodyElement bodyElement = null;
        Element element = document.getDocumentElement();
        if (element instanceof DocumentContentElement) {
            DocumentContentElement documentContentElement = (DocumentContentElement)element;
            bodyElement = documentContentElement.getBodyElement();
        }
        if (bodyElement == null) {
            return new ArrayList<ImageElement>();
        }
        return this.getImageLongDescError((Element)bodyElement);
    }

    public List<ImageElement> geImageLongDescError(Document document, long l) {
        DocumentContentElement documentContentElement = (DocumentContentElement)document.getDocumentElement();
        ContentBaseElement contentBaseElement = documentContentElement.getBodyElement().getContent();
        ODFConstants.ContentType contentType = contentBaseElement.getContentType();
        if ((contentType == ODFConstants.ContentType.PRESENTATION || contentType == ODFConstants.ContentType.DRAW) && contentBaseElement instanceof DrawingElement) {
            return this.getImageLongDescError((Element)((DrawingElement)contentBaseElement).getPage(l));
        }
        return new ArrayList<ImageElement>();
    }

    private boolean checkTableHeaderError(TableElement tableElement) {
        NodeList nodeList = tableElement.getTableHeaderRows();
        NodeList nodeList2 = tableElement.getTableHeaderColumns();
        return nodeList != null && nodeList.getLength() != 0 || nodeList2 != null && nodeList2.getLength() != 0 || tableElement.getTableRowSize() <= 1 || tableElement.getTableColumnSize() <= 1 || this.isTrackedChanges((ODFElement)tableElement);
    }

    private List<TableElement> getTableHeaderError(Element element) {
        ArrayList<TableElement> arrayList = new ArrayList<TableElement>();
        NodeList nodeList = this.xpathService.evalForNodeList(this.exp7, (Node)element);
        int n = 0;
        while (n < nodeList.getLength()) {
            TableElement tableElement = (TableElement)nodeList.item(n);
            if (!this.checkTableHeaderError(tableElement)) {
                arrayList.add(tableElement);
            }
            ++n;
        }
        return arrayList;
    }

    public List<TableElement> getTableHeaderError(Document document) {
        DocumentContentElement documentContentElement = (DocumentContentElement)document.getDocumentElement();
        ODFConstants.ContentType contentType = documentContentElement.getBodyElement().getContent().getContentType();
        if (contentType != ODFConstants.ContentType.WRITE) {
            return new ArrayList<TableElement>();
        }
        BodyElement bodyElement = documentContentElement.getBodyElement();
        return this.getTableHeaderError((Element)bodyElement);
    }

    private boolean checkTableCaptionError(TableElement tableElement) {
        return tableElement.getTextSequenceElement() != null || this.isTrackedChanges((ODFElement)tableElement);
    }

    private List<TableElement> getTableCaptionError(Element element) {
        ArrayList<TableElement> arrayList = new ArrayList<TableElement>();
        NodeList nodeList = this.xpathService.evalForNodeList(this.exp6, (Node)element);
        int n = 0;
        while (n < nodeList.getLength()) {
            TableElement tableElement = (TableElement)nodeList.item(n);
            if (!this.checkTableCaptionError(tableElement)) {
                arrayList.add(tableElement);
            }
            ++n;
        }
        return arrayList;
    }

    public List<TableElement> getTableCaptionError(Document document) {
        DocumentContentElement documentContentElement = (DocumentContentElement)document.getDocumentElement();
        ODFConstants.ContentType contentType = documentContentElement.getBodyElement().getContent().getContentType();
        if (contentType != ODFConstants.ContentType.WRITE) {
            return new ArrayList<TableElement>();
        }
        BodyElement bodyElement = documentContentElement.getBodyElement();
        return this.getTableCaptionError((Element)bodyElement);
    }

    private boolean checkImageMapShortDescError(ImageMapAreaElement imageMapAreaElement) {
        ODFElement oDFElement = null;
        oDFElement = this.odfVersion != -1.0 ? imageMapAreaElement.getShortDescElement(this.odfVersion) : imageMapAreaElement.getShortDescElement();
        return oDFElement != null || this.isTrackedChanges((ODFElement)imageMapAreaElement);
    }

    private List<ImageMapAreaElement> getImageMapShortDescError(Element element) {
        ArrayList<ImageMapAreaElement> arrayList = new ArrayList<ImageMapAreaElement>();
        NodeList nodeList = element.getElementsByTagNameNS("urn:oasis:names:tc:opendocument:xmlns:drawing:1.0", "image-map");
        int n = 0;
        while (n < nodeList.getLength()) {
            ImageMapElement imageMapElement = (ImageMapElement)nodeList.item(n);
            FrameElement frameElement = imageMapElement.getFrameElement();
            if (!this.isGroupedShape((DrawingObjectElement)frameElement)) {
                NodeList nodeList2 = imageMapElement.getAreaElements();
                int n2 = 0;
                while (n2 < nodeList2.getLength()) {
                    ImageMapAreaElement imageMapAreaElement = (ImageMapAreaElement)nodeList2.item(n2);
                    if (!this.checkImageMapShortDescError(imageMapAreaElement)) {
                        arrayList.add(imageMapAreaElement);
                    }
                    ++n2;
                }
            }
            ++n;
        }
        return arrayList;
    }

    public List<ImageMapAreaElement> getImageMapShortDescError(Document document) {
        return this.getImageMapShortDescError(document.getDocumentElement());
    }

    public List<ImageMapAreaElement> getImageMapShortDescError(Document document, long l) {
        DocumentContentElement documentContentElement = (DocumentContentElement)document.getDocumentElement();
        ContentBaseElement contentBaseElement = documentContentElement.getBodyElement().getContent();
        ODFConstants.ContentType contentType = contentBaseElement.getContentType();
        if ((contentType == ODFConstants.ContentType.PRESENTATION || contentType == ODFConstants.ContentType.DRAW) && contentBaseElement instanceof DrawingElement) {
            return this.getImageMapShortDescError((Element)((DrawingElement)contentBaseElement).getPage(l));
        }
        return new ArrayList<ImageMapAreaElement>();
    }

    private boolean checkImageMapLongDescError(ImageMapAreaElement imageMapAreaElement) {
        ODFElement oDFElement = null;
        oDFElement = this.odfVersion != -1.0 ? imageMapAreaElement.getLongDescElement(this.odfVersion) : imageMapAreaElement.getLongDescElement();
        return oDFElement != null || this.isTrackedChanges((ODFElement)imageMapAreaElement);
    }

    private List<ImageMapAreaElement> getImageMapLongDescError(Element element) {
        ArrayList<ImageMapAreaElement> arrayList = new ArrayList<ImageMapAreaElement>();
        NodeList nodeList = element.getElementsByTagNameNS("urn:oasis:names:tc:opendocument:xmlns:drawing:1.0", "image-map");
        int n = 0;
        while (n < nodeList.getLength()) {
            ImageMapElement imageMapElement = (ImageMapElement)nodeList.item(n);
            FrameElement frameElement = imageMapElement.getFrameElement();
            if (!this.isGroupedShape((DrawingObjectElement)frameElement)) {
                NodeList nodeList2 = imageMapElement.getAreaElements();
                int n2 = 0;
                while (n2 < nodeList2.getLength()) {
                    ImageMapAreaElement imageMapAreaElement = (ImageMapAreaElement)nodeList2.item(n2);
                    if (!this.checkImageMapLongDescError(imageMapAreaElement)) {
                        arrayList.add(imageMapAreaElement);
                    }
                    ++n2;
                }
            }
            ++n;
        }
        return arrayList;
    }

    public List<ImageMapAreaElement> getImageMapLongDescError(Document document) {
        if (this.odfVersion != -1.0 ? this.odfVersion < 1.1 : this.getOdfVersion(document) < 1.1) {
            return new ArrayList<ImageMapAreaElement>();
        }
        return this.getImageMapLongDescError(document.getDocumentElement());
    }

    public List<ImageMapAreaElement> getImageMapLongDescError(Document document, long l) {
        DocumentContentElement documentContentElement = (DocumentContentElement)document.getDocumentElement();
        ContentBaseElement contentBaseElement = documentContentElement.getBodyElement().getContent();
        ODFConstants.ContentType contentType = contentBaseElement.getContentType();
        if ((contentType == ODFConstants.ContentType.PRESENTATION || contentType == ODFConstants.ContentType.DRAW) && contentBaseElement instanceof DrawingElement) {
            return this.getImageMapLongDescError((Element)((DrawingElement)contentBaseElement).getPage(l));
        }
        return new ArrayList<ImageMapAreaElement>();
    }

    private boolean isShapeContainText(DrawingObjectElement drawingObjectElement) {
        if (drawingObjectElement instanceof TextBoxElement) {
            return true;
        }
        if (drawingObjectElement instanceof GElement) {
            return false;
        }
        NodeList nodeList = drawingObjectElement.getElementsByTagNameNS("urn:oasis:names:tc:opendocument:xmlns:text:1.0", "p");
        if (nodeList != null && nodeList.getLength() > 0) {
            int n = 0;
            while (n < nodeList.getLength()) {
                Node node = nodeList.item(n);
                String string = node.getTextContent();
                if (string != null && string.length() > 0) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    private NodeList getWriteDrawingObject(TextElement textElement) {
        return this.xpathService.evalForNodeList(this.exp8, (Node)textElement);
    }

    private NodeList getSpreadsheetDrawingObject(SpreadSheetElement spreadSheetElement) {
        return this.xpathService.evalForNodeList(this.exp5, (Node)spreadSheetElement);
    }

    private boolean checkDrawingObjectShortDesc(DrawingObjectElement drawingObjectElement) {
        if (!(drawingObjectElement instanceof PageThumbnailElement || drawingObjectElement instanceof FrameElement || this.isShapeContainText(drawingObjectElement))) {
            ODFElement oDFElement = null;
            oDFElement = this.odfVersion != -1.0 ? drawingObjectElement.getShortDescElement(this.odfVersion) : drawingObjectElement.getShortDescElement();
            if (oDFElement != null) {
                return true;
            }
            TextBoxElement textBoxElement = null;
            textBoxElement = this.odfVersion != -1.0 ? drawingObjectElement.getBoundCaptionTextBoxElement(this.odfVersion) : drawingObjectElement.getBoundCaptionTextBoxElement();
            if (textBoxElement == null && !this.isTrackedChanges((ODFElement)drawingObjectElement)) {
                return false;
            }
        }
        return true;
    }

    private List<DrawingObjectElement> getDrawingObjectShortDescError(Document document, boolean bl) {
        ArrayList<DrawingObjectElement> arrayList;
        block11: {
            TextElement textElement;
            ODFConstants.ContentType contentType;
            DocumentContentElement documentContentElement;
            block10: {
                arrayList = new ArrayList<DrawingObjectElement>();
                if (this.odfVersion != -1.0 ? this.odfVersion < 1.1 : this.getOdfVersion(document) < 1.1) {
                    return arrayList;
                }
                documentContentElement = (DocumentContentElement)document.getDocumentElement();
                contentType = documentContentElement.getBodyElement().getContent().getContentType();
                if (contentType != ODFConstants.ContentType.PRESENTATION && contentType != ODFConstants.ContentType.DRAW) break block10;
                PresentationElement presentationElement = (PresentationElement)documentContentElement.getBodyElement().getContent();
                int n = 0;
                while ((long)n < presentationElement.getPageSize()) {
                    PageElement pageElement = presentationElement.getPage((long)n);
                    NodeList nodeList = pageElement.getDrawingObjectElements();
                    int n2 = 0;
                    while (n2 < nodeList.getLength()) {
                        DrawingObjectElement drawingObjectElement = (DrawingObjectElement)nodeList.item(n2);
                        if ((bl && drawingObjectElement instanceof GElement || !bl && !(drawingObjectElement instanceof GElement)) && !this.checkDrawingObjectShortDesc(drawingObjectElement)) {
                            arrayList.add(drawingObjectElement);
                        }
                        ++n2;
                    }
                    ++n;
                }
                break block11;
            }
            if (contentType != ODFConstants.ContentType.WRITE && contentType != ODFConstants.ContentType.SPREADSHEET) break block11;
            NodeList nodeList = null;
            if (contentType == ODFConstants.ContentType.WRITE) {
                textElement = (TextElement)documentContentElement.getBodyElement().getContent();
                nodeList = this.getWriteDrawingObject(textElement);
            }
            if (contentType == ODFConstants.ContentType.SPREADSHEET) {
                textElement = (SpreadSheetElement)documentContentElement.getBodyElement().getContent();
                nodeList = this.getSpreadsheetDrawingObject((SpreadSheetElement)textElement);
            }
            if (nodeList != null) {
                int n = 0;
                while (n < nodeList.getLength()) {
                    if (nodeList.item(n) instanceof DrawingObjectElement) {
                        DrawingObjectElement drawingObjectElement = (DrawingObjectElement)nodeList.item(n);
                        if ((bl && drawingObjectElement instanceof GElement || !bl && !(drawingObjectElement instanceof GElement)) && !this.checkDrawingObjectShortDesc(drawingObjectElement)) {
                            arrayList.add(drawingObjectElement);
                        }
                    }
                    ++n;
                }
            }
        }
        return arrayList;
    }

    public List<DrawingObjectElement> getNotGroupDrawingObjectShortDescError(Document document) {
        return this.getDrawingObjectShortDescError(document, false);
    }

    public List<DrawingObjectElement> getGroupObjectShortDescError(Document document) {
        return this.getDrawingObjectShortDescError(document, true);
    }

    private List<DrawingObjectElement> getDrawingObjectShortDescError(Document document, long l, boolean bl) {
        ArrayList<DrawingObjectElement> arrayList = new ArrayList<DrawingObjectElement>();
        DocumentContentElement documentContentElement = (DocumentContentElement)document.getDocumentElement();
        ContentBaseElement contentBaseElement = documentContentElement.getBodyElement().getContent();
        ODFConstants.ContentType contentType = contentBaseElement.getContentType();
        if ((contentType == ODFConstants.ContentType.PRESENTATION || contentType == ODFConstants.ContentType.DRAW) && contentBaseElement instanceof DrawingElement) {
            PageElement pageElement = ((DrawingElement)contentBaseElement).getPage(l);
            NodeList nodeList = pageElement.getDrawingObjectElements();
            int n = 0;
            while (n < nodeList.getLength()) {
                DrawingObjectElement drawingObjectElement = (DrawingObjectElement)nodeList.item(n);
                if ((bl && drawingObjectElement instanceof GElement || !bl && !(drawingObjectElement instanceof GElement)) && !this.checkDrawingObjectShortDesc(drawingObjectElement)) {
                    arrayList.add(drawingObjectElement);
                }
                ++n;
            }
        }
        return arrayList;
    }

    public List<DrawingObjectElement> getNotGroupDrawingObjectShortDescError(Document document, long l) {
        return this.getDrawingObjectShortDescError(document, l, false);
    }

    public List<DrawingObjectElement> getGroupObjectShortDescError(Document document, long l) {
        return this.getDrawingObjectShortDescError(document, l, true);
    }

    private boolean checkDrawingObjectLongDesc(DrawingObjectElement drawingObjectElement) {
        if (!(drawingObjectElement instanceof PageThumbnailElement || drawingObjectElement instanceof FrameElement || this.isShapeContainText(drawingObjectElement))) {
            ODFElement oDFElement = null;
            oDFElement = this.odfVersion != -1.0 ? drawingObjectElement.getLongDescElement(this.odfVersion) : drawingObjectElement.getLongDescElement();
            if (oDFElement == null && !this.isTrackedChanges((ODFElement)drawingObjectElement)) {
                return false;
            }
        }
        return true;
    }

    public List<DrawingObjectElement> getDrawingObjectLongDescError(Document document) {
        ArrayList<DrawingObjectElement> arrayList;
        block10: {
            TextElement textElement;
            ODFConstants.ContentType contentType;
            DocumentContentElement documentContentElement;
            block9: {
                arrayList = new ArrayList<DrawingObjectElement>();
                if (this.odfVersion != -1.0 ? this.odfVersion < 1.1 : this.getOdfVersion(document) < 1.1) {
                    return arrayList;
                }
                documentContentElement = (DocumentContentElement)document.getDocumentElement();
                contentType = documentContentElement.getBodyElement().getContent().getContentType();
                if (contentType != ODFConstants.ContentType.PRESENTATION && contentType != ODFConstants.ContentType.DRAW) break block9;
                PresentationElement presentationElement = (PresentationElement)documentContentElement.getBodyElement().getContent();
                int n = 0;
                while ((long)n < presentationElement.getPageSize()) {
                    PageElement pageElement = presentationElement.getPage((long)n);
                    NodeList nodeList = pageElement.getDrawingObjectElements();
                    int n2 = 0;
                    while (n2 < nodeList.getLength()) {
                        DrawingObjectElement drawingObjectElement = (DrawingObjectElement)nodeList.item(n2);
                        if (!this.checkDrawingObjectLongDesc(drawingObjectElement)) {
                            arrayList.add(drawingObjectElement);
                        }
                        ++n2;
                    }
                    ++n;
                }
                break block10;
            }
            if (contentType != ODFConstants.ContentType.WRITE && contentType != ODFConstants.ContentType.SPREADSHEET) break block10;
            NodeList nodeList = null;
            if (contentType == ODFConstants.ContentType.WRITE) {
                textElement = (TextElement)documentContentElement.getBodyElement().getContent();
                nodeList = this.getWriteDrawingObject(textElement);
            }
            if (contentType == ODFConstants.ContentType.SPREADSHEET) {
                textElement = (SpreadSheetElement)documentContentElement.getBodyElement().getContent();
                nodeList = this.getSpreadsheetDrawingObject((SpreadSheetElement)textElement);
            }
            if (nodeList != null) {
                int n = 0;
                while (n < nodeList.getLength()) {
                    DrawingObjectElement drawingObjectElement;
                    if (nodeList.item(n) instanceof DrawingObjectElement && !this.checkDrawingObjectLongDesc(drawingObjectElement = (DrawingObjectElement)nodeList.item(n))) {
                        arrayList.add(drawingObjectElement);
                    }
                    ++n;
                }
            }
        }
        return arrayList;
    }

    public List<DrawingObjectElement> getDrawingObjectLongDescError(Document document, long l) {
        ArrayList<DrawingObjectElement> arrayList = new ArrayList<DrawingObjectElement>();
        DocumentContentElement documentContentElement = (DocumentContentElement)document.getDocumentElement();
        ContentBaseElement contentBaseElement = documentContentElement.getBodyElement().getContent();
        ODFConstants.ContentType contentType = contentBaseElement.getContentType();
        if ((contentType == ODFConstants.ContentType.PRESENTATION || contentType == ODFConstants.ContentType.DRAW) && contentBaseElement instanceof DrawingElement) {
            PageElement pageElement = ((DrawingElement)contentBaseElement).getPage(l);
            NodeList nodeList = pageElement.getDrawingObjectElements();
            int n = 0;
            while (n < nodeList.getLength()) {
                DrawingObjectElement drawingObjectElement = (DrawingObjectElement)nodeList.item(n);
                if (!this.checkDrawingObjectLongDesc(drawingObjectElement)) {
                    arrayList.add(drawingObjectElement);
                }
                ++n;
            }
        }
        return arrayList;
    }

    private boolean checkLinkHintError(AElement aElement) {
        return aElement.getAttrOfficeTitle() != null || this.isTrackedChanges((ODFElement)aElement);
    }

    private List<AElement> getLinkHintError(Element element) {
        ArrayList<AElement> arrayList = new ArrayList<AElement>();
        NodeList nodeList = element.getElementsByTagNameNS("urn:oasis:names:tc:opendocument:xmlns:text:1.0", "a");
        int n = 0;
        while (n < nodeList.getLength()) {
            AElement aElement = (AElement)nodeList.item(n);
            if (!this.checkLinkHintError(aElement)) {
                arrayList.add(aElement);
            }
            ++n;
        }
        return arrayList;
    }

    public List<AElement> getLinkHintError(Document document) {
        if (this.odfVersion != -1.0) {
            if (this.odfVersion < 1.1) {
                new ArrayList();
            }
        } else if (this.getOdfVersion(document) < 1.1) {
            new ArrayList();
        }
        return this.getLinkHintError(document.getDocumentElement());
    }

    public List<AElement> getLinkHintError(Document document, long l) {
        DocumentContentElement documentContentElement = (DocumentContentElement)document.getDocumentElement();
        ContentBaseElement contentBaseElement = documentContentElement.getBodyElement().getContent();
        ODFConstants.ContentType contentType = contentBaseElement.getContentType();
        if ((contentType == ODFConstants.ContentType.PRESENTATION || contentType == ODFConstants.ContentType.DRAW) && contentBaseElement instanceof DrawingElement) {
            return this.getLinkHintError((Element)((DrawingElement)contentBaseElement).getPage(l));
        }
        return new ArrayList<AElement>();
    }

    private boolean checkEmbedObjectShortDescError(EmbedDrawingObjectElement embedDrawingObjectElement) {
        if (embedDrawingObjectElement instanceof ObjectElement && ((ObjectElement)embedDrawingObjectElement).isPresentationTable()) {
            return true;
        }
        FrameElement frameElement = embedDrawingObjectElement.getFrameElement();
        if (!this.isGroupedShape((DrawingObjectElement)frameElement)) {
            ODFElement oDFElement = null;
            oDFElement = this.odfVersion != -1.0 ? embedDrawingObjectElement.getShortDescElement(this.odfVersion) : embedDrawingObjectElement.getShortDescElement();
            if (oDFElement == null) {
                TextBoxElement textBoxElement = null;
                textBoxElement = this.odfVersion != -1.0 ? frameElement.getBoundCaptionTextBoxElement(this.odfVersion) : frameElement.getBoundCaptionTextBoxElement();
                if (textBoxElement == null && !this.isTrackedChanges((ODFElement)embedDrawingObjectElement)) {
                    return false;
                }
            }
        }
        return true;
    }

    private List<EmbedDrawingObjectElement> getEmbedObjectShortDescError(Element element) {
        ArrayList<EmbedDrawingObjectElement> arrayList = new ArrayList<EmbedDrawingObjectElement>();
        NodeList nodeList = this.xpathService.evalForNodeList(this.exp2, (Node)element);
        int n = 0;
        while (n < nodeList.getLength()) {
            EmbedDrawingObjectElement embedDrawingObjectElement = (EmbedDrawingObjectElement)nodeList.item(n);
            if (!this.checkEmbedObjectShortDescError(embedDrawingObjectElement)) {
                arrayList.add(embedDrawingObjectElement);
            }
            ++n;
        }
        return arrayList;
    }

    public List<EmbedDrawingObjectElement> getEmbedObjectShortDescError(Document document) {
        BodyElement bodyElement = null;
        Element element = document.getDocumentElement();
        if (element instanceof DocumentContentElement) {
            DocumentContentElement documentContentElement = (DocumentContentElement)element;
            bodyElement = documentContentElement.getBodyElement();
        }
        if (bodyElement == null) {
            return new ArrayList<EmbedDrawingObjectElement>();
        }
        return this.getEmbedObjectShortDescError((Element)bodyElement);
    }

    public List<EmbedDrawingObjectElement> getEmbedObjectShortDescError(Document document, long l) {
        DocumentContentElement documentContentElement = (DocumentContentElement)document.getDocumentElement();
        ContentBaseElement contentBaseElement = documentContentElement.getBodyElement().getContent();
        ODFConstants.ContentType contentType = contentBaseElement.getContentType();
        if ((contentType == ODFConstants.ContentType.PRESENTATION || contentType == ODFConstants.ContentType.DRAW) && contentBaseElement instanceof DrawingElement) {
            return this.getEmbedObjectShortDescError((Element)((DrawingElement)contentBaseElement).getPage(l));
        }
        return new ArrayList<EmbedDrawingObjectElement>();
    }

    private boolean checkEmbedObjectLongDescError(EmbedDrawingObjectElement embedDrawingObjectElement) {
        if (embedDrawingObjectElement instanceof ObjectElement && ((ObjectElement)embedDrawingObjectElement).isPresentationTable()) {
            return true;
        }
        FrameElement frameElement = embedDrawingObjectElement.getFrameElement();
        if (!this.isGroupedShape((DrawingObjectElement)frameElement)) {
            ODFElement oDFElement = null;
            oDFElement = this.odfVersion != -1.0 ? embedDrawingObjectElement.getLongDescElement(this.odfVersion) : embedDrawingObjectElement.getLongDescElement();
            if (oDFElement == null && !this.isTrackedChanges((ODFElement)embedDrawingObjectElement)) {
                return false;
            }
        }
        return true;
    }

    private List<EmbedDrawingObjectElement> getEmbedObjectLongDescError(Element element) {
        ArrayList<EmbedDrawingObjectElement> arrayList = new ArrayList<EmbedDrawingObjectElement>();
        NodeList nodeList = this.xpathService.evalForNodeList(this.exp1, (Node)element);
        int n = 0;
        while (n < nodeList.getLength()) {
            EmbedDrawingObjectElement embedDrawingObjectElement = (EmbedDrawingObjectElement)nodeList.item(n);
            if (!this.checkEmbedObjectLongDescError(embedDrawingObjectElement)) {
                arrayList.add(embedDrawingObjectElement);
            }
            ++n;
        }
        return arrayList;
    }

    public List<EmbedDrawingObjectElement> getEmbedObjectLongDescError(Document document) {
        if (this.odfVersion != -1.0 ? this.odfVersion < 1.1 : this.getOdfVersion(document) < 1.1) {
            return new ArrayList<EmbedDrawingObjectElement>();
        }
        BodyElement bodyElement = null;
        Element element = document.getDocumentElement();
        if (element instanceof DocumentContentElement) {
            DocumentContentElement documentContentElement = (DocumentContentElement)element;
            bodyElement = documentContentElement.getBodyElement();
        }
        if (bodyElement == null) {
            return new ArrayList<EmbedDrawingObjectElement>();
        }
        return this.getEmbedObjectLongDescError((Element)bodyElement);
    }

    public List<EmbedDrawingObjectElement> getEmbedObjectLongDescError(Document document, long l) {
        DocumentContentElement documentContentElement = (DocumentContentElement)document.getDocumentElement();
        ContentBaseElement contentBaseElement = documentContentElement.getBodyElement().getContent();
        ODFConstants.ContentType contentType = contentBaseElement.getContentType();
        if ((contentType == ODFConstants.ContentType.PRESENTATION || contentType == ODFConstants.ContentType.DRAW) && contentBaseElement instanceof DrawingElement) {
            return this.getEmbedObjectLongDescError((Element)((DrawingElement)contentBaseElement).getPage(l));
        }
        return new ArrayList<EmbedDrawingObjectElement>();
    }

    private boolean checkFormLabelError(ControlElement controlElement) {
        FormControlElement formControlElement = controlElement.getFormControlElement();
        return formControlElement == null || formControlElement.getAttrFormLabel() != null || controlElement.getFormLabelFixedTextElement() != null || this.isTrackedChanges((ODFElement)controlElement);
    }

    private List<ControlElement> getFormLabelError(Element element) {
        ArrayList<ControlElement> arrayList = new ArrayList<ControlElement>();
        NodeList nodeList = element.getElementsByTagNameNS("urn:oasis:names:tc:opendocument:xmlns:drawing:1.0", "control");
        int n = 0;
        while (n < nodeList.getLength()) {
            ControlElement controlElement = (ControlElement)nodeList.item(n);
            if (!this.checkFormLabelError(controlElement)) {
                arrayList.add(controlElement);
            }
            ++n;
        }
        return arrayList;
    }

    public List<ControlElement> getFormLabelError(Document document) {
        return this.getFormLabelError(document.getDocumentElement());
    }

    public List<ControlElement> getFormLabelError(Document document, long l) {
        DocumentContentElement documentContentElement = (DocumentContentElement)document.getDocumentElement();
        ContentBaseElement contentBaseElement = documentContentElement.getBodyElement().getContent();
        ODFConstants.ContentType contentType = contentBaseElement.getContentType();
        if ((contentType == ODFConstants.ContentType.PRESENTATION || contentType == ODFConstants.ContentType.DRAW) && contentBaseElement instanceof DrawingElement) {
            return this.getFormLabelError((Element)((DrawingElement)contentBaseElement).getPage(l));
        }
        return new ArrayList<ControlElement>();
    }

    private boolean checkDrawNavOrderError(PageElement pageElement) {
        return pageElement.getAttrDrawNavOrder() != null;
    }

    public List<PageElement> getDrawNavOrderError(Document document) {
        ArrayList<PageElement> arrayList = new ArrayList<PageElement>();
        if (this.odfVersion != -1.0 ? this.odfVersion < 1.1 : this.getOdfVersion(document) < 1.1) {
            return arrayList;
        }
        DocumentContentElement documentContentElement = (DocumentContentElement)document.getDocumentElement();
        ContentBaseElement contentBaseElement = documentContentElement.getBodyElement().getContent();
        ODFConstants.ContentType contentType = contentBaseElement.getContentType();
        if (contentType != ODFConstants.ContentType.PRESENTATION || !(contentBaseElement instanceof PresentationElement)) {
            return arrayList;
        }
        PresentationElement presentationElement = (PresentationElement)contentBaseElement;
        int n = 0;
        while ((long)n < presentationElement.getPageSize()) {
            PageElement pageElement = presentationElement.getPage((long)n);
            if (!this.checkDrawNavOrderError(pageElement)) {
                arrayList.add(pageElement);
            }
            ++n;
        }
        return arrayList;
    }

    private List<DocumentContentElement> getFormTabIndexError(Element element) {
        FormControlElement formControlElement;
        ArrayList<DocumentContentElement> arrayList = new ArrayList<DocumentContentElement>();
        NodeList nodeList = element.getElementsByTagNameNS("urn:oasis:names:tc:opendocument:xmlns:drawing:1.0", "control");
        if (nodeList == null || nodeList.getLength() == 0) {
            return arrayList;
        }
        ArrayList<FormControlElement> arrayList2 = new ArrayList<FormControlElement>();
        int n = 0;
        while (n < nodeList.getLength()) {
            ControlElement controlElement = (ControlElement)nodeList.item(n);
            formControlElement = controlElement.getFormControlElement();
            if (formControlElement != null) {
                arrayList2.add(formControlElement);
            }
            ++n;
        }
        if (arrayList2.size() == 0) {
            return arrayList;
        }
        n = 0;
        int n2 = 0;
        while (n2 < arrayList2.size()) {
            formControlElement = (FormControlElement)arrayList2.get(n2);
            if (formControlElement.getAttrFormTabIndex() != null) {
                n = 1;
            }
            ++n2;
        }
        if (n == 0) {
            arrayList.add((DocumentContentElement)element);
        }
        return arrayList;
    }

    public List<DocumentContentElement> getFormTabIndexError(Document document) {
        Element element = document.getDocumentElement();
        if (!(element instanceof DocumentContentElement)) {
            return new ArrayList<DocumentContentElement>();
        }
        return this.getFormTabIndexError(element);
    }

    private boolean checkFormTabStopError(ControlElement controlElement) {
        FormControlElement formControlElement = controlElement.getFormControlElement();
        return formControlElement == null || !formControlElement.hasAttributeNS("urn:oasis:names:tc:opendocument:xmlns:form:1.0", "tab-stop") || formControlElement.getAttrFormTabStop() || this.isTrackedChanges((ODFElement)controlElement);
    }

    private List<ControlElement> getFormTabStopError(Element element) {
        ArrayList<ControlElement> arrayList = new ArrayList<ControlElement>();
        NodeList nodeList = element.getElementsByTagNameNS("urn:oasis:names:tc:opendocument:xmlns:drawing:1.0", "control");
        int n = 0;
        while (n < nodeList.getLength()) {
            ControlElement controlElement = (ControlElement)nodeList.item(n);
            if (!this.checkFormTabStopError(controlElement)) {
                arrayList.add(controlElement);
            }
            ++n;
        }
        return arrayList;
    }

    public List<ControlElement> getFormTabStopError(Document document) {
        return this.getFormTabStopError(document.getDocumentElement());
    }

    public List<ControlElement> getFormTabStopError(Document document, long l) {
        DocumentContentElement documentContentElement = (DocumentContentElement)document.getDocumentElement();
        ContentBaseElement contentBaseElement = documentContentElement.getBodyElement().getContent();
        ODFConstants.ContentType contentType = contentBaseElement.getContentType();
        if ((contentType == ODFConstants.ContentType.PRESENTATION || contentType == ODFConstants.ContentType.DRAW) && contentBaseElement instanceof DrawingElement) {
            return this.getFormTabStopError((Element)((DrawingElement)contentBaseElement).getPage(l));
        }
        return new ArrayList<ControlElement>();
    }

    public boolean hasTooManyShape(Document document, long l, int n) {
        DocumentContentElement documentContentElement = (DocumentContentElement)document.getDocumentElement();
        ContentBaseElement contentBaseElement = documentContentElement.getBodyElement().getContent();
        ODFConstants.ContentType contentType = contentBaseElement.getContentType();
        if ((contentType == ODFConstants.ContentType.PRESENTATION || contentType == ODFConstants.ContentType.DRAW) && contentBaseElement instanceof DrawingElement) {
            PageElement pageElement = ((DrawingElement)contentBaseElement).getPage(l);
            int n2 = 0;
            NodeList nodeList = pageElement.getChildNodes();
            int n3 = 0;
            while (n3 < nodeList.getLength()) {
                Node node = nodeList.item(n3);
                if (node instanceof DrawingObjectElement) {
                    ++n2;
                }
                if (n2 > n) {
                    return true;
                }
                ++n3;
            }
        }
        return false;
    }

    public List<DocumentContentElement> getODF10CompativilityError(Document document) {
        Node node;
        Node node2;
        int n;
        ArrayList<DocumentContentElement> arrayList = new ArrayList<DocumentContentElement>();
        Element element = document.getDocumentElement();
        if (!(element instanceof DocumentContentElement)) {
            return arrayList;
        }
        if (this.odfVersion != -1.0 ? this.odfVersion != 1.0 : this.getOdfVersion(document) != 1.0) {
            return arrayList;
        }
        boolean bl = false;
        NodeList nodeList = document.getDocumentElement().getElementsByTagNameNS("urn:oasis:names:tc:opendocument:xmlns:svg-compatible:1.0", "title");
        if (nodeList != null && nodeList.getLength() > 0) {
            bl = true;
        }
        if ((nodeList = document.getDocumentElement().getElementsByTagNameNS("urn:oasis:names:tc:opendocument:xmlns:svg-compatible:1.0", "desc")) != null && nodeList.getLength() > 0) {
            n = 0;
            while (n < nodeList.getLength()) {
                node2 = nodeList.item(n);
                node = node2.getParentNode();
                if (node instanceof RectElement || node instanceof LineElement || node instanceof PolylineElement || node instanceof PolygonElement || node instanceof RegularPolygonElement || node instanceof PathElement || node instanceof CircleElement || node instanceof EllipseElement || node instanceof GElement || node instanceof PageThumbnailElement || node instanceof MeasureElement || node instanceof CaptionElement || node instanceof ConnectorElement || node instanceof ControlElement || node instanceof SceneElement || node instanceof CustomShapeElement) {
                    bl = true;
                }
                ++n;
            }
        }
        if ((nodeList = document.getDocumentElement().getElementsByTagNameNS("urn:oasis:names:tc:opendocument:xmlns:drawing:1.0", "frame")) != null && nodeList.getLength() > 0) {
            n = 0;
            while (n < nodeList.getLength()) {
                node2 = nodeList.item(n);
                if (node2 instanceof FrameElement && (node = (FrameElement)node2).hasAttributeNS("urn:oasis:names:tc:opendocument:xmlns:drawing:1.0", "caption-id")) {
                    bl = true;
                }
                ++n;
            }
        }
        if ((nodeList = document.getDocumentElement().getElementsByTagNameNS("urn:oasis:names:tc:opendocument:xmlns:text:1.0", "a")) != null && nodeList.getLength() > 0) {
            n = 0;
            while (n < nodeList.getLength()) {
                node2 = nodeList.item(n);
                if (node2 instanceof AElement && (node = (AElement)node2).hasAttributeNS("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "title")) {
                    bl = true;
                }
                ++n;
            }
        }
        if ((nodeList = document.getDocumentElement().getElementsByTagNameNS("urn:oasis:names:tc:opendocument:xmlns:drawing:1.0", "page")) != null && nodeList.getLength() > 0) {
            n = 0;
            while (n < nodeList.getLength()) {
                node2 = nodeList.item(n);
                if (node2 instanceof PageElement && (node = (PageElement)node2).hasAttributeNS("urn:oasis:names:tc:opendocument:xmlns:drawing:1.0", "nav-order")) {
                    bl = true;
                }
                ++n;
            }
        }
        if (bl) {
            arrayList.add((DocumentContentElement)element);
        }
        return arrayList;
    }
}

