/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation and Others
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Hisashi MIYASHITA - initial API and implementation
 *    Kentarou FUKUDA - initial API and implementation
 *******************************************************************************/

package org.eclipse.actf.util.httpproxy.util;

import java.io.IOException;

import org.eclipse.actf.util.httpproxy.core.IHTTPHeader;
import org.eclipse.actf.util.httpproxy.core.IHTTPRequestMessage;
import org.eclipse.actf.util.httpproxy.core.IHTTPResponseMessage;
import org.eclipse.actf.util.httpproxy.core.IHTTPResponsePushbackMessage;
import org.eclipse.actf.util.httpproxy.proxy.IHTTPProxyConnection;
import org.eclipse.actf.util.internal.httpproxy.core.HTTPResponseInMemoryMessage;
import org.eclipse.actf.util.internal.httpproxy.core.HTTPResponsePushbackMessage;

/**
 * Utility class for HTTP session and messages
 */
public class HTTPUtil {
	/**
	 * Send 404 (not found) error to client
	 * 
	 * @param fClient
	 *            target {@link IHTTPProxyConnection}
	 * @param request
	 *            target {@link IHTTPRequestMessage}
	 * @throws InterruptedException
	 * @throws IOException
	 */
	public static void sendFailedToClient(IHTTPProxyConnection fClient,
			IHTTPRequestMessage request) throws InterruptedException,
			IOException {
		fClient.sendResponse(new HTTPResponseInMemoryMessage(request
				.getSerial(), IHTTPHeader.HTTP_VERSION_1_0_A, "404".getBytes(), //$NON-NLS-1$
				"Not found".getBytes(), IHTTPResponseMessage.EMPTY_BODY)); //$NON-NLS-1$
	}

	/**
	 * Create new {@link IHTTPResponseMessage} instance
	 * 
	 * @param base
	 *            the base {@link IHTTPResponseMessage}. New instance will be
	 *            generated by copying the base message.
	 * @param body
	 *            message body of the new instance
	 * @return new {@link IHTTPResponseMessage} instance
	 */
	public static IHTTPResponseMessage createHTTPResponseInMemoryMessage(
			IHTTPResponseMessage base, byte[] body) {
		return new HTTPResponseInMemoryMessage(base, body);
	}

	/**
	 * Create new {@link IHTTPResponseMessage} instance
	 * 
	 * @param serial
	 *            serial of the message
	 * @param version
	 *            version of the message
	 * @param statusCode
	 *            status code of the message
	 * @param reasonPhrase
	 *            reason phrase of the message
	 * @param body
	 *            message body
	 * @return new {@link IHTTPResponseMessage} instance
	 */
	public static IHTTPResponseMessage createHTTPResponseInMemoryMessage(
			long serial, byte[] version, byte[] statusCode,
			byte[] reasonPhrase, byte[] body) {
		return new HTTPResponseInMemoryMessage(serial, version, statusCode,
				reasonPhrase, body);
	}

	/**
	 * Create new {@link IHTTPResponsePushbackMessage} instance from base
	 * message
	 * 
	 * @param base
	 *            the base {@link IHTTPResponseMessage}. New instance will be
	 *            generated by copying the base message.
	 * @param pushbackBufferSize
	 *            pushback buffer size of the new
	 *            {@link IHTTPResponsePushbackMessage} instance
	 * @return new {@link IHTTPResponsePushbackMessage} instance
	 */
	public static IHTTPResponsePushbackMessage createHTTPResponsePushbackMessage(
			IHTTPResponseMessage base, int pushbackBufferSize) {
		return new HTTPResponsePushbackMessage(base, pushbackBufferSize);
	}

}
