/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.lowvision;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.actf.model.ui.editor.browser.ICurrentStyles;
import org.eclipse.actf.visualization.engines.lowvision.LowVisionException;
import org.eclipse.actf.visualization.engines.lowvision.LowVisionType;
import org.eclipse.actf.visualization.engines.lowvision.image.ImageException;
import org.eclipse.actf.visualization.internal.engines.lowvision.DebugUtil;
import org.eclipse.actf.visualization.internal.engines.lowvision.LengthUtil;
import org.eclipse.actf.visualization.internal.engines.lowvision.checker.W3CColorChecker;
import org.eclipse.actf.visualization.internal.engines.lowvision.color.ColorCSS;
import org.eclipse.actf.visualization.internal.engines.lowvision.color.ColorException;
import org.eclipse.actf.visualization.internal.engines.lowvision.color.ColorIRGB;
import org.eclipse.actf.visualization.internal.engines.lowvision.problem.ColorProblem;
import org.eclipse.actf.visualization.internal.engines.lowvision.problem.FixedSizeFontProblem;
import org.eclipse.actf.visualization.internal.engines.lowvision.problem.FixedSmallFontProblem;
import org.eclipse.actf.visualization.internal.engines.lowvision.problem.LowVisionProblem;
import org.eclipse.actf.visualization.internal.engines.lowvision.problem.LowVisionProblemException;
import org.eclipse.actf.visualization.internal.engines.lowvision.problem.ProhibitedBackgroundColorProblem;
import org.eclipse.actf.visualization.internal.engines.lowvision.problem.ProhibitedBothColorsProblem;
import org.eclipse.actf.visualization.internal.engines.lowvision.problem.ProhibitedForegroundColorProblem;
import org.eclipse.actf.visualization.internal.engines.lowvision.problem.SmallFontProblem;
import org.eclipse.swt.graphics.Rectangle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageElement {
    static final String IE_LARGEST_FONT = "16pt";
    static final double IE_EM_SCALING = 1.33;
    static final double IE_LARGER_SCALING = 1.67;
    static final double IE_SMALLER_SCALING = 1.0;
    public static final double SEVERITY_FIXED_SIZE_FONT = 0.25;
    public static final double SEVERITY_SMALL_FONT = 0.25;
    public static final double SEVERITY_FIXED_SMALL_FONT = 0.5;
    public static final double SEVERITY_PROHIBITED_FOREGROUND_COLOR = 0.5;
    public static final double SEVERITY_PROHIBITED_BACKGROUND_COLOR = 0.5;
    public static final double SEVERITY_PROHIBITED_BOTH_COLORS = 1.0;
    private static final String DELIM = "/";
    private static final String[] nonTextTagNames = new String[]{"area", "base", "basefont", "br", "col", "colgroup", "frame", "frameset", "head", "html", "hr", "img", "isindex", "link", "meta", "optgroup", "param", "script", "select", "style", "title"};
    private static final String[] fontSizeChangeTags = new String[]{"big", "code", "h1", "h2", "h3", "h5", "h6", "kbd", "pre", "samp", "small", "sub", "sup", "tt"};
    public static final int UNSET_POSITION = -1;
    public static final int UNSET_COLOR = -1;
    private String id = null;
    private ICurrentStyles style = null;
    private String tagName = null;
    private int x = -1;
    private int y = -1;
    private int width = -1;
    private int height = -1;
    private int foregroundColor = -1;
    private int backgroundColor = -1;
    private static final short FONT_SIZE_UNKNOWN = 0;
    private static final short FONT_SIZE_FIXED = 1;
    private static final short FONT_SIZE_PT = 2;
    private static final short FONT_SIZE_RELATIVE = 3;
    private static final short FONT_SIZE_ABSOLUTE = 4;
    private static final short FONT_SIZE_PERCENT = 5;
    private static final short FONT_SIZE_EM = 6;

    public PageElement(String string, ICurrentStyles iCurrentStyles) throws ImageException {
        this.id = string;
        this.style = iCurrentStyles;
        this.tagName = this.style.getTagName().toLowerCase();
        this.setDimension();
        this.setColors();
    }

    private void setDimension() {
        Rectangle rectangle = this.style.getRectangle();
        this.x = rectangle.x;
        this.y = rectangle.y;
        this.width = rectangle.width;
        this.height = rectangle.height;
    }

    private void setColors() throws ImageException {
        if (!this.isTextTag()) {
            return;
        }
        String string = this.style.getComputedColor();
        String string2 = this.style.getComputedBackgroundColor();
        try {
            this.foregroundColor = new ColorCSS(string).toInt();
            this.backgroundColor = new ColorCSS(string2).toInt();
        }
        catch (ColorException colorException) {
            colorException.printStackTrace();
            throw new ImageException("Could not interpret colors.");
        }
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public String getTagName() {
        return this.tagName;
    }

    public int getForegroundColor() {
        return this.foregroundColor;
    }

    public int getBackgroundColor() {
        return this.backgroundColor;
    }

    public LowVisionProblem[] check(LowVisionType lowVisionType, String[] stringArray, String[] stringArray2) {
        Vector vector = new Vector();
        if (this.x < 0 || this.y < 0) {
            return new LowVisionProblem[0];
        }
        List<Object> list = new ArrayList();
        try {
            list = this.checkColors(lowVisionType);
        }
        catch (LowVisionException lowVisionException) {
            DebugUtil.errMsg(this, "Error occurred in checking colors: id = " + this.id);
            lowVisionException.printStackTrace();
        }
        vector.addAll(list);
        FixedSizeFontProblem fixedSizeFontProblem = null;
        try {
            fixedSizeFontProblem = this.checkFixedSizeFont(lowVisionType);
        }
        catch (LowVisionException lowVisionException) {
            DebugUtil.errMsg(this, "Error occurred in checking fixed-size font: id = " + this.id);
            lowVisionException.printStackTrace();
        }
        SmallFontProblem smallFontProblem = null;
        try {
            smallFontProblem = this.checkSmallFont(lowVisionType);
        }
        catch (LowVisionException lowVisionException) {
            DebugUtil.errMsg(this, "Error occurred in checking small font: id = " + this.id);
            lowVisionException.printStackTrace();
        }
        if (fixedSizeFontProblem != null && smallFontProblem != null) {
            double d = 0.5;
            FixedSmallFontProblem fixedSmallFontProblem = null;
            try {
                fixedSmallFontProblem = new FixedSmallFontProblem(this, lowVisionType, d);
                fixedSmallFontProblem.setElement(fixedSizeFontProblem.getElement());
                vector.addElement(fixedSmallFontProblem);
            }
            catch (LowVisionProblemException lowVisionProblemException) {
                lowVisionProblemException.printStackTrace();
            }
        } else if (fixedSizeFontProblem != null) {
            vector.addElement(fixedSizeFontProblem);
        } else if (smallFontProblem != null) {
            vector.addElement(smallFontProblem);
        }
        ProhibitedForegroundColorProblem prohibitedForegroundColorProblem = null;
        ProhibitedBackgroundColorProblem prohibitedBackgroundColorProblem = null;
        if (stringArray != null && stringArray.length > 0) {
            try {
                prohibitedForegroundColorProblem = this.checkAllowedForegroundColors(lowVisionType, stringArray);
            }
            catch (LowVisionException lowVisionException) {
                lowVisionException.printStackTrace();
            }
        }
        if (stringArray2 != null && stringArray2.length > 0) {
            try {
                prohibitedBackgroundColorProblem = this.checkAllowedBackgroundColors(lowVisionType, stringArray2);
            }
            catch (LowVisionException lowVisionException) {
                lowVisionException.printStackTrace();
            }
        }
        if (prohibitedForegroundColorProblem != null && prohibitedBackgroundColorProblem != null) {
            try {
                vector.addElement(new ProhibitedBothColorsProblem(this, lowVisionType, 1.0));
            }
            catch (LowVisionProblemException lowVisionProblemException) {
                lowVisionProblemException.printStackTrace();
            }
            prohibitedForegroundColorProblem = null;
            prohibitedBackgroundColorProblem = null;
        } else if (prohibitedForegroundColorProblem != null) {
            vector.addElement(prohibitedForegroundColorProblem);
        } else if (prohibitedBackgroundColorProblem != null) {
            vector.addElement(prohibitedBackgroundColorProblem);
        }
        int n = vector.size();
        LowVisionProblem[] lowVisionProblemArray = new LowVisionProblem[n];
        int n2 = 0;
        while (n2 < n) {
            lowVisionProblemArray[n2] = (LowVisionProblem)vector.elementAt(n2);
            ++n2;
        }
        return lowVisionProblemArray;
    }

    private List<ColorProblem> checkColors(LowVisionType lowVisionType) throws LowVisionException {
        ArrayList<ColorProblem> arrayList = new ArrayList<ColorProblem>();
        if (!this.isTextTag()) {
            return arrayList;
        }
        try {
            if (this.style.hasDescendantTextWithBGImage()) {
                ColorProblem colorProblem = new ColorProblem(this, lowVisionType, 0.0);
                colorProblem.setElement(this.style.getElement());
                colorProblem.setHasBackgroundImage(true);
                colorProblem.setTargetStrings(this.style.getDescendantTextsWithBGImage());
                colorProblem.setIsWarning(true);
                arrayList.add(colorProblem);
            }
            if (!this.style.hasChildText()) {
                return arrayList;
            }
            boolean bl = this.style.getComputedBackgroundImage() != null && !this.style.getComputedBackgroundImage().equalsIgnoreCase("none");
            ColorIRGB colorIRGB = new ColorIRGB(this.foregroundColor);
            ColorIRGB colorIRGB2 = new ColorIRGB(this.backgroundColor);
            W3CColorChecker w3CColorChecker = new W3CColorChecker(colorIRGB, colorIRGB2);
            double d = w3CColorChecker.calcContrast();
            if (d < 7.0) {
                ColorProblem colorProblem = new ColorProblem(this, lowVisionType, w3CColorChecker.calcSeverity());
                colorProblem.setElement(this.style.getElement());
                colorProblem.setContrast(d);
                colorProblem.setTargetStrings(this.style.getChildTexts());
                colorProblem.setHasBackgroundImage(bl);
                arrayList.add(colorProblem);
            }
        }
        catch (LowVisionProblemException lowVisionProblemException) {}
        return arrayList;
    }

    private FixedSizeFontProblem checkFixedSizeFont(LowVisionType lowVisionType) throws LowVisionException {
        Object object;
        if (!this.isTextTag()) {
            return null;
        }
        if (!this.style.hasChildText()) {
            return null;
        }
        String string = this.style.getFontSize().toLowerCase();
        if (string.indexOf(DELIM) == -1) {
            short s = this.fontSizeType(string = this.digitToFontSetting(string));
            if (s == 1) {
                try {
                    FixedSizeFontProblem fixedSizeFontProblem = new FixedSizeFontProblem(this, lowVisionType, 0.25);
                    fixedSizeFontProblem.setElement(this.style.getElement());
                    return fixedSizeFontProblem;
                }
                catch (LowVisionProblemException lowVisionProblemException) {
                    lowVisionProblemException.printStackTrace();
                    return null;
                }
            }
            return null;
        }
        boolean bl = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string, DELIM);
        int n = stringTokenizer.countTokens();
        String string2 = this.digitToFontSetting(stringTokenizer.nextToken());
        short s = this.fontSizeType(string2);
        if (s == 1) {
            bl = true;
        } else if (s != 3 && s != 4) {
            object = new String[n];
            object[n - 1] = string2;
            int n2 = n - 2;
            while (n2 >= 0) {
                object[n2] = this.digitToFontSetting(stringTokenizer.nextToken());
                --n2;
            }
            StringTokenizer stringTokenizer2 = new StringTokenizer(this.tagName, DELIM);
            if (stringTokenizer2.countTokens() != n) {
                throw new LowVisionException("# of tagNames and fontSizes did not match.");
            }
            String[] stringArray = new String[n];
            int n3 = n - 1;
            while (n3 >= 0) {
                stringArray[n3] = stringTokenizer2.nextToken();
                --n3;
            }
            Object object2 = object[0];
            short s2 = this.fontSizeType((String)object2);
            boolean bl2 = true;
            if (s2 != 2) {
                bl2 = false;
            }
            if (s2 == 1) {
                bl = true;
            }
            int n4 = 1;
            while (n4 < n) {
                Object object3 = object[n4];
                String string3 = stringArray[n4];
                if (string3.equals("td") || string3.equals("th")) {
                    bl2 = true;
                    if (s2 != 2) {
                        bl2 = false;
                    }
                    if (s2 == 1) {
                        bl = true;
                    }
                } else if (!((String)object2).equals(object3)) {
                    short s3 = this.fontSizeType((String)object3);
                    if (s3 == 1) {
                        bl = true;
                        bl2 = true;
                    } else if (s3 == 3 || s3 == 4) {
                        bl = false;
                        bl2 = true;
                    } else if (s3 == 2) {
                        if (!bl2) {
                            bl2 = true;
                            bl = false;
                        } else if (s2 != 2 || bl || !this.isFontSizeChangeTag(string3)) {
                            bl = true;
                        }
                    }
                    object2 = object3;
                    s2 = s3;
                }
                ++n4;
            }
        }
        if (bl) {
            try {
                object = new FixedSizeFontProblem(this, lowVisionType, 0.25);
                ((LowVisionProblem)object).setElement(this.style.getElement());
                return object;
            }
            catch (LowVisionProblemException lowVisionProblemException) {
                lowVisionProblemException.printStackTrace();
                return null;
            }
        }
        return null;
    }

    private short fontSizeType(String string) {
        String string2 = string.toLowerCase();
        if (string2.endsWith("mm") || string2.endsWith("cm") || string2.endsWith("in") || string2.endsWith("pc") || string2.endsWith("px")) {
            return 1;
        }
        if (string2.endsWith("pt")) {
            return 2;
        }
        if (string2.endsWith("%")) {
            return 5;
        }
        if (string2.endsWith("em") || string2.endsWith("ex")) {
            return 6;
        }
        if (string2.equals("smaller") || string2.equals("larger")) {
            return 3;
        }
        return 4;
    }

    private String digitToFontSetting(String string) throws LowVisionException {
        if (string.length() == 1) {
            if (string.equals("1")) {
                return "xx-small";
            }
            if (string.equals("2")) {
                return "x-small";
            }
            if (string.equals("3")) {
                return "small";
            }
            if (string.equals("4")) {
                return "medium";
            }
            if (string.equals("5")) {
                return "large";
            }
            if (string.equals("6")) {
                return "x-large";
            }
            if (string.equals("7")) {
                return "xx-large";
            }
            throw new LowVisionException("Invalid font size setting: " + string);
        }
        if (string.startsWith("+")) {
            if (string.equals("+1")) {
                return "120%";
            }
            if (string.equals("+2")) {
                return "144%";
            }
            if (string.equals("+3")) {
                return "173%";
            }
            if (string.equals("+4")) {
                return "207%";
            }
            if (string.equals("+5")) {
                return "249%";
            }
            if (string.equals("+6")) {
                return "299%";
            }
            if (string.equals("+0")) {
                return "100%";
            }
            throw new LowVisionException("Invalid font size setting: " + string);
        }
        if (string.startsWith("-")) {
            if (string.equals("-1")) {
                return "83%";
            }
            if (string.equals("-2")) {
                return "69%";
            }
            if (string.equals("-3")) {
                return "58%";
            }
            if (string.equals("-4")) {
                return "48%";
            }
            if (string.equals("-5")) {
                return "40%";
            }
            if (string.equals("-6")) {
                return "33%";
            }
            if (string.equals("-0")) {
                return "100%";
            }
            throw new LowVisionException("Invalid font size setting: " + string);
        }
        return string;
    }

    private boolean isFontSizeChangeTag(String string) {
        int n = fontSizeChangeTags.length;
        String string2 = string.toLowerCase();
        int n2 = 0;
        while (n2 < n) {
            if (string2.equals(fontSizeChangeTags[n2])) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private SmallFontProblem checkSmallFont(LowVisionType lowVisionType) throws LowVisionException {
        if (!lowVisionType.doBlur()) {
            return null;
        }
        double d = lowVisionType.getEyesightLength();
        if (!this.isTextTag()) {
            return null;
        }
        if (!this.style.hasChildText()) {
            return null;
        }
        if (this.tagName.startsWith("option")) {
            return null;
        }
        String string = this.style.getFontSize().toLowerCase();
        StringTokenizer stringTokenizer = new StringTokenizer(string, DELIM);
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer2 = new StringTokenizer(this.tagName, DELIM);
        String string2 = stringTokenizer.nextToken();
        String string3 = stringTokenizer2.nextToken();
        vector.addElement(string2);
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            string3 = stringTokenizer2.nextToken();
            if (string3.equals("td") || string3.equals("th")) {
                if (string4.equals(string2)) break;
                vector.addElement(string4);
                break;
            }
            if (!string4.equals(string2)) {
                vector.addElement(string4);
            }
            string2 = string4;
        }
        int n = vector.size();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            String string5 = (String)vector.elementAt(n2);
            stringArray[n2] = this.digitToFontSetting(string5);
            ++n2;
        }
        vector = null;
        String string6 = stringArray[n - 1];
        if (this.fontSizeType(string6) == 2) {
            stringArray[n - 1] = IE_LARGEST_FONT;
            int n3 = n - 2;
            while (n3 >= 0) {
                if (!stringArray[n3].equals(string6)) break;
                stringArray[n3] = IE_LARGEST_FONT;
                --n3;
            }
        }
        float f = 1.0f;
        int n4 = 0;
        int n5 = 0;
        while (n5 < n) {
            double d2;
            string6 = stringArray[n5];
            n4 = this.fontSizeType(string6);
            if (n4 == 1 || n4 == 2) break;
            if (n4 == 4) {
                if (string6.equals("xx-large")) {
                    string6 = "48pt";
                    break;
                }
                if (string6.equals("x-large")) {
                    string6 = "32pt";
                    break;
                }
                if (string6.equals("large")) {
                    string6 = "24pt";
                    break;
                }
                if (string6.equals("medium")) {
                    string6 = "18pt";
                    break;
                }
                if (string6.equals("small")) {
                    string6 = IE_LARGEST_FONT;
                    break;
                }
                if (string6.equals("x-small")) {
                    string6 = "14pt";
                    break;
                }
                if (!string6.equals("xx-small")) break;
                string6 = "12pt";
                break;
            }
            if (n4 == 5) {
                d2 = Double.parseDouble(string6.substring(0, string6.length() - 1));
                f = (float)((double)f * (d2 / 100.0));
            } else if (n4 == 6) {
                d2 = 0.0;
                d2 = Double.parseDouble(string6.substring(0, string6.length() - 2));
                if (string6.endsWith("ex")) {
                    d2 /= 2.0;
                }
                f = (float)((double)f * (d2 * 1.33));
            } else if (string6.equals("larger")) {
                f = (float)((double)f * 1.67);
            } else if (string6.equals("smaller")) {
                f = (float)((double)f * 1.0);
            } else {
                throw new LowVisionException("unknown font size setting: " + string6);
            }
            ++n5;
        }
        if (n4 != 1 && n4 != 2 && n4 != 4) {
            string6 = IE_LARGEST_FONT;
        }
        float f2 = Float.parseFloat(string6.substring(0, string6.length() - 2));
        float f3 = 0.0f;
        if (string6.endsWith("in")) {
            f3 = LengthUtil.in2mm(f2);
        } else if (string6.endsWith("cm")) {
            f3 = LengthUtil.cm2mm(f2);
        } else if (string6.endsWith("mm")) {
            f3 = f2;
        } else if (string6.endsWith("pt")) {
            f3 = LengthUtil.pt2mm(f2);
        } else if (string6.endsWith("pc")) {
            f3 = LengthUtil.pc2mm(f2);
        } else if (string6.endsWith("px")) {
            f3 = LengthUtil.px2mm(f2);
        } else {
            throw new LowVisionException("unknown font size unit: " + string6);
        }
        double d3 = 2.0 - (double)(f3 *= f) / (10.0 * d);
        if (d3 > 1.0) {
            d3 = 1.0;
        } else if (d3 < 0.0) {
            d3 = 0.0;
        }
        if (d3 > 0.0) {
            try {
                SmallFontProblem smallFontProblem = new SmallFontProblem(this, lowVisionType, 0.25);
                smallFontProblem.setElement(this.style.getElement());
                return smallFontProblem;
            }
            catch (LowVisionProblemException lowVisionProblemException) {
                lowVisionProblemException.printStackTrace();
                return null;
            }
        }
        return null;
    }

    private ProhibitedForegroundColorProblem checkAllowedForegroundColors(LowVisionType lowVisionType, String[] stringArray) throws LowVisionException {
        if (stringArray == null) {
            return null;
        }
        int n = stringArray.length;
        if (n == 0) {
            return null;
        }
        if (!this.isTextTag()) {
            return null;
        }
        if (this.tagName.startsWith("a/")) {
            return null;
        }
        if (this.foregroundColor == 0) {
            return null;
        }
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            ColorIRGB colorIRGB = null;
            try {
                colorIRGB = new ColorIRGB(string);
            }
            catch (ColorException colorException) {
                colorException.printStackTrace();
                throw new LowVisionException("ColorException occurs while converting String \"" + string + "\" to a color.");
            }
            if (colorIRGB.equals(this.foregroundColor)) {
                return null;
            }
            ++n2;
        }
        try {
            return new ProhibitedForegroundColorProblem(this, lowVisionType, 0.5);
        }
        catch (LowVisionProblemException lowVisionProblemException) {
            lowVisionProblemException.printStackTrace();
            return null;
        }
    }

    private ProhibitedBackgroundColorProblem checkAllowedBackgroundColors(LowVisionType lowVisionType, String[] stringArray) throws LowVisionException {
        if (stringArray == null) {
            return null;
        }
        int n = stringArray.length;
        if (n == 0) {
            return null;
        }
        if (!this.isTextTag()) {
            return null;
        }
        if (this.backgroundColor == 0xFFFFFF) {
            return null;
        }
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            ColorIRGB colorIRGB = null;
            try {
                colorIRGB = new ColorIRGB(string);
            }
            catch (ColorException colorException) {
                colorException.printStackTrace();
                throw new LowVisionException("ColorException occurs while converting String \"" + string + "\" to a color.");
            }
            if (colorIRGB.equals(this.backgroundColor)) {
                return null;
            }
            ++n2;
        }
        try {
            return new ProhibitedBackgroundColorProblem(this, lowVisionType, 0.5);
        }
        catch (LowVisionProblemException lowVisionProblemException) {
            lowVisionProblemException.printStackTrace();
            return null;
        }
    }

    private boolean isTextTag() {
        String string = this.style.getTagName().toLowerCase();
        int n = nonTextTagNames.length;
        int n2 = 0;
        while (n2 < n) {
            if (string.startsWith(nonTextTagNames[n2])) {
                return false;
            }
            ++n2;
        }
        return true;
    }
}

