/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.internal.httpproxy.core;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.actf.util.httpproxy.core.IHTTPHeader;
import org.eclipse.actf.util.httpproxy.core.IHTTPMessage;
import org.eclipse.actf.util.httpproxy.core.IHTTPResponseMessage;
import org.eclipse.actf.util.internal.httpproxy.core.HTTPResponseMessage;
import org.eclipse.actf.util.internal.httpproxy.core.MessageBody;

public class HTTPResponseInMemoryMessage
extends HTTPResponseMessage
implements IHTTPResponseMessage {
    private final byte[] version;
    private final byte[] statusCode;
    private final byte[] reasonPhrase;

    protected HTTPResponseInMemoryMessage(long l, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        super(l);
        this.version = byArray;
        this.statusCode = byArray2;
        this.reasonPhrase = byArray3;
    }

    public HTTPResponseInMemoryMessage(long l, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        this(l, byArray, byArray2, byArray3);
        MessageBody messageBody = new MessageBody(new ByteArrayInputStream(byArray4), byArray4.length);
        super.setOriginalMessageBody(messageBody);
    }

    protected void setBaseHeaders(IHTTPMessage iHTTPMessage) {
        for (IHTTPHeader iHTTPHeader : iHTTPMessage.getHeaders()) {
            if (iHTTPHeader.isFieldNameEqualsTo(IHTTPHeader.CONTENT_LENGTH_A)) continue;
            this.setHeader(iHTTPHeader.getName(), iHTTPHeader.getValue());
        }
    }

    public HTTPResponseInMemoryMessage(IHTTPResponseMessage iHTTPResponseMessage, byte[] byArray) {
        this(iHTTPResponseMessage.getSerial(), iHTTPResponseMessage.getHTTPVersionAsBytes(), iHTTPResponseMessage.getStatusCodeAsBytes(), iHTTPResponseMessage.getReasonPhraseAsBytes(), byArray);
        this.setBaseHeaders(iHTTPResponseMessage);
    }

    public String getHTTPVersionAsString() {
        return new String(this.version);
    }

    public byte[] getHTTPVersionAsBytes() {
        return this.version;
    }

    public String getStatusCodeAsString() {
        return new String(this.statusCode);
    }

    public byte[] getStatusCodeAsBytes() {
        return this.statusCode;
    }

    public String getReasonPhraseAsString() {
        return new String(this.reasonPhrase);
    }

    public byte[] getReasonPhraseAsBytes() {
        return this.reasonPhrase;
    }

    protected void writeFirstLine(OutputStream outputStream) throws IOException {
        outputStream.write(this.version);
        outputStream.write(32);
        outputStream.write(this.statusCode);
        outputStream.write(32);
        outputStream.write(this.reasonPhrase);
        outputStream.write(13);
        outputStream.write(10);
    }
}

