/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.dom.html.impl;

import org.eclipse.actf.model.internal.dom.html.impl.SHDocument;
import org.eclipse.actf.model.internal.dom.html.impl.SHElement;
import org.eclipse.actf.model.internal.dom.html.impl.SHSelectElement;
import org.w3c.dom.Node;
import org.w3c.dom.html.HTMLCollection;
import org.w3c.dom.html.HTMLFormElement;
import org.w3c.dom.html.HTMLOptionElement;

public class SHOptionElement
extends SHElement
implements HTMLOptionElement {
    private static final long serialVersionUID = -3164490828413522255L;
    private boolean defaultSelected;

    protected SHOptionElement(String string, SHDocument sHDocument) {
        super(string, sHDocument);
    }

    public HTMLFormElement getForm() {
        Node node = this.getParentNode();
        while (node != null) {
            if (node instanceof HTMLFormElement) {
                return (HTMLFormElement)node;
            }
            node = node.getParentNode();
        }
        return null;
    }

    public boolean getDefaultSelected() {
        return this.defaultSelected;
    }

    public void setDefaultSelected(boolean bl) {
        this.defaultSelected = bl;
    }

    public String getText() {
        Node node = this.getFirstChild();
        return node == null ? null : node.getNodeValue();
    }

    public int getIndex() {
        Node node = this.getParentNode();
        while (node != null) {
            if (node instanceof SHSelectElement) {
                SHSelectElement sHSelectElement = (SHSelectElement)node;
                HTMLCollection hTMLCollection = sHSelectElement.getOptions();
                int n = 0;
                while (n < hTMLCollection.getLength()) {
                    if (hTMLCollection.item(n) == this) {
                        return n;
                    }
                    ++n;
                }
                return -1;
            }
            node = node.getParentNode();
        }
        return -1;
    }

    public void setIndex(int n) {
        Node node = this.getParentNode();
        while (node != null) {
            if (node instanceof SHSelectElement) {
                SHSelectElement sHSelectElement = (SHSelectElement)node;
                HTMLCollection hTMLCollection = sHSelectElement.getOptions();
                if (n < 0 || hTMLCollection.getLength() <= n) {
                    return;
                }
                SHOptionElement sHOptionElement = (SHOptionElement)hTMLCollection.item(n);
                Node node2 = sHOptionElement.getParentNode();
                this.getParentNode().removeChild(this);
                node2.insertBefore(this, sHOptionElement);
            }
            node = node.getParentNode();
        }
    }

    public boolean getSelected() {
        String string = this.getAttribute("selected");
        return string != null && string.length() != 0;
    }

    public void setSelected(boolean bl) {
        this.setAttribute("selected", bl ? "selected" : null);
    }

    public boolean getDisabled() {
        String string = this.getAttribute("disabled");
        return string != null && string.length() != 0;
    }

    public void setDisabled(boolean bl) {
        this.setAttribute("disabled", bl ? "disabled" : null);
    }

    public String getLabel() {
        return this.getAttribute("label");
    }

    public void setLabel(String string) {
        this.setAttribute("label", string);
    }

    public String getValue() {
        return this.getAttribute("value");
    }

    public void setValue(String string) {
        this.setAttribute("value", string);
    }
}

