/*******************************************************************************
 * Copyright (c) 2003, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Kentarou FUKUDA - initial API and implementation
 *******************************************************************************/

package org.eclipse.actf.visualization.eval.problem;

import org.eclipse.actf.visualization.internal.eval.Messages;

/**
 * Interface for constants commonly used for evaluation in visualization part
 */
public interface IProblemConst {
	public static final String ALL_ERRORS = Messages.ProblemConst_All_Errors_1; 

	public static final String ESSENTIAL = Messages.ProblemConst_Essential_2; 

	public static final String WARNING = Messages.ProblemConst_Warning; 
	
	public static final String USER_CHECK = Messages.ProblemConst_User_Check_5; 

	public static final String INFO = Messages.ProblemConst_Info; 

	public static final String COMPLIANCE = Messages.ProblemConst_Compliance_6; 

	public static final String ACCESSIBILITY = Messages.ProblemConst_0; 

	// the titles of the Problem Table
	public final static String TITLE_ICON = Messages.ProblemConst_Type_11; 

	public final static String TITLE_LINE = Messages.ProblemConst_Line_12; 

	public final static String TITLE_HIGHLIGHT = Messages.ProblemConst_Highlight; 

	public final static String TITLE_DESCRIPTION = Messages.ProblemConst_Problem_Description_17; 

	public final static String TITLE_FORECOLOR = Messages.ProblemConst_Foreground_18; 

	public final static String TITLE_BACKCOLOR = Messages.ProblemConst_Background_19; 

	public final static String TITLE_SEVERITY = Messages.ProblemConst_Severity_20; 

	public final static String TITLE_X = Messages.ProblemConst_X_21; 

	public final static String TITLE_Y = Messages.ProblemConst_Y_22; 

	public final static String TITLE_AREA = Messages.ProblemConst_Area_23; 
	
	public final static String TITLE_TECHNIQUS = Messages.Techniques;
	
	public final static String TITLE_TYPE = Messages.Type;
	
	public final static String TITLE_HELP = Messages.Help;
	
	public final static String TITLE_GUIDELINE = Messages.adesigner_preference_guideline_list_group_text;

}