/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.engines.blind.ui.preferences;

import java.util.TreeSet;
import org.eclipse.actf.ui.util.IDialogConstants;
import org.eclipse.actf.visualization.engines.blind.TextChecker;
import org.eclipse.actf.visualization.internal.engines.blind.Messages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class EditNGWordDialog {
    private static final String DIALOG_TITLE = Messages.AltDialog_TITLE;
    private Shell shell;
    private int iReturnCode = 0;
    private String strFilter;
    private Table ngWordTable;
    private TextChecker textChecker = TextChecker.getInstance();

    public EditNGWordDialog(Shell shell) {
        this.shell = new Shell(shell, 34912);
        this.shell.setLayout((Layout)new GridLayout());
    }

    private boolean setNewValue() {
        TreeSet<String> treeSet = new TreeSet<String>();
        TableItem[] tableItemArray = this.ngWordTable.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem tableItem = tableItemArray[n2];
            String string = tableItem.getText();
            if (string != null && (string = string.trim()).length() > 0) {
                treeSet.add(string);
            }
            ++n2;
        }
        this.textChecker.setInappropriateAltSet(treeSet);
        return true;
    }

    private void createButtonControls() {
        Composite composite = new Composite((Composite)this.shell, 0);
        GridData gridData = new GridData(136);
        gridData.heightHint = 50;
        composite.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.horizontalSpacing = 20;
        gridLayout.marginWidth = 20;
        gridLayout.marginHeight = 20;
        composite.setLayout((Layout)gridLayout);
        Button button = new Button(composite, 8);
        button.setText(IDialogConstants.OK);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (!EditNGWordDialog.this.setNewValue()) {
                    return;
                }
                EditNGWordDialog.this.iReturnCode = 1;
                EditNGWordDialog.this.shell.close();
            }
        });
        Button button2 = new Button(composite, 8);
        button2.setText(IDialogConstants.CANCEL);
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                EditNGWordDialog.this.iReturnCode = 0;
                EditNGWordDialog.this.shell.close();
            }
        });
        this.shell.setDefaultButton(button);
    }

    private void createSettingControls() {
        TableItem tableItem;
        String string2;
        Composite composite = new Composite((Composite)this.shell, 0);
        composite.setLayoutData((Object)new GridData(768));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite.setLayout((Layout)gridLayout);
        this.ngWordTable = new Table(composite, 68352);
        GridData gridData = new GridData(1808);
        gridData.heightHint = 150;
        gridData.horizontalSpan = 2;
        this.ngWordTable.setLayoutData((Object)gridData);
        this.ngWordTable.setHeaderVisible(true);
        this.ngWordTable.setLinesVisible(true);
        TableColumn tableColumn = new TableColumn(this.ngWordTable, 0);
        tableColumn.setText(Messages.AltDialog_Column_Name);
        tableColumn.setWidth(200);
        for (String string2 : this.textChecker.getInappropriateALTSet()) {
            tableItem = new TableItem(this.ngWordTable, 0);
            tableItem.setText(string2);
        }
        string2 = new Text(composite, 2048);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        string2.setLayoutData((Object)gridData);
        Button button = new Button(composite, 8);
        button.setText(IDialogConstants.ADD);
        button.addSelectionListener((SelectionListener)new SelectionAdapter((Text)string2){
            private final /* synthetic */ Text val$text;
            {
                this.val$text = text;
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                String string = this.val$text.getText().toLowerCase();
                if (string.equals("")) {
                    EditNGWordDialog.this.popupMessage(Messages.AltDialog_MSG_No_String);
                    return;
                }
                int n = EditNGWordDialog.this.ngWordTable.getItemCount();
                int n2 = 0;
                while (n2 < n) {
                    if (EditNGWordDialog.this.ngWordTable.getItem(n2).getText().equals(string)) {
                        EditNGWordDialog.this.popupMessage(Messages.AltDialog_MSG_Existed);
                        return;
                    }
                    ++n2;
                }
                TableItem tableItem = new TableItem(EditNGWordDialog.this.ngWordTable, 0);
                tableItem.setText(string);
            }
        });
        tableItem = new Button(composite, 8);
        tableItem.setText(IDialogConstants.DELETE);
        tableItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (EditNGWordDialog.this.ngWordTable.getSelectionCount() > 0) {
                    EditNGWordDialog.this.ngWordTable.getSelection()[0].dispose();
                }
            }
        });
    }

    private void popupMessage(String string) {
        MessageBox messageBox = new MessageBox(this.shell, 32);
        messageBox.setMessage(string);
        messageBox.open();
    }

    public int open() {
        this.shell.setText(DIALOG_TITLE);
        this.createSettingControls();
        this.createButtonControls();
        this.shell.setLocation(200, 200);
        this.shell.pack();
        this.shell.open();
        Display display = this.shell.getDisplay();
        while (!this.shell.isDisposed() || !display.readAndDispatch()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.iReturnCode;
    }

    public String getStrFilter() {
        return this.strFilter;
    }
}

