/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.lowvision.eval;

import java.util.List;
import org.eclipse.actf.ui.util.HighlightStringListener;
import org.eclipse.actf.util.FileUtils;
import org.eclipse.actf.visualization.eval.problem.IProblemItem;
import org.eclipse.actf.visualization.eval.problem.IProblemItemImage;
import org.eclipse.actf.visualization.lowvision.ui.internal.Messages;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SummaryEvaluationLV {
    private IProblemItemImage[] _problems = new IProblemItemImage[0];

    public static HighlightStringListener getHighLightStringListener() {
        HighlightStringListener highlightStringListener = new HighlightStringListener();
        Color color = Display.getDefault().getSystemColor(9);
        Color color2 = Display.getDefault().getSystemColor(3);
        if (Display.getDefault().getHighContrast()) {
            color = null;
            color2 = null;
        }
        highlightStringListener.addTarget(Messages.EvalLV_no_color_difficult_distinguish, color, 1);
        highlightStringListener.addTarget(Messages.EvalLV_font_might_enough_to_read, color, 1);
        highlightStringListener.addTarget(Messages.EvalLV_color_difficult_distinguish, color2, 1);
        highlightStringListener.addTarget(Messages.EvalLV_color_might_difficult_distinguish, color2, 1);
        highlightStringListener.addTarget(Messages.EvalLV_font_too_small_to_read, color2, 1);
        highlightStringListener.addTarget(Messages.EvalLV_font_might_too_small_to_read, color2, 1);
        highlightStringListener.addTarget(Messages.EvalLV_page_have_fixed_font, color2, 1);
        highlightStringListener.addTarget(Messages.EvalLV_0, null, 1);
        return highlightStringListener;
    }

    public SummaryEvaluationLV(List<IProblemItem> list) {
        try {
            this._problems = new IProblemItemImage[list.size()];
            list.toArray(this._problems);
        }
        catch (Exception exception) {
            this._problems = new IProblemItemImage[0];
        }
    }

    public static String notSupported() {
        return Messages.EvalLV_0;
    }

    public String getOverview() {
        StringBuffer stringBuffer = new StringBuffer(512);
        int[] nArray = new int[11];
        int[] nArray2 = new int[11];
        int n = 0;
        while (n < this._problems.length) {
            IProblemItemImage iProblemItemImage = this._problems[n];
            int n2 = iProblemItemImage.getSubType();
            nArray[n2] = nArray[n2] + 1;
            if (iProblemItemImage.getSeverityLV() > 49) {
                int n3 = iProblemItemImage.getSubType();
                nArray2[n3] = nArray2[n3] + 1;
            }
            ++n;
        }
        if (nArray[1] > 0 || nArray[3] > 0) {
            if (nArray2[1] > 0 || nArray2[3] > 0) {
                stringBuffer.append(String.valueOf(Messages.EvalLV_color_difficult_distinguish) + FileUtils.LINE_SEP);
            } else {
                stringBuffer.append(String.valueOf(Messages.EvalLV_color_might_difficult_distinguish) + FileUtils.LINE_SEP);
            }
            stringBuffer.append(String.valueOf(Messages.EvalLV_click_detailed_report) + FileUtils.LINE_SEP);
            stringBuffer.append(FileUtils.LINE_SEP);
            if (nArray[1] > 0) {
                stringBuffer.append(String.valueOf(Messages.EvalLV_text_color_combination) + " " + nArray[1] + FileUtils.LINE_SEP);
            }
            if (nArray[3] > 0) {
                stringBuffer.append(String.valueOf(Messages.EvalLV_img_color_combination) + " " + nArray[3] + FileUtils.LINE_SEP);
            }
        } else {
            stringBuffer.append(String.valueOf(Messages.EvalLV_no_color_difficult_distinguish) + FileUtils.LINE_SEP);
        }
        stringBuffer.append(FileUtils.LINE_SEP);
        if (nArray[5] > 0 || nArray[6] > 0) {
            if (nArray2[5] > 0 || nArray2[6] > 0) {
                stringBuffer.append(String.valueOf(Messages.EvalLV_font_too_small_to_read) + FileUtils.LINE_SEP);
            } else {
                stringBuffer.append(String.valueOf(Messages.EvalLV_font_might_too_small_to_read) + FileUtils.LINE_SEP);
            }
            stringBuffer.append(String.valueOf(Messages.EvalLV_click_detailed_report) + FileUtils.LINE_SEP);
            stringBuffer.append(FileUtils.LINE_SEP);
            if (nArray[5] > 0) {
                stringBuffer.append(String.valueOf(Messages.EvalLV_font_too_small) + " " + nArray[5]);
            }
            if (nArray[6] > 0) {
                stringBuffer.append(String.valueOf(Messages.EvalLV_font_too_small_fixed) + " " + nArray[6]);
            }
        } else if (nArray[4] > 0) {
            stringBuffer.append(String.valueOf(Messages.EvalLV_page_have_fixed_font) + FileUtils.LINE_SEP);
            stringBuffer.append(FileUtils.LINE_SEP);
            stringBuffer.append(String.valueOf(Messages.EvalLV_font_fixed) + " " + nArray[4]);
        } else {
            stringBuffer.append(String.valueOf(Messages.EvalLV_font_might_enough_to_read) + FileUtils.LINE_SEP);
        }
        return stringBuffer.toString();
    }
}

