/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.examples.adesigner.eval.html.internal;

import java.util.Vector;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LanguageTag {
    private static final String[] GRANDFATHERED_TAGS = new String[]{"en-GB-oed", "i-ami", "i-bnn", "i-default", "i-enochian", "i-hak", "i-klingon", "i-lux", "i-mingo"};
    private static final String PRIM_LANG_ISO639 = "[a-z]{2,3}";
    private static final String PRIM_LANG_RESERVED = "[a-z]{4}";
    private static final String PRIM_LANG_REGISTERED = "[a-z]{5,8}";
    private static final String EXT_LANG_PART = "-[a-z]{3}";
    private static final String EXT_LANG_PART_PAREN = "-([a-z]{3})";
    private static final String EXT_LANG = "(?:-[a-z]{3}){0,3}";
    private static final String PRIM_LANG = "[a-z]{2,3}(?:-[a-z]{3}){0,3}|[a-z]{4}|[a-z]{5,8}";
    private static final String SCRIPT = "-[a-z]{4}";
    private static final String SCRIPT_PAREN = "-([a-z]{4})";
    private static final String REGION_ISO = "-[a-z]{2}";
    private static final String REGION_ISO_PAREN = "-([a-z]{2})";
    private static final String REGION_UN = "-\\d{3}";
    private static final String REGION_UN_PAREN = "-(\\d{3})";
    private static final String REGION = "-[a-z]{2}|-\\d{3}";
    private static final String REGION_PAREN = "-([a-z]{2})|-(\\d{3})";
    private static final String VARIANT_LONG = "-[a-z0-9]{5,8}";
    private static final String VARIANT_LONG_PAREN = "-([a-z0-9]{5,8})";
    private static final String VARIANT_SHORT = "-\\d[a-z0-9]{3}";
    private static final String VARIANT_SHORT_PAREN = "-(\\d[a-z0-9]{3})";
    private static final String VARIANT = "-[a-z0-9]{5,8}|-\\d[a-z0-9]{3}";
    private static final String VARIANT_PAREN = "-([a-z0-9]{5,8})|-(\\d[a-z0-9]{3})";
    private static final String EXTENSION = "-[a-wyz](?:-[a-z0-9]{2,8})+";
    private static final String EXTENSION_PAREN = "-([a-wyz](?:-[a-z0-9]{2,8})+)";
    private static final String PRIVATE_PART = "x(?:-[a-z0-9]{1,8})+";
    private static final String PRIVATE = "-x(?:-[a-z0-9]{1,8})+";
    private static final String PRIVATE_PAREN = "-x((?:-[a-z0-9]{1,8})+)";
    private static final Pattern syntax = Pattern.compile("^" + LanguageTag.addParen("[a-z]{2,3}(?:-[a-z]{3}){0,3}|[a-z]{4}|[a-z]{5,8}") + LanguageTag.addOptional("-[a-z]{4}") + LanguageTag.addOptional("-[a-z]{2}|-\\d{3}") + LanguageTag.addStar("-[a-z0-9]{5,8}|-\\d[a-z0-9]{3}") + LanguageTag.addStar("-[a-wyz](?:-[a-z0-9]{2,8})+") + LanguageTag.addOptional("-x(?:-[a-z0-9]{1,8})+") + "$", 2);
    private boolean wellFormed = false;
    private boolean valid = false;
    private boolean grandfathered = false;
    private boolean entirePrivate = false;
    private boolean isoPrimLan = false;
    private boolean resvPrimLan = false;
    private boolean regPrimLan = false;
    private boolean isoRegion = false;
    private boolean unRegion = false;
    private String tagString;
    private MatchResult result;
    private String primaryLanguage;
    private String extendedLanguage;
    private Vector<String> extendedLanguages;
    private String script;
    private String region;
    private String variantString;
    private Vector<String> variants;
    private String extensionString;
    private Vector<String> extensions;
    private String privateUse;

    private static String addParen(String string) {
        return "(" + string + ")";
    }

    private static String addOptional(String string) {
        return "(" + string + ")?";
    }

    private static String addStar(String string) {
        return "((?:" + string + ")*)";
    }

    public LanguageTag(String string, boolean bl) {
        Object object;
        this.tagString = string;
        String[] stringArray = GRANDFATHERED_TAGS;
        int n = GRANDFATHERED_TAGS.length;
        int n2 = 0;
        while (n2 < n) {
            object = stringArray[n2];
            if (string.matches((String)object)) {
                this.wellFormed = true;
                this.grandfathered = true;
                return;
            }
            ++n2;
        }
        if (string.matches(PRIVATE_PART)) {
            this.wellFormed = true;
            this.entirePrivate = true;
            return;
        }
        object = syntax.matcher(this.tagString);
        this.wellFormed = ((Matcher)object).matches();
        if (!this.wellFormed) {
            return;
        }
        if (!bl) {
            return;
        }
        this.result = ((Matcher)object).toMatchResult();
        this.primaryLanguage = this.result.group(1);
        this.script = this.result.group(2);
        this.region = this.result.group(3);
        this.variantString = this.result.group(4);
        this.extensionString = this.result.group(5);
        this.privateUse = this.result.group(6);
        this.processPrimLang();
        this.processScript();
        this.processRegion();
        this.processVariant();
        this.processExtension();
        this.processPrivateUse();
    }

    private void processPrimLang() {
        Matcher matcher = Pattern.compile(String.valueOf(LanguageTag.addParen(String.valueOf(LanguageTag.addParen(PRIM_LANG_ISO639)) + LanguageTag.addParen(EXT_LANG))) + "|" + LanguageTag.addParen(PRIM_LANG_RESERVED) + "|" + LanguageTag.addParen(PRIM_LANG_REGISTERED), 2).matcher(this.primaryLanguage);
        matcher.matches();
        if (matcher.group(1) != null) {
            this.isoPrimLan = true;
            this.primaryLanguage = matcher.group(2);
            if (matcher.group(3) != null && matcher.group(3).length() > 0) {
                this.extendedLanguage = matcher.group(3);
                this.processExtLang();
            }
        }
        if (matcher.group(4) != null) {
            this.resvPrimLan = true;
        }
        if (matcher.group(5) != null) {
            this.regPrimLan = true;
        }
    }

    private void processExtLang() {
        Matcher matcher = Pattern.compile(EXT_LANG_PART_PAREN, 2).matcher(this.extendedLanguage);
        this.extendedLanguages = new Vector();
        while (matcher.find()) {
            this.extendedLanguages.add(matcher.group(1));
        }
        this.extendedLanguage = this.extendedLanguages.elementAt(0);
    }

    private void processScript() {
        if (this.script != null && this.script.length() > 0) {
            Matcher matcher = Pattern.compile(SCRIPT_PAREN, 2).matcher(this.script);
            matcher.matches();
            this.script = matcher.group(1);
        } else {
            this.script = null;
        }
    }

    private void processRegion() {
        if (this.region != null && this.region.length() > 0) {
            Matcher matcher = Pattern.compile(REGION_PAREN, 2).matcher(this.region);
            matcher.matches();
            if (matcher.group(1) != null) {
                this.isoRegion = true;
                this.region = matcher.group(1);
            }
            if (matcher.group(2) != null) {
                this.unRegion = true;
                this.region = matcher.group(2);
            }
        } else {
            this.region = null;
        }
    }

    private void processVariant() {
        if (this.variantString != null && this.variantString.length() > 0) {
            this.variants = new Vector();
            Matcher matcher = Pattern.compile(VARIANT_PAREN, 2).matcher(this.variantString);
            while (matcher.find()) {
                if (matcher.group(1) != null) {
                    this.variants.add(matcher.group(1));
                }
                if (matcher.group(2) == null) continue;
                this.variants.add(matcher.group(2));
            }
        } else {
            this.variantString = null;
        }
    }

    private void processExtension() {
        if (this.extensionString != null && this.extensionString.length() > 0) {
            this.extensions = new Vector();
            Matcher matcher = Pattern.compile(EXTENSION_PAREN, 2).matcher(this.extensionString);
            while (matcher.find()) {
                this.extensions.add(matcher.group(1));
            }
        } else {
            this.extensionString = null;
        }
    }

    private void processPrivateUse() {
        if (this.privateUse != null && this.privateUse.length() > 0) {
            Matcher matcher = Pattern.compile(PRIVATE_PAREN, 2).matcher(this.privateUse);
            matcher.matches();
            this.privateUse = matcher.group(1);
        } else {
            this.privateUse = null;
        }
    }

    public boolean isWellFormed() {
        return this.wellFormed;
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean isGrandfathered() {
        return this.grandfathered;
    }

    public boolean isEntirePrivate() {
        return this.entirePrivate;
    }

    public String getPrimaryLanguage() {
        return this.primaryLanguage;
    }

    public String getExtendedLanguage() {
        return this.extendedLanguage;
    }

    public Vector<String> getExtendedLanguages() {
        return this.extendedLanguages;
    }

    public String getScript() {
        return this.script;
    }

    public String getRegion() {
        return this.region;
    }

    public String getVariantString() {
        return this.variantString;
    }

    public Vector<String> getVariants() {
        return this.variants;
    }

    public String getExtensionString() {
        return this.extensionString;
    }

    public Vector<String> getExtensions() {
        return this.extensions;
    }

    public String getPrivateUse() {
        return this.privateUse;
    }

    public boolean isIsoPrimaryLang() {
        return this.isoPrimLan;
    }

    public boolean isReservedPrimaryLang() {
        return this.resvPrimLan;
    }

    public boolean isRegisteredPrimaryLang() {
        return this.regPrimLan;
    }

    public boolean isIsoRegion() {
        return this.isoRegion;
    }

    public boolean isUnRegion() {
        return this.unRegion;
    }
}

