/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.ui.report.action;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.actf.visualization.eval.IGuidelineItem;
import org.eclipse.actf.visualization.eval.problem.IProblemItem;
import org.eclipse.actf.visualization.internal.ui.report.Messages;
import org.eclipse.actf.visualization.internal.ui.report.action.ShowGuidelineAction;
import org.eclipse.actf.visualization.internal.ui.report.table.ResultTableViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GuidelineSubMenu
extends MenuManager {
    private TableViewer _tableViewer;
    private Action _dummy;

    public GuidelineSubMenu(ResultTableViewer resultTableViewer) {
        super(Messages.ProblemTable_View_Guideline_16);
        this._tableViewer = resultTableViewer.getTableViewer();
        this._tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                List list = ((IStructuredSelection)selectionChangedEvent.getSelection()).toList();
                GuidelineSubMenu.this.setGuidelineItem(list);
            }
        });
        this._dummy = new Action(Messages.GuidelineSubMenu_0){};
        this._dummy.setEnabled(false);
        this.add((IAction)this._dummy);
    }

    public void setGuidelineItem(List<IProblemItem> list) {
        TreeSet<IGuidelineItem> treeSet = new TreeSet<IGuidelineItem>(new Comparator<IGuidelineItem>(){

            @Override
            public int compare(IGuidelineItem iGuidelineItem, IGuidelineItem iGuidelineItem2) {
                return iGuidelineItem.toString().compareTo(iGuidelineItem2.toString());
            }
        });
        for (IProblemItem iProblemItem : list) {
            treeSet.addAll(Arrays.asList(iProblemItem.getEvaluationItem().getGuidelines()));
        }
        this.removeAll();
        for (IGuidelineItem iGuidelineItem : treeSet) {
            if (iGuidelineItem.getUrl() == null || iGuidelineItem.getUrl().length() == 0 || !iGuidelineItem.isEnabled()) continue;
            this.add((IAction)new ShowGuidelineAction(iGuidelineItem));
        }
        if (this.getItems().length == 0) {
            this.add((IAction)this._dummy);
        }
    }
}

