/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.lowvision.image;

import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import org.eclipse.actf.model.ui.ImagePositionInfo;
import org.eclipse.actf.visualization.engines.lowvision.LowVisionException;
import org.eclipse.actf.visualization.engines.lowvision.LowVisionType;
import org.eclipse.actf.visualization.engines.lowvision.image.ImageException;
import org.eclipse.actf.visualization.internal.engines.lowvision.DecisionMaker;
import org.eclipse.actf.visualization.internal.engines.lowvision.color.ColorIRGB;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.BinaryImage;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.ColorHistogram;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.ColorHistogramBin;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.ConnectedComponent;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.ImageUtil;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.Int2D;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.InteriorImageComponent;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.LabeledImage;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.PageComponent;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.PageImage;
import org.eclipse.actf.visualization.internal.engines.lowvision.operator.LowVisionFilter;
import org.eclipse.actf.visualization.internal.engines.lowvision.problem.ImageColorProblem;
import org.eclipse.actf.visualization.internal.engines.lowvision.problem.LowVisionProblem;
import org.eclipse.actf.visualization.internal.engines.lowvision.problem.LowVisionProblemException;
import org.eclipse.actf.visualization.internal.engines.lowvision.problem.LowVisionProblemGroup;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InteriorImage
extends PageComponent {
    public static final int UNSET = -1;
    public static final double THRESHOLD_MIN_IMAGE_COLOR_PROBLEM_PROBABILITY = 0.2;
    public static final int THRESHOLD_MIN_LARGE_COMPONENT_PIXELS = 100;
    public static final double THRESHOLD_MIN_LARGE_COMPONENT_OCCUPATION = 5.0E-4;
    int left = -1;
    int top = -1;
    Int2D pixel = null;
    int numLargeComponents = 0;
    InteriorImageComponent[] largeComponents = null;
    String url = null;
    Element image;

    public Element getImage() {
        return this.image;
    }

    public void setImageElement(Element element) {
        this.image = element;
    }

    public InteriorImage(PageImage pageImage, int n, int n2, int n3, int n4) {
        super((short)10, pageImage);
        this.left = n;
        this.top = n2;
        this.pixel = new Int2D(n3, n4);
        int n5 = 0;
        while (n5 < n4) {
            int n6 = 0;
            while (n6 < n3) {
                this.pixel.getData()[n5][n6] = pageImage.pixel.getData()[n5 + this.top][n6 + this.left];
                ++n6;
            }
            ++n5;
        }
    }

    public InteriorImage(PageImage pageImage, ImagePositionInfo imagePositionInfo) {
        this(pageImage, imagePositionInfo.getX(), imagePositionInfo.getY(), imagePositionInfo.getWidth(), imagePositionInfo.getHeight());
        this.url = imagePositionInfo.getUrl();
    }

    InteriorImage(Int2D int2D) {
        super((short)10, null);
        this.pixel = int2D.deepCopy();
    }

    public InteriorImage(BufferedImage bufferedImage) throws ImageException {
        super((short)10, null);
        this.pixel = ImageUtil.bufferedImageToInt2D(bufferedImage);
    }

    public int getLeft() {
        return this.left;
    }

    public int getTop() {
        return this.top;
    }

    public String getUrl() {
        return this.url;
    }

    @Override
    public int getWidth() {
        return this.pixel.getWidth();
    }

    @Override
    public int getHeight() {
        return this.pixel.getHeight();
    }

    public String dumpLargeComponents() {
        if (this.numLargeComponents == 0) {
            return "There are no large components.";
        }
        String string = "There are " + this.numLargeComponents + " large components.\n";
        int n = 0;
        while (n < this.numLargeComponents) {
            InteriorImageComponent interiorImageComponent = this.largeComponents[n];
            ColorIRGB colorIRGB = new ColorIRGB(interiorImageComponent.getColor());
            string = String.valueOf(string) + n + ": ( " + colorIRGB.getR() + ", " + colorIRGB.getG() + ", " + colorIRGB.getB() + ")\n";
            ++n;
        }
        return string;
    }

    public void extractLargeComponents() {
        int n;
        if (this.largeComponents != null) {
            return;
        }
        Vector<InteriorImageComponent> vector = new Vector<InteriorImageComponent>();
        ColorHistogram colorHistogram = ColorHistogram.makeColorHistogram(this.pixel);
        int n2 = n = colorHistogram.getSize();
        ColorHistogramBin[] colorHistogramBinArray = colorHistogram.getSortedArrayByOccurrence();
        int n3 = 0;
        while (n3 < n) {
            if (colorHistogramBinArray[n3].occurrence < 100) {
                n2 = n3;
                break;
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < n2) {
            Vector<ConnectedComponent> vector2 = new Vector<ConnectedComponent>();
            int n4 = colorHistogramBinArray[n3].color;
            BinaryImage binaryImage = new BinaryImage(this.pixel, 0, n4);
            LabeledImage labeledImage = new LabeledImage(binaryImage, 0);
            int n5 = labeledImage.numComponents;
            ConnectedComponent[] connectedComponentArray = labeledImage.components;
            int n6 = 0;
            while (n6 < n5) {
                ConnectedComponent connectedComponent = connectedComponentArray[n6];
                if (connectedComponent.getCount() >= 100) {
                    vector2.addElement(connectedComponent);
                }
                ++n6;
            }
            if (vector2.size() > 0) {
                InteriorImageComponent interiorImageComponent = new InteriorImageComponent(this, n4, vector2);
                if (interiorImageComponent.occupation >= 5.0E-4) {
                    vector.addElement(interiorImageComponent);
                }
                vector2.removeAllElements();
            }
            ++n3;
        }
        Collections.sort(vector, new CompareByCount());
        this.numLargeComponents = vector.size();
        if (this.numLargeComponents > 0) {
            this.largeComponents = new InteriorImageComponent[this.numLargeComponents];
            n3 = 0;
            while (n3 < this.numLargeComponents) {
                this.largeComponents[n3] = (InteriorImageComponent)vector.elementAt(n3);
                ++n3;
            }
            vector.removeAllElements();
        }
    }

    public LowVisionProblemGroup[] checkColors(LowVisionType lowVisionType) throws ImageException {
        if (!lowVisionType.doChangeColors()) {
            return null;
        }
        this.extractLargeComponents();
        if (this.numLargeComponents <= 1) {
            return null;
        }
        Vector<LowVisionProblem> vector = new Vector<LowVisionProblem>();
        try {
            int n = 0;
            while (n < this.numLargeComponents - 1) {
                int n2 = n + 1;
                while (n2 < this.numLargeComponents) {
                    double d;
                    int n3;
                    int n4;
                    InteriorImageComponent interiorImageComponent = this.largeComponents[n];
                    InteriorImageComponent interiorImageComponent2 = this.largeComponents[n2];
                    int n5 = interiorImageComponent.color;
                    int n6 = interiorImageComponent2.color;
                    if (DecisionMaker.distinguishableImageColors(n5, n6) && !DecisionMaker.distinguishableImageColors(n4 = lowVisionType.convertColor(n5), n3 = lowVisionType.convertColor(n6)) && !((d = 1.0 - DecisionMaker.calcColorDistanceForImage(n4, n3)) < 0.2)) {
                        ImageColorProblem imageColorProblem = new ImageColorProblem(this, lowVisionType, d, interiorImageComponent, interiorImageComponent2);
                        imageColorProblem.setElement(this.image);
                        vector.addElement(imageColorProblem);
                    }
                    ++n2;
                }
                ++n;
            }
        }
        catch (Exception exception) {
            throw new ImageException("Exception occurred while checking colors.");
        }
        if (vector.size() > 0) {
            Collections.sort(vector, new CompareByProbability());
            LowVisionProblemGroup lowVisionProblemGroup = null;
            try {
                lowVisionProblemGroup = new LowVisionProblemGroup(vector);
            }
            catch (LowVisionProblemException lowVisionProblemException) {
                throw new ImageException("Error occurred while making an instance of LowVisionProblemGroup.");
            }
            LowVisionProblemGroup[] lowVisionProblemGroupArray = new LowVisionProblemGroup[]{lowVisionProblemGroup};
            return lowVisionProblemGroupArray;
        }
        return null;
    }

    private Vector<LowVisionProblemGroup> collectProblems(Vector<LowVisionProblem> vector) throws ImageException {
        if (vector == null || vector.size() == 0) {
            return null;
        }
        Vector<LowVisionProblemGroup> vector2 = new Vector<LowVisionProblemGroup>();
        int n = vector.size();
        while (n > 0) {
            LowVisionProblem lowVisionProblem = vector.elementAt(n - 1);
            vector.removeElementAt(n - 1);
            Vector<LowVisionProblem> vector3 = new Vector<LowVisionProblem>();
            vector3.addElement(lowVisionProblem);
            short s = lowVisionProblem.getType();
            int n2 = n - 2;
            while (n2 >= 0) {
                LowVisionProblem lowVisionProblem2 = vector.elementAt(n2);
                if (lowVisionProblem2.getType() == s) {
                    vector.removeElementAt(n2);
                    vector3.addElement(lowVisionProblem2);
                }
                --n2;
            }
            Collections.sort(vector3, new CompareByProbability());
            LowVisionProblemGroup lowVisionProblemGroup = null;
            try {
                lowVisionProblemGroup = new LowVisionProblemGroup(vector3);
            }
            catch (LowVisionProblemException lowVisionProblemException) {
                throw new ImageException("Error occurred while making an instance of LowVisionProblemGroup.");
            }
            vector2.addElement(lowVisionProblemGroup);
            n = vector.size();
        }
        return vector2;
    }

    public Int2D simulate(LowVisionType lowVisionType) throws ImageException {
        LowVisionFilter lowVisionFilter = new LowVisionFilter(lowVisionType);
        try {
            Int2D int2D = ImageUtil.bufferedImageToInt2D(lowVisionFilter.filter(this.pixel.toBufferedImage(), null));
            return int2D;
        }
        catch (LowVisionException lowVisionException) {
            throw new ImageException("Exception occurred while simulating an interiorImage");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CompareByCount
    implements Comparator<InteriorImageComponent> {
        private CompareByCount() {
        }

        @Override
        public int compare(InteriorImageComponent interiorImageComponent, InteriorImageComponent interiorImageComponent2) {
            return interiorImageComponent2.count - interiorImageComponent.count;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CompareByProbability
    implements Comparator<LowVisionProblem> {
        private CompareByProbability() {
        }

        @Override
        public int compare(LowVisionProblem lowVisionProblem, LowVisionProblem lowVisionProblem2) {
            double d = lowVisionProblem2.getProbability() - lowVisionProblem.getProbability();
            if (d > 0.0) {
                return 1;
            }
            if (d < 0.0) {
                return -1;
            }
            return 0;
        }
    }
}

