/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.cdt.autotools.ui.editors.automake;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ContextInformation;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationPresenter;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.linuxtools.internal.cdt.autotools.ui.MakeUIImages;
import org.eclipse.linuxtools.internal.cdt.autotools.ui.editors.automake.AutomakeEditorFactory;
import org.eclipse.linuxtools.internal.cdt.autotools.ui.editors.automake.CompletionProposalComparator;
import org.eclipse.linuxtools.internal.cdt.autotools.ui.editors.automake.IDirective;
import org.eclipse.linuxtools.internal.cdt.autotools.ui.editors.automake.IMacroDefinition;
import org.eclipse.linuxtools.internal.cdt.autotools.ui.editors.automake.IMakefile;
import org.eclipse.linuxtools.internal.cdt.autotools.ui.editors.automake.IRule;
import org.eclipse.linuxtools.internal.cdt.autotools.ui.editors.automake.IWorkingCopyManager;
import org.eclipse.linuxtools.internal.cdt.autotools.ui.editors.automake.WordPartDetector;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;

public class MakefileCompletionProcessor
implements IContentAssistProcessor {
    protected IContextInformationValidator fValidator = new Validator();
    protected Image imageMacro = MakeUIImages.getImage(MakeUIImages.IMG_OBJS_MAKEFILE_MACRO);
    protected Image imageTarget = MakeUIImages.getImage(MakeUIImages.IMG_OBJS_MAKEFILE_TARGET_RULE);
    protected CompletionProposalComparator comparator = new CompletionProposalComparator();
    protected IEditorPart fEditor;
    protected IWorkingCopyManager fManager;

    public MakefileCompletionProcessor(IEditorPart editor) {
        this.fEditor = editor;
        this.fManager = AutomakeEditorFactory.getDefault().getWorkingCopyManager();
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int documentOffset) {
        WordPartDetector wordPart = new WordPartDetector(viewer, documentOffset);
        boolean macro = WordPartDetector.inMacro(viewer, documentOffset);
        IMakefile makefile = this.fManager.getWorkingCopy(this.fEditor.getEditorInput());
        IDirective[] statements = null;
        if (macro) {
            IMacroDefinition[] m1 = makefile.getMacroDefinitions();
            IMacroDefinition[] m2 = makefile.getBuiltinMacroDefinitions();
            statements = new IDirective[m1.length + m2.length];
            System.arraycopy(m1, 0, statements, 0, m1.length);
            System.arraycopy(m2, 0, statements, m1.length, m2.length);
        } else {
            statements = makefile.getTargetRules();
        }
        ArrayList<CompletionProposal> proposalList = new ArrayList<CompletionProposal>(statements.length);
        int i = 0;
        while (i < statements.length) {
            String name = null;
            Image image = null;
            String infoString = "";
            if (statements[i] instanceof IMacroDefinition) {
                name = ((IMacroDefinition)statements[i]).getName();
                image = this.imageMacro;
                infoString = ((IMacroDefinition)statements[i]).getValue().toString();
            } else if (statements[i] instanceof IRule) {
                name = ((IRule)statements[i]).getTarget().toString();
                image = this.imageTarget;
                infoString = name;
            }
            if (name != null && name.startsWith(wordPart.toString())) {
                ContextInformation info = new ContextInformation(name, infoString);
                String displayString = name.equals(infoString) ? name : String.valueOf(name) + " - " + infoString;
                CompletionProposal result = new CompletionProposal(name, wordPart.getOffset(), wordPart.toString().length(), name.length(), image, displayString, (IContextInformation)info, infoString);
                proposalList.add(result);
            }
            ++i;
        }
        ICompletionProposal[] proposals = proposalList.toArray(new ICompletionProposal[0]);
        Arrays.sort(proposals, this.comparator);
        return proposals;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int documentOffset) {
        int i;
        WordPartDetector wordPart = new WordPartDetector(viewer, documentOffset);
        boolean macro = WordPartDetector.inMacro(viewer, documentOffset);
        IMakefile makefile = this.fManager.getWorkingCopy(this.fEditor.getEditorInput());
        ArrayList<String> contextList = new ArrayList<String>();
        if (macro) {
            String value;
            String name;
            IMacroDefinition[] statements = makefile.getMacroDefinitions();
            i = 0;
            while (i < statements.length) {
                if (statements[i] instanceof IMacroDefinition && (name = statements[i].getName()) != null && name.equals(wordPart.toString()) && (value = statements[i].getValue().toString()) != null && value.length() > 0) {
                    contextList.add(value);
                }
                ++i;
            }
            statements = makefile.getBuiltinMacroDefinitions();
            i = 0;
            while (i < statements.length) {
                name = statements[i].getName();
                if (name != null && name.equals(wordPart.toString()) && (value = statements[i].getValue().toString()) != null && value.length() > 0) {
                    contextList.add(value);
                }
                ++i;
            }
        }
        IContextInformation[] result = new IContextInformation[contextList.size()];
        i = 0;
        while (i < result.length) {
            String context = (String)contextList.get(i);
            result[i] = new ContextInformation(this.imageMacro, wordPart.toString(), context);
            ++i;
        }
        return result;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return null;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return this.fValidator;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DirectiveComparator
    implements Comparator<Object> {
        @Override
        public int compare(Object o1, Object o2) {
            String name1 = o1 instanceof IMacroDefinition ? ((IMacroDefinition)o1).getName() : (o1 instanceof IRule ? ((IRule)o1).getTarget().toString() : "");
            String name2 = o2 instanceof IMacroDefinition ? ((IMacroDefinition)o1).getName() : (o2 instanceof IRule ? ((IRule)o1).getTarget().toString() : "");
            return name1.compareToIgnoreCase(name2);
        }
    }

    protected static class Validator
    implements IContextInformationValidator,
    IContextInformationPresenter {
        protected int fInstallOffset;

        protected Validator() {
        }

        public boolean isContextInformationValid(int offset) {
            return Math.abs(this.fInstallOffset - offset) < 5;
        }

        public void install(IContextInformation info, ITextViewer viewer, int offset) {
            this.fInstallOffset = offset;
        }

        public boolean updatePresentation(int documentPosition, TextPresentation presentation) {
            return false;
        }
    }
}

